/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.webbeans.Container;
import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.servlet.ServletLifecycle;
import org.jboss.webbeans.servlet.api.helpers.AbstractServletListener;

public class WebBeansListener
extends AbstractServletListener {
    private ServletLifecycle lifecycle;

    private ServletLifecycle getLifecycle() {
        if (this.lifecycle == null) {
            this.lifecycle = new ServletLifecycle(Container.instance().deploymentServices().get(ContextLifecycle.class));
        }
        return this.lifecycle;
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (Container.instance() != null && Container.instance().isInitialized()) {
            this.getLifecycle().beginSession(event.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (Container.instance() != null && Container.instance().isInitialized()) {
            this.getLifecycle().endSession(event.getSession());
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (Container.instance() != null && Container.instance().isInitialized()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                this.getLifecycle().endRequest((HttpServletRequest)event.getServletRequest());
            } else {
                throw new IllegalStateException("Non HTTP-Servlet lifecycle not defined");
            }
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (Container.instance() != null && Container.instance().isInitialized()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                this.getLifecycle().beginRequest((HttpServletRequest)event.getServletRequest());
            } else {
                throw new IllegalStateException("Non HTTP-Servlet lifecycle not defined");
            }
        }
    }
}

