/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorates;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.SessionBean;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.injection.ConstructorInjectionPoint;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.injection.spi.EjbInjectionServices;
import org.jboss.webbeans.injection.spi.JpaInjectionServices;
import org.jboss.webbeans.injection.spi.ResourceInjectionServices;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.cache.BindingTypeModel;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beans {
    private static final Log log = Logging.getLog(Beans.class);

    public static boolean isPassivatingScope(Bean<?> bean, BeanManagerImpl manager) {
        if (bean instanceof SessionBean) {
            return ((SessionBean)bean).getEjbDescriptor().isStateful();
        }
        return manager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isPassivating();
    }

    public static boolean isPassivationCapableBean(Bean<?> bean) {
        if (bean instanceof SessionBean) {
            return ((SessionBean)bean).getEjbDescriptor().isStateful();
        }
        if (bean instanceof AbstractProducerBean) {
            return Reflections.isSerializable(((AbstractProducerBean)bean).getType());
        }
        return Reflections.isSerializable(bean.getBeanClass());
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static Set<FieldInjectionPoint<?, ?>> getFieldInjectionPoints(Bean<?> declaringBean, WBClass<?> annotatedItem) {
        HashSet injectableFields = new HashSet();
        for (WBField<?, ?> annotatedField : annotatedItem.getAnnotatedWBFields(Inject.class)) {
            Beans.addFieldInjectionPoint(annotatedField, injectableFields, declaringBean);
        }
        for (WBField<?, ?> annotatedField : annotatedItem.getAnnotatedWBFields(Decorates.class)) {
            Beans.addFieldInjectionPoint(annotatedField, injectableFields, declaringBean);
        }
        return injectableFields;
    }

    public static WBMethod<?, ?> getPostConstruct(WBClass<?> type) {
        Set<WBMethod<?, ?>> postConstructMethods = type.getAnnotatedWBMethods(PostConstruct.class);
        log.trace((Object)("Found " + postConstructMethods + " constructors annotated with @Initializer for " + type), new Object[0]);
        if (postConstructMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one post construct method annotated with @PostConstruct for " + type);
        }
        if (postConstructMethods.size() == 1) {
            WBMethod<?, ?> postConstruct = postConstructMethods.iterator().next();
            log.trace((Object)("Exactly one post construct method (" + postConstruct + ") for " + type), new Object[0]);
            return postConstruct;
        }
        return null;
    }

    public static WBMethod<?, ?> getPreDestroy(WBClass<?> type) {
        Set<WBMethod<?, ?>> preDestroyMethods = type.getAnnotatedWBMethods(PreDestroy.class);
        log.trace((Object)("Found " + preDestroyMethods + " constructors annotated with @Initializer for " + type), new Object[0]);
        if (preDestroyMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one pre destroy method annotated with @PreDestroy for " + type);
        }
        if (preDestroyMethods.size() == 1) {
            WBMethod<?, ?> preDestroy = preDestroyMethods.iterator().next();
            log.trace((Object)("Exactly one post construct method (" + preDestroy + ") for " + type), new Object[0]);
            return preDestroy;
        }
        return null;
    }

    public static Set<WBInjectionPoint<?, ?>> getEjbInjectionPoints(Bean<?> declaringBean, WBClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(EjbInjectionServices.class)) {
            Class<? extends Annotation> ejbAnnotationType = manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS;
            HashSet ejbInjectionPoints = new HashSet();
            for (WBField<?, ?> field : type.getAnnotatedWBFields(ejbAnnotationType)) {
                ejbInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return ejbInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<WBInjectionPoint<?, ?>> getPersistenceContextInjectionPoints(Bean<?> declaringBean, WBClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            HashSet jpaInjectionPoints = new HashSet();
            Class<? extends Annotation> persistenceContextAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            for (WBField<?, ?> field : type.getAnnotatedWBFields(persistenceContextAnnotationType)) {
                jpaInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return jpaInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<WBInjectionPoint<?, ?>> getPersistenceUnitInjectionPoints(Bean<?> declaringBean, WBClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            HashSet jpaInjectionPoints = new HashSet();
            Class<? extends Annotation> persistenceUnitAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_UNIT_ANNOTATION_CLASS;
            for (WBField<?, ?> field : type.getAnnotatedWBFields(persistenceUnitAnnotationType)) {
                jpaInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return jpaInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<WBInjectionPoint<?, ?>> getResourceInjectionPoints(Bean<?> declaringBean, WBClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(ResourceInjectionServices.class)) {
            Class<? extends Annotation> resourceAnnotationType = manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS;
            HashSet resourceInjectionPoints = new HashSet();
            for (WBField<?, ?> field : type.getAnnotatedWBFields(resourceAnnotationType)) {
                resourceInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return resourceInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<MethodInjectionPoint<?, ?>> getInitializerMethods(Bean<?> declaringBean, WBClass<?> type) {
        HashSet initializerMethods = new HashSet();
        for (WBMethod<?, ?> method : type.getAnnotatedWBMethods(Inject.class)) {
            if (method.isStatic()) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be static on " + type);
            }
            if (method.getAnnotation(Produces.class) != null) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Produces on " + type);
            }
            if (method.getAnnotatedWBParameters(Disposes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot have parameters annotated @Disposes on " + type);
            }
            if (method.getAnnotatedWBParameters(Observes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Observes on " + type);
            }
            MethodInjectionPoint<?, ?> initializerMethod = MethodInjectionPoint.of(declaringBean, method);
            initializerMethods.add(initializerMethod);
        }
        return initializerMethods;
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, WBConstructor<?> constructor) {
        HashSet injectionPoints = new HashSet();
        for (WBParameter<?, ?> parameter : constructor.getWBParameters()) {
            injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
        }
        return injectionPoints;
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, Set<MethodInjectionPoint<?, ?>> methodInjectionPoints) {
        HashSet injectionPoints = new HashSet();
        for (MethodInjectionPoint<?, ?> method : methodInjectionPoints) {
            for (ParameterInjectionPoint<?, ?> parameter : method.getWBParameters()) {
                injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
            }
        }
        return injectionPoints;
    }

    private static void addFieldInjectionPoint(WBField<?, ?> annotatedField, Set<FieldInjectionPoint<?, ?>> injectableFields, Bean<?> declaringBean) {
        if (!annotatedField.isAnnotationPresent(Produces.class)) {
            if (annotatedField.isStatic()) {
                throw new DefinitionException("Don't place binding annotations on static fields " + annotatedField);
            }
            if (annotatedField.isFinal()) {
                throw new DefinitionException("Don't place binding annotations on final fields " + annotatedField);
            }
            FieldInjectionPoint<?, ?> fieldInjectionPoint = FieldInjectionPoint.of(declaringBean, annotatedField);
            injectableFields.add(fieldInjectionPoint);
        }
    }

    public static boolean containsAllBindings(Set<Annotation> bindings1, Set<Annotation> bindings2, BeanManagerImpl manager) {
        for (Annotation binding : bindings1) {
            BindingTypeModel<? extends Annotation> bindingType = manager.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(binding.annotationType());
            boolean matchFound = false;
            for (Annotation otherBinding : bindings2) {
                if (!bindingType.isEqual(binding, otherBinding)) continue;
                matchFound = true;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static <T extends Bean<?>> Set<T> retainEnabledPolicies(Set<T> beans, Collection<Class<?>> enabledPolicyClasses, Collection<Class<? extends Annotation>> enabledPolicySterotypes) {
        if (beans.size() == 0) {
            return beans;
        }
        HashSet<Bean> enabledBeans = new HashSet<Bean>();
        for (Bean bean : beans) {
            if (!Beans.isBeanEnabled(bean, enabledPolicyClasses, enabledPolicySterotypes)) continue;
            enabledBeans.add(bean);
        }
        return enabledBeans;
    }

    public static boolean isBeanEnabled(Bean<?> bean, Collection<Class<?>> enabledPolicyClasses, Collection<Class<? extends Annotation>> enabledPolicySterotypes) {
        if (bean.isAlternative()) {
            if (enabledPolicyClasses.contains(bean.getBeanClass())) {
                return true;
            }
            for (Class<Annotation> stereotype : bean.getStereotypes()) {
                if (!enabledPolicySterotypes.contains(stereotype)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static <X> boolean isPolicyPresent(Set<Bean<? extends X>> beans) {
        for (Bean<X> bean : beans) {
            if (!bean.isAlternative()) continue;
            return true;
        }
        return false;
    }

    public static <X> boolean isSpecialized(Bean<? extends X> bean, Set<Bean<? extends X>> beans, Map<Contextual<?>, Contextual<?>> specializedBeans) {
        return specializedBeans.containsKey(bean) && beans.contains(specializedBeans.get(bean));
    }

    public static <T> ConstructorInjectionPoint<T> getBeanConstructor(Bean<?> declaringBean, WBClass<T> type) {
        ConstructorInjectionPoint<T> constructor = null;
        Set<WBConstructor<T>> initializerAnnotatedConstructors = type.getAnnotatedWBConstructors(Inject.class);
        log.trace((Object)("Found " + initializerAnnotatedConstructors + " constructors annotated with @Initializer for " + type), new Object[0]);
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException("Cannot have more than one constructor annotated with @Initializer for " + type);
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            constructor = ConstructorInjectionPoint.of(declaringBean, initializerAnnotatedConstructors.iterator().next());
            log.trace((Object)("Exactly one constructor (" + constructor + ") annotated with @Initializer defined, using it as the bean constructor for " + type), new Object[0]);
        } else if (type.getNoArgsWBConstructor() != null) {
            constructor = ConstructorInjectionPoint.of(declaringBean, type.getNoArgsWBConstructor());
            log.trace((Object)("Exactly one constructor (" + constructor + ") defined, using it as the bean constructor for " + type), new Object[0]);
        }
        if (constructor == null) {
            throw new DefinitionException("Cannot determine constructor to use for " + type);
        }
        return constructor;
    }

    public static <T> void injectEEFields(T beanInstance, BeanManagerImpl manager, Iterable<WBInjectionPoint<?, ?>> ejbInjectionPoints, Iterable<WBInjectionPoint<?, ?>> persistenceContextInjectionPoints, Iterable<WBInjectionPoint<?, ?>> persistenceUnitInjectionPoints, Iterable<WBInjectionPoint<?, ?>> resourceInjectionPoints) {
        EjbInjectionServices ejbServices = manager.getServices().get(EjbInjectionServices.class);
        JpaInjectionServices jpaServices = manager.getServices().get(JpaInjectionServices.class);
        ResourceInjectionServices resourceServices = manager.getServices().get(ResourceInjectionServices.class);
        if (ejbServices != null) {
            for (WBInjectionPoint<?, ?> injectionPoint : ejbInjectionPoints) {
                Object ejbInstance = ejbServices.resolveEjb(injectionPoint);
                injectionPoint.inject(beanInstance, ejbInstance);
            }
        }
        if (jpaServices != null) {
            for (WBInjectionPoint<?, ?> injectionPoint : persistenceContextInjectionPoints) {
                EntityManager pcInstance = jpaServices.resolvePersistenceContext(injectionPoint);
                injectionPoint.inject(beanInstance, pcInstance);
            }
            for (WBInjectionPoint<?, ?> injectionPoint : persistenceUnitInjectionPoints) {
                EntityManagerFactory puInstance = jpaServices.resolvePersistenceUnit(injectionPoint);
                injectionPoint.inject(beanInstance, puInstance);
            }
        }
        if (resourceServices != null) {
            for (WBInjectionPoint<?, ?> injectionPoint : resourceInjectionPoints) {
                Object resourceInstance = resourceServices.resolveResource(injectionPoint);
                injectionPoint.inject(beanInstance, resourceInstance);
            }
        }
    }

    public static <T> void injectBoundFields(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<FieldInjectionPoint<?, ?>> injectableFields) {
        for (FieldInjectionPoint<T, T> fieldInjectionPoint : injectableFields) {
            fieldInjectionPoint.inject(instance, manager, creationalContext);
        }
    }

    public static <T> void callInitializers(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends MethodInjectionPoint<?, ?>> initializerMethods) {
        for (MethodInjectionPoint<T, T> methodInjectionPoint : initializerMethods) {
            methodInjectionPoint.invoke(instance, manager, creationalContext, CreationException.class);
        }
    }
}

