/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans.ejb;

import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.webbeans.ejb.BusinessInterfaceDescriptorImpl;
import org.jboss.webbeans.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private com.sun.enterprise.deployment.EjbDescriptor ejbDesc;

    public EjbDescriptorImpl(com.sun.enterprise.deployment.EjbDescriptor e) {
        this.ejbDesc = e;
    }

    public String getEjbName() {
        return this.ejbDesc.getName();
    }

    public com.sun.enterprise.deployment.EjbDescriptor getEjbDescriptor() {
        return this.ejbDesc;
    }

    public Class<T> getBeanClass() {
        Class<?> beanClassType = null;
        try {
            beanClassType = this.ejbDesc.getEjbBundleDescriptor().getClassLoader().loadClass(this.ejbDesc.getEjbClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return beanClassType;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        HashSet localBusIntfs = new HashSet();
        if (this.ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.ejbDesc;
            Set localNames = sessionDesc.getLocalBusinessClassNames();
            if (sessionDesc.isLocalBean()) {
                localNames.add(sessionDesc.getEjbClassName());
            }
            for (String local : localNames) {
                try {
                    Class<?> localClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(local);
                    BusinessInterfaceDescriptorImpl busIntfDesc = new BusinessInterfaceDescriptorImpl(localClass);
                    localBusIntfs.add(busIntfDesc);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return localBusIntfs;
    }

    public Collection<Method> getRemoveMethods() {
        EjbSessionDescriptor sessionDesc;
        HashSet<Method> removeMethods = new HashSet<Method>();
        if (this.ejbDesc.getType().equals("Session") && (sessionDesc = (EjbSessionDescriptor)this.ejbDesc).isStateful() && sessionDesc.hasRemoveMethods()) {
            for (EjbRemovalInfo next : sessionDesc.getAllRemovalInfo()) {
                MethodDescriptor mDesc = next.getRemoveMethod();
                Method m = mDesc.getMethod(this.ejbDesc);
                if (m == null) {
                    throw new IllegalStateException("Can't resolve remove method " + mDesc + " For EJB " + sessionDesc.getName());
                }
                removeMethods.add(m);
            }
        }
        return removeMethods;
    }

    public boolean isStateless() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isStateless();
    }

    public boolean isSingleton() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isSingleton();
    }

    public boolean isStateful() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isStateful();
    }

    public boolean isMessageDriven() {
        return this.ejbDesc.getType().equals("Message-driven");
    }
}

