/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptionTypeRegistry;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.model.InterceptorMetadataException;
import org.jboss.interceptor.model.MethodHolder;
import org.jboss.interceptor.registry.InterceptorClassMetadataRegistry;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassMetadataImpl
implements InterceptorClassMetadata,
Serializable {
    private Log log = LogFactory.getLog(InterceptorClassMetadataImpl.class);
    private Class<?> interceptorClass;
    private Map<InterceptionType, List<Method>> methodMap = new HashMap<InterceptionType, List<Method>>();
    private boolean hasInterceptorMethods;

    public InterceptorClassMetadataImpl(Class<?> interceptorClass) {
        this.interceptorClass = interceptorClass;
        Class<?> currentClass = interceptorClass;
        HashSet<MethodHolder> foundMethods = new HashSet<MethodHolder>();
        do {
            HashSet<InterceptionType> detectedInterceptorTypes = new HashSet<InterceptionType>();
            for (Method method : currentClass.getDeclaredMethods()) {
                for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
                    if (!InterceptionUtils.isInterceptorMethod(interceptionType, method)) continue;
                    if (this.methodMap.get((Object)interceptionType) == null) {
                        this.methodMap.put(interceptionType, new LinkedList());
                    }
                    if (detectedInterceptorTypes.contains((Object)interceptionType)) {
                        throw new InterceptorMetadataException("Same interception type cannot be specified twice on the same class");
                    }
                    detectedInterceptorTypes.add(interceptionType);
                    ReflectionUtils.ensureAccessible(method);
                    if (foundMethods.contains(new MethodHolder(method, false))) continue;
                    this.methodMap.get((Object)interceptionType).add(0, method);
                    this.hasInterceptorMethods = true;
                }
                foundMethods.add(new MethodHolder(method, false));
            }
        } while (!Object.class.equals(currentClass = currentClass.getSuperclass()));
    }

    @Override
    public Class<?> getInterceptorClass() {
        return this.interceptorClass;
    }

    @Override
    public List<Method> getInterceptorMethods(InterceptionType interceptionType) {
        List<Method> methods = this.methodMap.get((Object)interceptionType);
        return methods == null ? Collections.EMPTY_LIST : methods;
    }

    @Override
    public boolean isInterceptor() {
        return this.hasInterceptorMethods;
    }

    private Object writeReplace() {
        return new InterceptorClassMetadataSerializationProxy(this.getInterceptorClass().getName());
    }

    static class InterceptorClassMetadataSerializationProxy
    implements Serializable {
        private String className;

        InterceptorClassMetadataSerializationProxy(String className) {
            this.className = className;
        }

        private Object readResolve() {
            try {
                return InterceptorClassMetadataRegistry.getRegistry().getInterceptorClassMetadata(ReflectionUtils.classForName(this.className));
            }
            catch (ClassNotFoundException e) {
                throw new InterceptorException("Failed to deserialize the interceptor class metadata", e);
            }
        }
    }
}

