/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jvnet.hk2.component.Habitat;

public class TransactionServicesImpl
implements TransactionServices {
    private JavaEETransactionManager transactionManager = null;

    public TransactionServicesImpl(Habitat habitat) {
        this.transactionManager = (JavaEETransactionManager)habitat.getByContract(JavaEETransactionManager.class);
        if (this.transactionManager == null) {
            throw new RuntimeException("Unable to retrieve transaction mgr.");
        }
    }

    public boolean isTransactionActive() {
        try {
            return this.transactionManager.getStatus() == 0;
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to determine transaction status", e);
        }
    }

    public void registerSynchronization(Synchronization observer) {
        try {
            this.transactionManager.registerSynchronization(observer);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register synchronization " + observer + " for current transaction", e);
        }
    }

    public UserTransaction getUserTransaction() {
        try {
            InitialContext c = new InitialContext();
            UserTransaction ut = (UserTransaction)c.lookup("javax.jts.UserTransaction");
            return ut;
        }
        catch (NamingException e) {
            return null;
        }
    }

    public void cleanup() {
    }
}

