/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentImpl
implements Deployment {
    private Logger logger = Logger.getLogger(DeploymentImpl.class.getName());
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private static final String EXPLODED_WAR_SUFFIX = "_war/";
    private static final String EXPLODED_JAR_SUFFIX = "_jar/";
    private static final char SEPARATOR_CHAR = '/';
    private List<Class<?>> wbClasses = new ArrayList();
    private List<URL> wbUrls = new ArrayList<URL>();
    private ReadableArchive archive;
    private final List<BeanDeploymentArchive> beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
    private Collection<EjbDescriptor> ejbs;
    private Map<String, BeanDeploymentArchive> idToBeanDeploymentArchive;
    private SimpleServiceRegistry simpleServiceRegistry = null;

    public DeploymentImpl(ReadableArchive archive, Collection<EjbDescriptor> ejbs) {
        this.archive = archive;
        this.ejbs = ejbs;
        this.idToBeanDeploymentArchive = new HashMap<String, BeanDeploymentArchive>();
        this.scan();
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        if (this.beanDeploymentArchives.size() > 0) {
            return this.beanDeploymentArchives;
        }
        return Collections.emptyList();
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        Collection beanDeploymentArchives = this.getBeanDeploymentArchives();
        ListIterator lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = (BeanDeploymentArchive)lIter.next();
            if (!bda.getBeanClasses().contains(beanClass)) continue;
            return bda;
        }
        ArrayList wClasses = new ArrayList();
        ArrayList<URL> wUrls = new ArrayList<URL>();
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        wClasses.add(beanClass);
        BeanDeploymentArchiveImpl newBda = new BeanDeploymentArchiveImpl(beanClass.getName(), wClasses, wUrls, ejbs);
        lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = (BeanDeploymentArchive)lIter.next();
            bda.getBeanDeploymentArchives().add(newBda);
        }
        this.idToBeanDeploymentArchive.put(beanClass.getName(), newBda);
        return newBda;
    }

    public ServiceRegistry getServices() {
        if (null == this.simpleServiceRegistry) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public void scanArchive(ReadableArchive archive, Collection<EjbDescriptor> ejbs) {
        this.wbClasses = new ArrayList();
        this.wbUrls = new ArrayList<URL>();
        this.ejbs = ejbs;
        this.archive = archive;
        this.scan();
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForArchive(String archiveId) {
        return this.idToBeanDeploymentArchive.get(archiveId);
    }

    public List<BeanDeploymentArchive> getWarBeanDeploymentArchives() {
        ArrayList<BeanDeploymentArchive> warBDAs = new ArrayList<BeanDeploymentArchive>();
        Set<Map.Entry<String, BeanDeploymentArchive>> set = this.idToBeanDeploymentArchive.entrySet();
        for (Map.Entry<String, BeanDeploymentArchive> me : set) {
            if (!me.getKey().endsWith(EXPLODED_WAR_SUFFIX)) continue;
            warBDAs.add(me.getValue());
        }
        return warBDAs;
    }

    public List<BeanDeploymentArchive> getJarBeanDeploymentArchives() {
        ArrayList<BeanDeploymentArchive> jarBDAs = new ArrayList<BeanDeploymentArchive>();
        Set<Map.Entry<String, BeanDeploymentArchive>> set = this.idToBeanDeploymentArchive.entrySet();
        for (Map.Entry<String, BeanDeploymentArchive> me : set) {
            if (!me.getKey().endsWith(EXPLODED_JAR_SUFFIX)) continue;
            jarBDAs.add(me.getValue());
        }
        return jarBDAs;
    }

    private void scan() {
        try {
            String entry;
            Enumeration entries;
            if (this.archive.exists(WEB_INF_BEANS_XML)) {
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (entry.endsWith(CLASS_SUFFIX)) {
                        entry = entry.substring(WEB_INF_CLASSES.length() + 1);
                        String className = DeploymentImpl.filenameToClassname(entry);
                        this.wbClasses.add(this.getClassLoader().loadClass(className));
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    URI uri = this.archive.getURI();
                    File file = new File(uri.getPath() + entry);
                    URL beansXmlUrl = file.toURL();
                    this.wbUrls.add(beansXmlUrl);
                }
                this.archive.close();
            }
            if (this.archive.exists(WEB_INF_LIB)) {
                entries = this.archive.entries(WEB_INF_LIB);
                while (entries.hasMoreElements()) {
                    ReadableArchive jarArchive;
                    entry = (String)entries.nextElement();
                    if (!entry.endsWith(JAR_SUFFIX) || entry.indexOf(47, WEB_INF_LIB.length() + 1) != -1 || !(jarArchive = this.archive.getSubArchive(entry)).exists(META_INF_BEANS_XML)) continue;
                    this.collectJarInfo(jarArchive);
                }
            }
            if (this.archive.exists(META_INF_BEANS_XML)) {
                this.collectJarInfo(this.archive);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
        String archiveId = this.archive.getURI().getPath();
        BeanDeploymentArchiveImpl beanDeploymentArchive = new BeanDeploymentArchiveImpl(archiveId, this.wbClasses, this.wbUrls, this.ejbs);
        this.idToBeanDeploymentArchive.put(archiveId, beanDeploymentArchive);
        this.beanDeploymentArchives.add(beanDeploymentArchive);
    }

    private void collectJarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            if (entry.endsWith(CLASS_SUFFIX)) {
                String className = DeploymentImpl.filenameToClassname(entry);
                this.wbClasses.add(this.getClassLoader().loadClass(className));
                continue;
            }
            if (!entry.endsWith("beans.xml")) continue;
            URL beansXmlUrl = Thread.currentThread().getContextClassLoader().getResource(entry);
            this.wbUrls.add(beansXmlUrl);
        }
        archive.close();
    }

    private static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return DeploymentImpl.class.getClassLoader();
    }
}

