/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.model.MethodHolder;
import org.jboss.interceptor.proxy.DirectClassInterceptionHandler;
import org.jboss.interceptor.proxy.InterceptionChain;
import org.jboss.interceptor.proxy.InterceptionHandler;
import org.jboss.interceptor.proxy.InterceptionHandlerFactory;
import org.jboss.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.registry.InterceptorClassMetadataRegistry;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMethodHandler
implements MethodHandler,
Serializable {
    private static ThreadLocal<Set<MethodHolder>> interceptionStack = new ThreadLocal();
    private final Object target;
    private Map<Object, InterceptionHandler> interceptorHandlerInstances = new HashMap<Object, InterceptionHandler>();
    private Class<?> targetClazz;
    private InterceptorClassMetadata targetClassInterceptorMetadata;
    private List<InterceptionModel<Class<?>, ?>> interceptionModels;

    public InterceptorMethodHandler(Object target, Class<?> targetClass, List<InterceptionModel<Class<?>, ?>> interceptionModels, List<InterceptionHandlerFactory<?>> interceptionHandlerFactories) {
        if (interceptionModels == null) {
            throw new IllegalArgumentException("Interception model must not be null");
        }
        if (interceptionHandlerFactories == null) {
            throw new IllegalArgumentException("Interception handler factory must not be null");
        }
        if (interceptionModels.size() != interceptionHandlerFactories.size()) {
            throw new IllegalArgumentException("For each interception model, an interception factory must be provided");
        }
        this.interceptionModels = interceptionModels;
        this.target = target == null ? this : target;
        this.targetClazz = targetClass != null ? targetClass : this.target.getClass();
        for (int i = 0; i < interceptionModels.size(); ++i) {
            for (Object interceptorReference : this.interceptionModels.get(i).getAllInterceptors()) {
                this.interceptorHandlerInstances.put(interceptorReference, interceptionHandlerFactories.get(i).createFor(interceptorReference));
            }
        }
        this.targetClassInterceptorMetadata = InterceptorClassMetadataRegistry.getRegistry().getInterceptorClassMetadata(this.targetClazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        ReflectionUtils.ensureAccessible(thisMethod);
        if (this.getInterceptionStack().contains(new MethodHolder(thisMethod, true))) {
            return thisMethod.invoke(this.target, args);
        }
        try {
            this.getInterceptionStack().add(new MethodHolder(thisMethod, true));
            if (!thisMethod.getDeclaringClass().equals(LifecycleMixin.class)) {
                if (!InterceptionUtils.isInterceptionCandidate(thisMethod)) {
                    Object object = thisMethod.invoke(this.target, args);
                    return object;
                }
                Object object = this.executeInterception(thisMethod, args, InterceptionType.AROUND_INVOKE);
                return object;
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
                Object object = this.executeInterception(null, null, InterceptionType.POST_CONSTRUCT);
                return object;
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
                Object object = this.executeInterception(null, null, InterceptionType.PRE_DESTROY);
                return object;
            }
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            this.getInterceptionStack().remove(new MethodHolder(thisMethod, true));
        }
    }

    private Set<MethodHolder> getInterceptionStack() {
        if (interceptionStack.get() == null) {
            interceptionStack.set(new HashSet());
        }
        return interceptionStack.get();
    }

    private Object executeInterception(Method thisMethod, Object[] args, InterceptionType interceptionType) throws Throwable {
        ArrayList<InterceptionHandler> interceptionHandlers = new ArrayList<InterceptionHandler>();
        for (InterceptionModel<Class<?>, ?> interceptionModel : this.interceptionModels) {
            List<?> interceptorList = interceptionModel.getInterceptors(interceptionType, thisMethod);
            for (Object interceptorReference : interceptorList) {
                interceptionHandlers.add(this.interceptorHandlerInstances.get(interceptorReference));
            }
        }
        if (this.targetClassInterceptorMetadata.getInterceptorMethods(interceptionType) != null && !this.targetClassInterceptorMetadata.getInterceptorMethods(interceptionType).isEmpty()) {
            interceptionHandlers.add(new DirectClassInterceptionHandler(this.target, this.targetClazz));
        }
        InterceptionChain chain = new InterceptionChain(interceptionHandlers, interceptionType, this.target, thisMethod, args);
        return chain.invokeNext(new InterceptorInvocationContext(chain, this.target, thisMethod, args));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.executeInterception(null, null, InterceptionType.PRE_PASSIVATE);
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            throw new IOException("Error while serializing class", throwable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.executeInterception(null, null, InterceptionType.POST_ACTIVATE);
        }
        catch (Throwable throwable) {
            throw new IOException("Error while deserializing class", throwable);
        }
    }
}

