/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.weld.WeldDeployer;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class JCDIServiceImpl
implements JCDIService {
    @Inject
    private WeldDeployer weldDeployer;
    @Inject
    private Habitat h;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;

    public boolean isCurrentModuleJCDIEnabled() {
        BundleDescriptor bundle = null;
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            return false;
        }
        JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
        if (componentEnv != null) {
            if (componentEnv instanceof BundleDescriptor) {
                bundle = (BundleDescriptor)componentEnv;
            } else if (componentEnv instanceof com.sun.enterprise.deployment.EjbDescriptor) {
                bundle = ((com.sun.enterprise.deployment.EjbDescriptor)componentEnv).getEjbBundleDescriptor();
            }
        }
        return bundle != null ? this.isJCDIEnabled(bundle) : false;
    }

    public boolean isJCDIEnabled(BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        return this.weldDeployer.is299Enabled(topLevelBundleDesc);
    }

    public JCDIService.JCDIInjectionContext createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, Object instance) {
        return this._createJCDIInjectionContext(ejb, instance);
    }

    public JCDIService.JCDIInjectionContext createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb) {
        return this._createJCDIInjectionContext(ejb, null);
    }

    private JCDIService.JCDIInjectionContext _createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, Object instance) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl weldManager = bootstrap.getManager(bda);
        EjbDescriptor ejbDesc = weldManager.getEjbDescriptor(ejb.getName());
        Bean bean = weldManager.getBean(ejbDesc);
        InjectionTarget it = weldManager.createInjectionTarget(ejbDesc);
        CreationalContext cc = weldManager.createCreationalContext((Contextual)bean);
        Object beanInstance = instance;
        if (beanInstance == null) {
            beanInstance = it.produce(cc);
        }
        return new JCDIInjectionContextImpl(it, cc, beanInstance);
    }

    public void injectEJBInstance(JCDIService.JCDIInjectionContext injectionCtx) {
        JCDIInjectionContextImpl injectionCtxImpl = (JCDIInjectionContextImpl)injectionCtx;
        injectionCtxImpl.it.inject(injectionCtxImpl.instance, injectionCtxImpl.cc);
    }

    public JCDIService.JCDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle) {
        return this.createManagedObject(managedClass, bundle, true);
    }

    public JCDIService.JCDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle, boolean invokePostConstruct) {
        Object managedObject = null;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(managedClass);
        InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
        CreationalContext cc = beanManager.createCreationalContext(null);
        managedObject = it.produce(cc);
        it.inject(managedObject, cc);
        if (invokePostConstruct) {
            it.postConstruct(managedObject);
        }
        return new JCDIInjectionContextImpl(it, cc, managedObject);
    }

    private class JCDIInjectionContextImpl
    implements JCDIService.JCDIInjectionContext {
        InjectionTarget it;
        CreationalContext cc;
        Object instance;

        JCDIInjectionContextImpl(InjectionTarget it, CreationalContext cc, Object i) {
            this.it = it;
            this.cc = cc;
            this.instance = i;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void cleanup(boolean callPreDestroy) {
            if (callPreDestroy) {
                this.it.preDestroy(this.instance);
            }
            this.it.dispose(this.instance);
            this.cc.release();
        }
    }
}

