/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.conversation.ServletConversationManager;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.BeanProvider;
import org.jboss.weld.servlet.HttpPassThruOnDemandSessionBeanStore;
import org.jboss.weld.servlet.HttpPassThruSessionBeanStore;

public class ServletLifecycle {
    private final ContextLifecycle lifecycle;

    public ServletLifecycle(ContextLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void beginRequest(HttpServletRequest request) {
        if (RequestBeanStoreCache.isSet(request)) {
            return;
        }
        ConcurrentHashMapBeanStore requestBeanStore = new ConcurrentHashMapBeanStore();
        RequestBeanStoreCache.set(request, requestBeanStore);
        this.lifecycle.beginRequest(request.getRequestURI(), requestBeanStore);
        this.restoreSessionContext(request);
        this.restoreConversationContext(request);
    }

    protected BeanStore restoreSessionContext(HttpServletRequest request) {
        HttpPassThruSessionBeanStore sessionBeanStore = HttpPassThruOnDemandSessionBeanStore.of(request);
        HttpSession session = request.getSession();
        String sessionId = session == null ? "Inactive session" : session.getId();
        this.lifecycle.restoreSession(sessionId, sessionBeanStore);
        if (session != null) {
            sessionBeanStore.attachToSession(session);
            BeanProvider.httpSessionManager(session.getServletContext()).setSession(session);
        }
        return sessionBeanStore;
    }

    private void restoreConversationContext(HttpServletRequest request) {
        BeanProvider.conversationManager(request.getSession().getServletContext()).setupConversation(request.getParameter("cid"));
    }

    public void beginSession(HttpSession session) {
        HttpPassThruSessionBeanStore beanStore = this.getSessionBeanStore();
        if (beanStore == null) {
            this.restoreSessionContext(session);
        } else {
            beanStore.attachToSession(session);
        }
    }

    private HttpPassThruSessionBeanStore getSessionBeanStore() {
        return (HttpPassThruSessionBeanStore)this.lifecycle.getSessionContext().getBeanStore();
    }

    protected BeanStore restoreSessionContext(HttpSession session) {
        String sessionId = session.getId();
        HttpPassThruSessionBeanStore beanStore = new HttpPassThruSessionBeanStore();
        beanStore.attachToSession(session);
        this.lifecycle.restoreSession(sessionId, beanStore);
        this.cacheSession(session);
        return beanStore;
    }

    private void cacheSession(HttpSession session) {
        BeanProvider.httpSessionManager(session.getServletContext()).setSession(session);
    }

    public void endRequest(HttpServletRequest request) {
        if (!RequestBeanStoreCache.isSet(request)) {
            return;
        }
        this.teardownConversation();
        this.teardownSession(request);
        this.teardownRequest(request);
    }

    private void teardownRequest(HttpServletRequest request) {
        BeanStore beanStore = RequestBeanStoreCache.get(request);
        if (beanStore == null) {
            throw new IllegalStateException(ServletMessage.REQUEST_SCOPE_BEAN_STORE_MISSING, new Object[0]);
        }
        this.lifecycle.endRequest(request.getRequestURI(), beanStore);
        RequestBeanStoreCache.clear(request);
    }

    private void teardownConversation() {
        BeanProvider.conversationManager(this.getServletContext()).teardownConversation();
        if (this.isSessionBeanStoreInvalid(this.getSessionBeanStore())) {
            BeanProvider.conversationManager(this.getServletContext()).teardownContext();
        }
    }

    private ServletContext getServletContext() {
        return this.getSessionBeanStore().getServletContext();
    }

    private void teardownSession(HttpServletRequest request) {
        HttpPassThruSessionBeanStore sessionBeanStore = this.getSessionBeanStore();
        if (this.isSessionBeanStoreInvalid(sessionBeanStore)) {
            this.lifecycle.endSession(request.getRequestedSessionId(), sessionBeanStore);
        }
        this.lifecycle.deactivateSessionContext();
    }

    private boolean isSessionBeanStoreInvalid(HttpPassThruSessionBeanStore sessionBeanStore) {
        return sessionBeanStore != null && sessionBeanStore.isInvalidated();
    }

    public void endSession(HttpSession session) {
        if (this.lifecycle.isSessionContextActive()) {
            this.activeSessionTermination(session);
        } else if (this.lifecycle.isRequestContextActive()) {
            this.activeRequestTermination(session);
        } else {
            this.mockedSessionTermination(session);
        }
    }

    private void activeRequestTermination(HttpSession session) {
        String sessionId = session.getId();
        BeanStore store = this.restoreSessionContext(session);
        this.getServletConversationManager().destroyBackgroundConversations();
        this.lifecycle.endSession(sessionId, store);
    }

    private ServletConversationManager getServletConversationManager() {
        return (ServletConversationManager)BeanProvider.conversationManager(this.getServletContext());
    }

    private void activeSessionTermination(HttpSession session) {
        String sessionId = session.getId();
        HttpPassThruSessionBeanStore beanStore = this.getSessionBeanStore();
        if (this.lifecycle.isRequestContextActive()) {
            beanStore.invalidate();
            this.getServletConversationManager().invalidateSession();
        } else {
            this.lifecycle.endSession(sessionId, beanStore);
        }
    }

    private void mockedSessionTermination(HttpSession session) {
        String sessionId = session.getId();
        ConcurrentHashMapBeanStore mockRequest = new ConcurrentHashMapBeanStore();
        this.lifecycle.beginRequest("endSession-" + sessionId, mockRequest);
        BeanStore sessionBeanStore = this.restoreSessionContext(session);
        this.lifecycle.endSession(session.getId(), sessionBeanStore);
        this.lifecycle.endRequest("endSession-" + sessionId, mockRequest);
    }

    private static class RequestBeanStoreCache {
        private static final String REQUEST_ATTRIBUTE_NAME = ServletLifecycle.class.getName() + ".requestBeanStore";

        private RequestBeanStoreCache() {
        }

        public static void clear(HttpServletRequest request) {
            request.removeAttribute(REQUEST_ATTRIBUTE_NAME);
        }

        public static BeanStore get(HttpServletRequest request) {
            return (BeanStore)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
        }

        public static void set(HttpServletRequest request, BeanStore requestBeanStore) {
            request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)requestBeanStore);
        }

        public static boolean isSet(HttpServletRequest request) {
            return RequestBeanStoreCache.get(request) != null;
        }
    }
}

