/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import org.jboss.weld.Container;
import org.jboss.weld.context.BusyConversationException;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.NonexistentConversationException;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.weld.conversation.ConversationIdGenerator;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.ConversationManager2;
import org.jboss.weld.conversation.ManagedConversation;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.resources.spi.ScheduledExecutorServiceFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversationManager
implements ConversationManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private boolean asynchronous = false;
    @Inject
    protected ConversationImpl conversation;
    @Inject
    private ConversationIdGenerator conversationIdGenerator;
    @Inject
    @ConversationConcurrentAccessTimeout
    private long concurrentAccessTimeout;
    private Map<String, ManagedConversation> managedConversations = new ConcurrentHashMap<String, ManagedConversation>();

    public ConversationManager2 setAsynchronous(boolean asynchronous) {
        if (this.asynchronous == asynchronous) {
            return this;
        }
        if (!this.managedConversations.isEmpty()) {
            log.warn(ConversationMessage.SWITCHING_MODE_RESETS_TIMEOUTS, new Object[0]);
        }
        if (asynchronous) {
            this.switchToAsynchronous();
        } else {
            this.switchToNonAsynchronous();
        }
        return this;
    }

    private void switchToNonAsynchronous() {
        for (ManagedConversation managedConversation : this.managedConversations.values()) {
            managedConversation.cancelTermination();
            managedConversation.setTerminationHandle(null);
            managedConversation.touch();
        }
    }

    private void switchToAsynchronous() {
        for (ManagedConversation managedConversation : this.managedConversations.values()) {
            managedConversation.setTerminationHandle(this.scheduleForTermination(managedConversation.getConversation()));
        }
    }

    private void destroyExpiredConversations() {
        Iterator<ManagedConversation> i = this.managedConversations.values().iterator();
        while (i.hasNext()) {
            ManagedConversation managedConversation = i.next();
            if (!managedConversation.isExpired()) continue;
            managedConversation.destroy();
            i.remove();
        }
    }

    @Override
    public ConversationManager2 setupConversation(String cid) {
        if (!this.asynchronous) {
            this.destroyExpiredConversations();
        }
        if (cid == null) {
            log.trace(ConversationMessage.NO_CONVERSATION_TO_RESTORE, new Object[0]);
            return this;
        }
        ManagedConversation resumedManagedConversation = this.managedConversations.get(cid);
        if (resumedManagedConversation == null) {
            throw new NonexistentConversationException(ConversationMessage.UNABLE_TO_RESTORE_CONVERSATION, cid, "id not known");
        }
        if (this.asynchronous && !resumedManagedConversation.cancelTermination()) {
            throw new BusyConversationException(ConversationMessage.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
        }
        try {
            if (!resumedManagedConversation.lock(this.concurrentAccessTimeout)) {
                throw new BusyConversationException(ConversationMessage.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BusyConversationException(ConversationMessage.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
        }
        String oldConversation = this.conversation.toString();
        this.conversation.switchTo(resumedManagedConversation.getConversation());
        this.getContextLifeCycle().restoreConversation(cid, this.getBeanStore(cid));
        log.trace(ConversationMessage.CONVERSATION_SWITCHED, oldConversation, this.conversation);
        return this;
    }

    private ConversationContext getConversationContext() {
        return Container.instance().services().get(ContextLifecycle.class).getConversationContext();
    }

    @Override
    public ConversationManager2 teardownConversation() {
        log.trace(ConversationMessage.CLEANING_UP_CONVERSATION, this.conversation);
        if (this.conversation.isTransient()) {
            this.endTransientConversation();
            if (this.conversation.getResumedId() != null) {
                this.handleResumedConversation();
            }
        } else {
            this.endNonTransientConversation();
        }
        return this;
    }

    private void handleResumedConversation() {
        ManagedConversation resumedConversation = this.managedConversations.remove(this.conversation.getResumedId());
        if (resumedConversation == null) {
            return;
        }
        resumedConversation.unlock();
        resumedConversation.destroy();
    }

    private void endNonTransientConversation() {
        this.getConversationContext().saveTransientBeanStore(this.getBeanStore(this.conversation.getId()));
        ManagedConversation oldManagedConversation = this.managedConversations.get(this.conversation.getId());
        if (oldManagedConversation != null) {
            oldManagedConversation.unlock();
            if (this.asynchronous) {
                oldManagedConversation.setTerminationHandle(this.scheduleForTermination(this.conversation));
            } else {
                oldManagedConversation.touch();
            }
        } else {
            ManagedConversation newManagedConversation = ManagedConversation.of(this.conversation.unProxy(this), this.getBeanStore(this.conversation.getId()));
            if (this.asynchronous) {
                log.trace(ConversationMessage.CONVERSATION_TERMINATION_SCHEDULED, this.conversation);
                newManagedConversation.setTerminationHandle(this.scheduleForTermination(this.conversation));
            }
            this.managedConversations.put(this.conversation.getId(), newManagedConversation);
        }
        log.trace(ConversationMessage.LRC_COUNT, this.managedConversations.size());
    }

    private void endTransientConversation() {
        this.getContextLifeCycle().teardownConversationContext();
        if (this.conversation.getResumedId() != null) {
            this.getBeanStore(this.conversation.getResumedId()).clear();
        }
    }

    private Future<?> scheduleForTermination(Conversation conversation) {
        TerminationTask terminationTask = new TerminationTask(conversation.getId());
        return Container.instance().services().get(ScheduledExecutorServiceFactory.class).get().schedule(terminationTask, conversation.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public ConversationManager2 destroyBackgroundConversations() {
        log.debug(ConversationMessage.DESTROY_ALL_LRC, "session ended");
        log.trace(ConversationMessage.LRC_COUNT, this.managedConversations.size());
        if (this.conversation.getResumedId() != null) {
            this.managedConversations.remove(this.conversation.getResumedId());
        }
        for (ManagedConversation managedConversation : this.managedConversations.values()) {
            log.debug(ConversationMessage.DESTROY_LRC, managedConversation, "session ended");
            managedConversation.destroy();
        }
        this.managedConversations.clear();
        return this;
    }

    @Override
    public ConversationManager2 setupContext() {
        this.getContextLifeCycle().setupConversationContext();
        return this;
    }

    @Override
    public ConversationManager2 teardownContext() {
        this.getContextLifeCycle().teardownConversationContext();
        this.destroyBackgroundConversations();
        return this;
    }

    private ContextLifecycle getContextLifeCycle() {
        return Container.instance().services().get(ContextLifecycle.class);
    }

    @Override
    public String generateConversationId() {
        return this.conversationIdGenerator.nextId();
    }

    @Override
    public Map<String, Conversation> getConversations() {
        HashMap<String, ConversationImpl> conversations = new HashMap<String, ConversationImpl>();
        for (ManagedConversation entry : this.managedConversations.values()) {
            conversations.put(entry.getConversation().getId(), entry.getConversation());
        }
        return Collections.unmodifiableMap(conversations);
    }

    @Override
    public boolean isContextActive() {
        return this.getConversationContext().isActive();
    }

    protected abstract BeanStore getBeanStore(String var1);

    private class TerminationTask
    implements Runnable {
        private String cid;

        public TerminationTask(String cid) {
            this.cid = cid;
        }

        public void run() {
            log.debug(ConversationMessage.DESTROY_LRC, this.cid, "conversation timed out");
            ManagedConversation managedConversation = (ManagedConversation)AbstractConversationManager.this.managedConversations.remove(this.cid);
            if (managedConversation != null) {
                managedConversation.destroy();
            }
            log.trace(ConversationMessage.LRC_COUNT, AbstractConversationManager.this.managedConversations.size());
        }
    }
}

