/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.ArraySetSupplier;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.ImmutableArraySet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeldAnnotated<T, S>
implements WeldAnnotated<T, S> {
    private static final Set<Annotation> DEFAULT_QUALIFIERS = Collections.singleton(DefaultLiteral.INSTANCE);
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap;
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final Type type;
    private final ImmutableArraySet<Type> typeClosure;
    private final boolean proxyable;

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Iterable<Annotation> annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static void addMetaAnnotations(Multimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Annotation[] metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractWeldAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    protected static void addMetaAnnotations(Multimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Iterable<Annotation> metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractWeldAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    private static void addMetaAnnotation(Multimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Class<? extends Annotation> metaAnnotationType, boolean declared) {
        if (declared ? MAPPED_DECLARED_METAANNOTATIONS.contains(metaAnnotationType) : MAPPED_METAANNOTATIONS.contains(metaAnnotationType)) {
            metaAnnotationMap.put(metaAnnotationType, annotation);
        }
    }

    public AbstractWeldAnnotated(Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer, Class<T> rawType, Type type, Set<Type> typeClosure) {
        if (annotationMap == null) {
            throw new WeldException(ReflectionMessage.ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.annotationMap = annotationMap;
        this.metaAnnotationMap = Multimaps.newSetMultimap(new HashMap(), ArraySetSupplier.instance());
        for (Annotation annotation : annotationMap.values()) {
            AbstractWeldAnnotated.addMetaAnnotations(this.metaAnnotationMap, annotation, annotation.annotationType().getAnnotations(), false);
            AbstractWeldAnnotated.addMetaAnnotations(this.metaAnnotationMap, annotation, classTransformer.getTypeStore().get(annotation.annotationType()), false);
        }
        ArraySetSupplier.trimSetsToSize(this.metaAnnotationMap);
        if (declaredAnnotationMap == null) {
            throw new WeldException(ReflectionMessage.DECLARED_ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.rawType = rawType;
        this.type = type;
        this.actualTypeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : new Type[0];
        this.typeClosure = new ImmutableArraySet<Type>(typeClosure);
        this.proxyable = Proxies.isTypesProxyable(typeClosure);
    }

    protected AbstractWeldAnnotated(Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, TypeStore typeStore) {
        if (annotationMap == null) {
            throw new WeldException(ReflectionMessage.ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.annotationMap = annotationMap;
        this.metaAnnotationMap = Multimaps.newSetMultimap(new HashMap(), ArraySetSupplier.instance());
        for (Annotation annotation : annotationMap.values()) {
            AbstractWeldAnnotated.addMetaAnnotations(this.metaAnnotationMap, annotation, annotation.annotationType().getAnnotations(), false);
            AbstractWeldAnnotated.addMetaAnnotations(this.metaAnnotationMap, annotation, typeStore.get(annotation.annotationType()), false);
            this.annotationMap.put(annotation.annotationType(), annotation);
        }
        ArraySetSupplier.trimSetsToSize(this.metaAnnotationMap);
        if (declaredAnnotationMap == null) {
            throw new WeldException(ReflectionMessage.DECLARED_ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.rawType = null;
        this.type = null;
        this.actualTypeArguments = new Type[0];
        this.typeClosure = null;
        this.proxyable = false;
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays2.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
    }

    @Override
    public Set<Type> getInterfaceClosure() {
        HashSet<Type> types = new HashSet<Type>();
        for (Type t : this.rawType.getGenericInterfaces()) {
            types.addAll(new HierarchyDiscovery(t).getTypeClosure());
        }
        return types;
    }

    public abstract S getDelegate();

    @Override
    public boolean isParameterizedType() {
        return this.rawType.getTypeParameters().length > 0;
    }

    @Override
    public boolean isPrimitive() {
        return this.getJavaClass().isPrimitive();
    }

    @Override
    public Type getBaseType() {
        return this.type;
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.typeClosure;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return new ImmutableArraySet<Annotation>(this.annotationMap.values());
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return new ImmutableArraySet<Annotation>(this.metaAnnotationMap.get(metaAnnotationType));
    }

    @Override
    @Deprecated
    public Set<Annotation> getQualifiers() {
        if (this.getMetaAnnotations(Qualifier.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(Qualifier.class));
        }
        return Collections.unmodifiableSet(DEFAULT_QUALIFIERS);
    }

    @Override
    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getQualifiers().toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }
}

