/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.proxy.InterceptionHandlerFactory;
import org.jboss.interceptor.proxy.InterceptorMethodHandler;
import org.jboss.interceptor.proxy.InterceptorProxyCreator;
import org.jboss.interceptor.registry.InterceptorRegistry;
import org.jboss.interceptor.util.InterceptionUtils;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorProxyCreatorImpl
implements InterceptorProxyCreator {
    private List<InterceptorRegistry<Class<?>, ?>> interceptorRegistries;
    private List<InterceptionHandlerFactory<?>> interceptionHandlerFactories;

    public InterceptorProxyCreatorImpl(List<InterceptorRegistry<Class<?>, ?>> interceptorRegistries, List<InterceptionHandlerFactory<?>> interceptionHandlerFactories) {
        this.interceptorRegistries = interceptorRegistries;
        this.interceptionHandlerFactories = interceptionHandlerFactories;
    }

    public InterceptorProxyCreatorImpl(InterceptorRegistry<Class<?>, ?> interceptorRegistries, InterceptionHandlerFactory<?> interceptionHandlerFactories) {
        this.interceptorRegistries = Collections.singletonList(interceptorRegistries);
        this.interceptionHandlerFactories = Collections.singletonList(interceptionHandlerFactories);
    }

    public <T> T createProxyFromInstance(Object target, Class<T> proxifiedClass, Class<?>[] constructorTypes, Object[] constructorArguments, InterceptorMetadata interceptorClassMetadata) {
        MethodHandler interceptorMethodHandler = this.createMethodHandler(target, proxifiedClass, interceptorClassMetadata);
        return this.createProxyInstance(InterceptionUtils.createProxyClassWithHandler(proxifiedClass, interceptorMethodHandler), interceptorMethodHandler);
    }

    @Override
    public <T> T createProxyInstance(Class<T> proxyClass, MethodHandler interceptorMethodHandler) {
        try {
            ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
            Constructor<?> c = reflectionFactory.newConstructorForSerialization(proxyClass, Object.class.getDeclaredConstructor(new Class[0]));
            Object proxyObject = c.newInstance(new Object[0]);
            if (interceptorMethodHandler != null) {
                ((ProxyObject)proxyObject).setHandler(interceptorMethodHandler);
            }
            return (T)proxyObject;
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    @Override
    public <T> MethodHandler createMethodHandler(Object target, Class<T> proxyClass, InterceptorMetadata interceptorMetadata) {
        return new InterceptorMethodHandler(target, proxyClass, this.getModelsFor(proxyClass), this.interceptionHandlerFactories, interceptorMetadata);
    }

    private <T> List<InterceptionModel<Class<?>, ?>> getModelsFor(Class<T> proxyClass) {
        ArrayList interceptionModels = new ArrayList();
        for (InterceptorRegistry<Class<?>, ?> interceptorRegistry : this.interceptorRegistries) {
            interceptionModels.add(interceptorRegistry.getInterceptionModel(proxyClass));
        }
        return interceptionModels;
    }

    public <T> T createProxyFromInstance(Object target, Class<T> proxyClass, InterceptorMetadata targetClassMetadata) throws IllegalAccessException, InstantiationException {
        return this.createProxyFromInstance(target, proxyClass, new Class[0], new Object[0], targetClassMetadata);
    }
}

