/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.decorator.Delegate;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "DecoratorProxy";
    private final WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private final CtClass delegateClass;
    private final Field delegateField;

    public DecoratorProxyFactory(Class<T> proxyType, WeldInjectionPoint<?, ?> delegateInjectionPoint) {
        super(proxyType, Collections.EMPTY_SET);
        this.delegateInjectionPoint = delegateInjectionPoint;
        try {
            this.delegateClass = this.getClassPool().get(((Class)delegateInjectionPoint.getBaseType()).getName());
        }
        catch (NotFoundException e) {
            throw new WeldException(e);
        }
        this.delegateField = delegateInjectionPoint instanceof FieldInjectionPoint ? ((FieldInjectionPoint)delegateInjectionPoint).getJavaMember() : null;
    }

    @Override
    protected void addConstructors(CtClass proxyClassType) {
        try {
            CtClass baseType = this.getClassPool().get(this.getBeanType().getName());
            for (CtConstructor constructor : baseType.getConstructors()) {
                int delegateInjectionPosition = this.getDelegateInjectionPosition(constructor);
                if (delegateInjectionPosition >= 0) {
                    proxyClassType.addConstructor(CtNewConstructor.make(constructor.getParameterTypes(), constructor.getExceptionTypes(), this.createDelegateInitializerCode(null, delegateInjectionPosition), proxyClassType));
                    continue;
                }
                proxyClassType.addConstructor(CtNewConstructor.copy(constructor, proxyClassType, null));
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    protected void addMethodsFromClass(CtClass proxyClassType) {
        ParameterInjectionPoint parameterIP;
        String initializerMethod = null;
        int delegateParameterPosition = -1;
        if (this.delegateInjectionPoint instanceof ParameterInjectionPoint && (parameterIP = (ParameterInjectionPoint)this.delegateInjectionPoint).getMember() instanceof Method) {
            initializerMethod = ((Method)parameterIP.getMember()).getName();
            delegateParameterPosition = parameterIP.getPosition();
        }
        try {
            for (CtMethod method : proxyClassType.getMethods()) {
                if (method.getDeclaringClass().getName().equals("java.lang.Object") && !method.getName().equals("toString")) continue;
                log.trace("Adding method " + method.getLongName());
                String methodBody = null;
                if (delegateParameterPosition >= 0 && initializerMethod.equals(method.getName())) {
                    methodBody = this.createDelegateInitializerCode(initializerMethod, delegateParameterPosition);
                } else if (Modifier.isAbstract(method.getModifiers())) {
                    methodBody = this.createAbstractMethodCode(method);
                }
                if (methodBody == null) continue;
                proxyClassType.addMethod(CtNewMethod.make(method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), methodBody, proxyClassType));
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private String createAbstractMethodCode(CtMethod method) throws NotFoundException {
        CtMethod delegateMethod = null;
        StringBuilder bodyString = new StringBuilder();
        bodyString.append("{ ");
        try {
            delegateMethod = this.delegateClass.getMethod(method.getName(), method.getSignature());
            if (method.getReturnType() != null) {
                bodyString.append("return ($r)");
            }
        }
        catch (NotFoundException e) {
            throw new WeldException(e);
        }
        if (this.delegateField != null && !Modifier.isPrivate(this.delegateField.getModifiers())) {
            bodyString.append(this.delegateField.getName());
            bodyString.append('.');
            bodyString.append(method.getName());
            bodyString.append("($$); }");
            log.trace("Delegating call directly to delegate for method " + method.getLongName());
        } else {
            bodyString.append("beanInstance.invoke(");
            if (Modifier.isPublic(delegateMethod.getModifiers())) {
                bodyString.append("beanInstance.getInstanceType().getMethod(\"");
                log.trace("Using getMethod in proxy for method " + method.getLongName());
            } else {
                bodyString.append(method.getDeclaringClass().getName());
                bodyString.append(".class.getDeclaredMethod(\"");
                log.trace("Using getDeclaredMethod in proxy for method " + method.getLongName());
            }
            bodyString.append(method.getName());
            bodyString.append("\", ");
            bodyString.append(this.getSignatureClasses(method));
            bodyString.append("), $args); }");
        }
        return bodyString.toString();
    }

    private String createDelegateInitializerCode(String initializerName, int delegateParameterPosition) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ super");
        if (initializerName != null) {
            buffer.append('.');
            buffer.append(initializerName);
        }
        buffer.append("($$);\n");
        buffer.append("beanInstance = new ");
        buffer.append(TargetBeanInstance.class.getName());
        buffer.append("($");
        buffer.append(delegateParameterPosition + 1);
        buffer.append("); }");
        return buffer.toString();
    }

    private int getDelegateInjectionPosition(CtConstructor constructor) {
        int position = -1;
        Object[][] parameterAnnotations = constructor.getAvailableParameterAnnotations();
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                if (!(parameterAnnotations[i][j] instanceof Delegate)) continue;
                position = i;
                continue block0;
            }
        }
        return position;
    }
}

