/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.ejb.EjbDescriptorImpl;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private Logger logger = Logger.getLogger(BeanDeploymentArchiveImpl.class.getName());
    private static final char SEPARATOR_CHAR = '/';
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private ReadableArchive archive;
    private String id;
    private List<Class<?>> wClasses = null;
    private List<URL> wUrls = null;
    private final Collection<EjbDescriptor<?>> ejbDescImpls;
    private List<BeanDeploymentArchive> beanDeploymentArchives;
    private SimpleServiceRegistry simpleServiceRegistry = null;
    public static final String WAR = "WAR";
    public static final String JAR = "JAR";
    public String bdaType;

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        this.wClasses = new ArrayList();
        this.wUrls = new ArrayList<URL>();
        this.archive = archive;
        this.id = archive.getURI().getPath();
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
            this.ejbDescImpls.add(wbEjbDesc);
        }
        this.populate();
        try {
            this.archive.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.archive = null;
    }

    public BeanDeploymentArchiveImpl(String id, List<Class<?>> wClasses, List<URL> wUrls, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        this.id = id;
        this.wClasses = wClasses;
        this.wUrls = wUrls;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
            this.ejbDescImpls.add(wbEjbDesc);
        }
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public Collection<Class<?>> getBeanClasses() {
        return this.wClasses;
    }

    public Collection<URL> getBeansXml() {
        return this.wUrls;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescImpls;
    }

    public EjbDescriptor getEjbDescriptor(String ejbName) {
        EjbDescriptor<?> match = null;
        for (EjbDescriptor<?> next : this.ejbDescImpls) {
            if (!next.getEjbName().equals(ejbName)) continue;
            match = next;
            break;
        }
        return match;
    }

    public ServiceRegistry getServices() {
        if (null == this.simpleServiceRegistry) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String val = "ID: " + this.getId() + " CLASSES: " + this.getBeanClasses() + "\n";
        Collection<BeanDeploymentArchive> bdas = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : bdas) {
            val = val + "   ID: " + bda.getId() + " CLASSES: " + bda.getBeanClasses();
        }
        return val;
    }

    public String getBDAType() {
        return this.bdaType;
    }

    private void populate() {
        try {
            String entry;
            Enumeration entries;
            if (this.archive.exists(WEB_INF_BEANS_XML)) {
                this.bdaType = WAR;
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (entry.endsWith(CLASS_SUFFIX)) {
                        entry = entry.substring(WEB_INF_CLASSES.length() + 1);
                        String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                        this.wClasses.add(this.getClassLoader().loadClass(className));
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    URI uri = this.archive.getURI();
                    File file = new File(uri.getPath() + entry);
                    URL beansXmlUrl = file.toURL();
                    this.wUrls.add(beansXmlUrl);
                }
                this.archive.close();
            }
            if (this.archive.exists(WEB_INF_LIB)) {
                this.bdaType = WAR;
                entries = this.archive.entries(WEB_INF_LIB);
                while (entries.hasMoreElements()) {
                    ReadableArchive jarArchive;
                    entry = (String)entries.nextElement();
                    if (!entry.endsWith(JAR_SUFFIX) || entry.indexOf(47, WEB_INF_LIB.length() + 1) != -1 || !(jarArchive = this.archive.getSubArchive(entry)).exists(META_INF_BEANS_XML)) continue;
                    this.collectJarInfo(jarArchive);
                }
            }
            if (this.archive.exists(META_INF_BEANS_XML)) {
                this.bdaType = JAR;
                this.collectJarInfo(this.archive);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
    }

    private void collectJarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            if (entry.endsWith(CLASS_SUFFIX)) {
                String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                this.wClasses.add(this.getClassLoader().loadClass(className));
                continue;
            }
            if (!entry.endsWith("beans.xml")) continue;
            URL beansXmlUrl = Thread.currentThread().getContextClassLoader().getResource(entry);
            this.wUrls.add(beansXmlUrl);
        }
    }

    private static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return DeploymentImpl.class.getClassLoader();
    }
}

