/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.weld.serialization.spi.ProxyServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServicesImpl
implements ProxyServices {
    private Map<ClassLoader, WeakReference<ClassLoader>> proxyClassLoaders = new WeakHashMap<ClassLoader, WeakReference<ClassLoader>>();

    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this._getClassLoader();
                }
            });
        }
        return this._getClassLoader();
    }

    private ClassLoader _getClassLoader() {
        ClassLoader proxyCL;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        WeakReference<ClassLoader> wr = this.proxyClassLoaders.get(tcl);
        ClassLoader classLoader = proxyCL = wr == null ? null : (ClassLoader)wr.get();
        if (proxyCL == null) {
            ClassLoader weldBundleCL = ProxyServices.class.getClassLoader();
            proxyCL = new ProxyClassLoader(tcl, weldBundleCL);
            this.proxyClassLoaders.put(tcl, new WeakReference<ClassLoader>(proxyCL));
        }
        return proxyCL;
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ClassLoader cl = ProxyServicesImpl.this._getClassLoader();
                        return Class.forName(className, true, cl);
                    }
                });
            }
            ClassLoader cl = this._getClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void cleanup() {
        this.proxyClassLoaders.clear();
    }

    class ProxyClassLoader
    extends SecureClassLoader {
        private ClassLoader delegateCL;

        public ProxyClassLoader(ClassLoader parentCL, ClassLoader delegateCL) {
            super(parentCL);
            this.delegateCL = delegateCL;
        }

        public Class findClass(String name) throws ClassNotFoundException {
            return this.delegateCL.loadClass(name);
        }
    }
}

