/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.inject.spi.Bean;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "DecoratorProxy";
    private final WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private final Field delegateField;

    public DecoratorProxyFactory(Class<T> proxyType, WeldInjectionPoint<?, ?> delegateInjectionPoint, Bean<?> bean) {
        super(proxyType, (Set<? extends Type>)Collections.EMPTY_SET, bean);
        this.delegateInjectionPoint = delegateInjectionPoint;
        this.delegateField = delegateInjectionPoint instanceof FieldInjectionPoint ? ((FieldInjectionPoint)delegateInjectionPoint).getJavaMember() : null;
    }

    private void addHandlerInitializerMethod(ClassFile proxyClassType) throws Exception {
        proxyClassType.addMethod(MethodUtils.makeMethod(2, Void.TYPE, "_initMH", new Class[]{Object.class}, new Class[0], this.createMethodHandlerInitializerBody(proxyClassType), proxyClassType.getConstPool()));
    }

    @Override
    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
        interfaces.add(DecoratorProxy.class);
    }

    private Bytecode createMethodHandlerInitializerBody(ClassFile proxyClassType) {
        Bytecode b = new Bytecode(proxyClassType.getConstPool(), 1, 2);
        b.add(42);
        DecoratorProxyFactory.invokeMethodHandler(proxyClassType, b, proxyClassType.getName(), "_initMH", new String[]{"Ljava/lang/Object;"}, "V", false, null);
        b.addCheckcast("javassist/util/proxy/MethodHandler");
        b.addPutfield(proxyClassType.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(177);
        log.trace("Created MH initializer body for decorator proxy:  " + this.getBeanType());
        return b;
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType) {
        ParameterInjectionPoint parameterIP;
        Method initializerMethod = null;
        int delegateParameterPosition = -1;
        if (this.delegateInjectionPoint instanceof ParameterInjectionPoint && (parameterIP = (ParameterInjectionPoint)this.delegateInjectionPoint).getMember() instanceof Method) {
            initializerMethod = (Method)parameterIP.getMember();
            delegateParameterPosition = parameterIP.getPosition();
        }
        try {
            if (delegateParameterPosition >= 0) {
                this.addHandlerInitializerMethod(proxyClassType);
            }
            for (Class<?> cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (method.getDeclaringClass().getName().equals("java.lang.Object") && !method.getName().equals("toString")) continue;
                    Bytecode methodBody = null;
                    if (delegateParameterPosition >= 0 && initializerMethod.equals(method)) {
                        methodBody = this.createDelegateInitializerCode(proxyClassType, method, delegateParameterPosition);
                    }
                    if (Modifier.isAbstract(method.getModifiers())) {
                        methodBody = this.createAbstractMethodCode(proxyClassType, method);
                    }
                    if (methodBody == null) continue;
                    log.trace("Adding method " + method);
                    proxyClassType.addMethod(MethodUtils.makeMethod(1, method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), methodBody, proxyClassType.getConstPool()));
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private Bytecode createAbstractMethodCode(ClassFile file, Method method) throws NotFoundException {
        if (this.delegateField != null && !Modifier.isPrivate(this.delegateField.getModifiers())) {
            Bytecode b = new Bytecode(file.getConstPool());
            int localVariables = MethodUtils.calculateMaxLocals(method);
            b.setMaxLocals(localVariables);
            b.addAload(0);
            b.addGetfield(file.getName(), this.delegateField.getName(), DescriptorUtils.classToStringRepresentation(this.delegateField.getType()));
            String methodDescriptor = DescriptorUtils.getMethodDescriptor(method);
            BytecodeUtils.loadParameters(b, methodDescriptor);
            b.addInvokeinterface(this.delegateField.getType().getName(), method.getName(), methodDescriptor, localVariables);
            BytecodeUtils.addReturnInstruction(b, method.getReturnType());
            return b;
        }
        if (!Modifier.isPrivate(method.getModifiers())) {
            return this.createAbstractMethodHandler(file, method);
        }
        return this.createInterceptorBody(file, method);
    }

    private Bytecode createAbstractMethodHandler(ClassFile file, Method method) {
        Bytecode b = new Bytecode(file.getConstPool());
        String[] ptypes = new String[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            ptypes[i] = DescriptorUtils.classToStringRepresentation(method.getParameterTypes()[i]);
        }
        DecoratorProxyFactory.invokeMethodHandler(file, b, method.getDeclaringClass().getName(), method.getName(), ptypes, DescriptorUtils.classToStringRepresentation(method.getReturnType()), true, new TargetInstanceBytecodeMethodResolver());
        return b;
    }

    private Bytecode createDelegateInitializerCode(ClassFile file, Method intializerMethod, int delegateParameterPosition) {
        Bytecode b = new Bytecode(file.getConstPool());
        b.addAload(0);
        int localVariables = 1;
        int actualDelegateParamterPosition = 0;
        String methodDescriptor = DescriptorUtils.getMethodDescriptor(intializerMethod);
        for (int i = 0; i < intializerMethod.getParameterTypes().length; ++i) {
            if (i == delegateParameterPosition) {
                actualDelegateParamterPosition = localVariables;
            }
            Class<?> type = intializerMethod.getParameterTypes()[i];
            BytecodeUtils.addLoadInstruction(b, DescriptorUtils.classToStringRepresentation(type), localVariables);
            if (type == Long.TYPE || type == Double.TYPE) {
                localVariables += 2;
                continue;
            }
            ++localVariables;
        }
        b.addInvokespecial(file.getSuperclass(), intializerMethod.getName(), methodDescriptor);
        b.addAload(0);
        b.addAload(actualDelegateParamterPosition);
        b.addInvokevirtual(file.getName(), "_initMH", "(Ljava/lang/Object;)V");
        BytecodeUtils.addReturnInstruction(b, intializerMethod.getReturnType());
        b.setMaxLocals(localVariables);
        return b;
    }

    protected static class TargetInstanceBytecodeMethodResolver
    implements ProxyFactory.BytecodeMethodResolver {
        protected TargetInstanceBytecodeMethodResolver() {
        }

        public void getDeclaredMethod(ClassFile file, Bytecode code, String declaringClass, String methodName, String[] parameterTypes) {
            ProxyFactory.invokeMethodHandler(file, code, TargetInstanceProxy.class.getName(), "getTargetClass", parameterTypes, "Ljava/lang/Class;", false, null);
            code.addCheckcast("java/lang/Class");
            code.addLdc(methodName);
            code.addIconst(parameterTypes.length);
            code.addAnewarray("java.lang.Class");
            for (int i = 0; i < parameterTypes.length; ++i) {
                code.add(89);
                code.addIconst(i);
                String type = parameterTypes[i];
                BytecodeUtils.pushClassType(code, type);
                code.add(83);
            }
            code.addInvokevirtual("java.lang.Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        }
    }
}

