/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.context.AbstractContext;
import org.jboss.weld.context.ManagedContext;

public abstract class AbstractManagedContext
extends AbstractContext
implements ManagedContext {
    private final ThreadLocal<Boolean> active = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<Boolean> valid = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    public AbstractManagedContext(boolean multithreaded) {
        super(multithreaded);
    }

    public boolean isActive() {
        return this.active.get();
    }

    protected void setActive(boolean active) {
        this.active.set(active);
    }

    public void invalidate() {
        this.valid.set(Boolean.FALSE);
    }

    public void activate() {
        this.setActive(true);
    }

    public void deactivate() {
        if (!this.valid.get().booleanValue()) {
            this.destroy();
        }
        this.setActive(false);
    }

    public void cleanup() {
        super.cleanup();
        this.active.remove();
        this.valid.remove();
    }
}

