/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldListener
extends AbstractServletListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        if (Container.available()) {
            HttpSessionContext sessionContext = (HttpSessionContext)WeldListener.instance().select(HttpSessionContext.class, new Annotation[0]).get();
            sessionContext.destroy(event.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_DESTROYED, event.getServletRequest());
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
                Instance<Context> instance = WeldListener.instance();
                HttpRequestContext requestContext = (HttpRequestContext)instance.select(HttpRequestContext.class, new Annotation[0]).get();
                HttpSessionContext sessionContext = (HttpSessionContext)instance.select(HttpSessionContext.class, new Annotation[0]).get();
                HttpConversationContext conversationContext = (HttpConversationContext)instance.select(HttpConversationContext.class, new Annotation[0]).get();
                try {
                    requestContext.invalidate();
                    requestContext.deactivate();
                    sessionContext.deactivate();
                }
                finally {
                    requestContext.dissociate(request);
                    sessionContext.dissociate(request);
                    conversationContext.dissociate(request);
                }
            } else {
                throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
            }
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_INITIALIZED, event.getServletRequest());
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
                Instance<Context> instance = WeldListener.instance();
                HttpRequestContext requestContext = (HttpRequestContext)instance.select(HttpRequestContext.class, new Annotation[0]).get();
                HttpSessionContext sessionContext = (HttpSessionContext)instance.select(HttpSessionContext.class, new Annotation[0]).get();
                HttpConversationContext conversationContext = (HttpConversationContext)instance.select(HttpConversationContext.class, new Annotation[0]).get();
                requestContext.associate(request);
                sessionContext.associate(request);
                conversationContext.associate(request);
                requestContext.activate();
                sessionContext.activate();
            } else {
                throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
            }
        }
    }

    private static Instance<Context> instance() {
        return Container.instance().deploymentManager().instance().select(Context.class, new Annotation[0]);
    }
}

