/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.proxy.InterceptorException;
import org.jboss.interceptor.spi.context.InterceptionChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorInvocationContext
implements InvocationContext {
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private Method method;
    private Object[] parameters;
    private Object target;
    private InterceptionChain interceptionChain;
    private Object timer;
    private static List<Class<?>> WIDENING_SEQUENCE = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private static Map<Class<?>, Class<?>> WRAPPER_CLASSES = new HashMap();
    private static Map<Class<?>, Class<?>> REVERSE_WRAPPER_CLASSES;

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object[] parameters) {
        this.interceptionChain = interceptionChain;
        this.method = targetMethod;
        this.parameters = parameters;
        this.target = target;
        this.timer = null;
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object timer) {
        this.interceptionChain = interceptionChain;
        this.method = targetMethod;
        this.timer = timer;
        this.target = target;
        this.parameters = null;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object proceed() throws Exception {
        try {
            return this.interceptionChain.invokeNextInterceptor(this);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InterceptorException(t);
        }
    }

    private static boolean isWideningPrimitive(Class argumentClass, Class targetClass) {
        int argumentClassIndex = WIDENING_SEQUENCE.indexOf(argumentClass);
        return argumentClassIndex >= 0 && WIDENING_SEQUENCE.indexOf(targetClass) >= argumentClassIndex;
    }

    private static Class<?> getWrapperClass(Class<?> primitiveClass) {
        if (!WRAPPER_CLASSES.containsKey(primitiveClass)) {
            return primitiveClass;
        }
        return WRAPPER_CLASSES.get(primitiveClass);
    }

    private static Class<?> getPrimitiveClass(Class<?> wrapperClass) {
        if (!REVERSE_WRAPPER_CLASSES.containsKey(wrapperClass)) {
            return wrapperClass;
        }
        return REVERSE_WRAPPER_CLASSES.get(wrapperClass);
    }

    public void setParameters(Object[] params) {
        if (this.method != null) {
            int newParametersCount;
            int n = newParametersCount = params == null ? 0 : params.length;
            if (this.method.getParameterTypes().length != newParametersCount) {
                throw new IllegalArgumentException("Wrong number of parameters: method has " + this.method.getParameterTypes().length + ", attempting to set " + newParametersCount + (params != null ? "" : " (argument was null)"));
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Class<?> methodParameterClass = this.method.getParameterTypes()[i];
                    if (params[i] != null) {
                        Class<?> unboxedClass;
                        Class<?> boxedArgumentClass;
                        Class<?> newArgumentClass = params[i].getClass();
                        if (newArgumentClass.equals(methodParameterClass)) break;
                        if (!(newArgumentClass.isPrimitive() ? (methodParameterClass.isPrimitive() ? !InterceptorInvocationContext.isWideningPrimitive(newArgumentClass, methodParameterClass) : !methodParameterClass.isAssignableFrom(boxedArgumentClass = InterceptorInvocationContext.getWrapperClass(newArgumentClass))) : (methodParameterClass.isPrimitive() ? !InterceptorInvocationContext.isWideningPrimitive(unboxedClass = InterceptorInvocationContext.getPrimitiveClass(newArgumentClass), methodParameterClass) : !methodParameterClass.isAssignableFrom(newArgumentClass)))) continue;
                        throw new IllegalArgumentException("Incompatible parameter type on position: " + i + " :" + newArgumentClass + " (expected type was " + methodParameterClass.getName() + ")");
                    }
                    if (!this.method.getParameterTypes()[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Trying to set a null value on a " + this.method.getParameterTypes()[i].getName());
                }
                this.parameters = params;
            }
        } else {
            throw new IllegalStateException("Illegal invocation to setParameters() during lifecycle invocation");
        }
    }

    public Object getTimer() {
        return this.timer;
    }

    static {
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES = Collections.unmodifiableMap(WRAPPER_CLASSES);
        REVERSE_WRAPPER_CLASSES = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> classEntry : WRAPPER_CLASSES.entrySet()) {
            REVERSE_WRAPPER_CLASSES.put(classEntry.getValue(), classEntry.getKey());
        }
        REVERSE_WRAPPER_CLASSES = Collections.unmodifiableMap(REVERSE_WRAPPER_CLASSES);
    }
}

