/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessObserverMethodImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessObserverMethod<T, X> {
    private final AnnotatedMethod<X> beanMethod;
    private final ObserverMethod<T> observerMethod;

    public static <T, X> void fire(BeanManagerImpl beanManager, ObserverMethodImpl<T, X> observer) {
        if (beanManager.isBeanEnabled(observer.getDeclaringBean())) {
            new ProcessObserverMethodImpl<T, X>(beanManager, (AnnotatedMethod)observer.getMethod(), (ObserverMethodImpl)observer){}.fire();
        }
    }

    public ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethodImpl<T, X> observerMethod) {
        super(beanManager, (Type)((Object)ProcessObserverMethod.class), new Type[]{observerMethod.getMethod().getDeclaringType().getBaseType(), observerMethod.getObservedType()});
        this.beanMethod = beanMethod;
        this.observerMethod = observerMethod;
    }

    @Override
    public void addDefinitionError(Throwable t) {
        this.getErrors().add(t);
    }

    @Override
    public AnnotatedMethod<X> getAnnotatedMethod() {
        return this.beanMethod;
    }

    @Override
    public ObserverMethod<T> getObserverMethod() {
        return this.observerMethod;
    }

    public List<Throwable> getDefinitionErrors() {
        return Collections.unmodifiableList(this.getErrors());
    }
}

