/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgicdi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.InjectionPoint;
import org.glassfish.osgicdi.OSGiService;
import org.glassfish.osgicdi.ServiceUnavailableException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.util.tracker.ServiceTracker;

class OSGiServiceFactory {
    private static final boolean DEBUG_ENABLED = true;

    OSGiServiceFactory() {
    }

    public static Object getService(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        OSGiServiceFactory.debug("getService " + svcInjectionPoint.getType() + " OS:" + os);
        Object instance = OSGiServiceFactory.createServiceProxy(svcInjectionPoint);
        return instance;
    }

    private static Object createServiceProxy(final InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        Type serviceType = svcInjectionPoint.getType();
        final OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        final Object svcInstance = OSGiServiceFactory.lookupService(svcInjectionPoint);
        InvocationHandler proxyInvHndlr = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object instanceToUse = svcInstance;
                if (os.dynamic()) {
                    OSGiServiceFactory.debug("looking a service as this is set to DYNAMIC=true");
                    instanceToUse = OSGiServiceFactory.lookupService(svcInjectionPoint);
                } else {
                    OSGiServiceFactory.debug("using the service that was looked up earlier as this is set to DYNAMIC=false");
                }
                OSGiServiceFactory.debug("calling Method " + method + " on proxy");
                return method.invoke(instanceToUse, args);
            }
        };
        Object instance = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{(Class)serviceType}, proxyInvHndlr);
        return instance;
    }

    private static Object lookupService(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        Type serviceType = svcInjectionPoint.getType();
        OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        OSGiServiceFactory.debug("lookup service" + serviceType);
        Class<?> annotatedElt = svcInjectionPoint.getMember().getDeclaringClass();
        BundleContext bc = ((BundleReference)BundleReference.class.cast(annotatedElt.getClassLoader())).getBundle().getBundleContext();
        OSGiServiceFactory.debug("creating service tracker for " + ((Class)serviceType).getName() + " using bundle-context:" + bc);
        ServiceTracker st = new ServiceTracker(bc, ((Class)serviceType).getName(), null);
        st.open();
        try {
            Object service = os.waitTimeout() == -1 ? st.getService() : st.waitForService((long)os.waitTimeout());
            OSGiServiceFactory.debug("service obtained from tracker" + service);
            if (service == null) {
                throw new ServiceUnavailableException("Service" + ((Class)serviceType).getName() + "Unavailable", 4, null);
            }
            return service;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new ServiceUnavailableException("Service" + ((Class)serviceType).getName() + "Unavailable", 4, e);
        }
    }

    public static void ungetService(Object serviceInstance, InjectionPoint svcInjectionPoint) {
    }

    private static void debug(String string) {
        System.out.println("ServiceFactory:: " + string);
    }
}

