/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.weld.ejb.EjbDescriptorImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private Logger logger = Logger.getLogger(BeanDeploymentArchiveImpl.class.getName());
    private static final char SEPARATOR_CHAR = '/';
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private static final String RAR_SUFFIX = ".rar";
    private static final String EXPANDED_RAR_SUFFIX = "_rar";
    private ReadableArchive archive;
    private String id;
    private List<Class<?>> wClasses = null;
    private List<URL> wUrls = null;
    private final Collection<EjbDescriptor<?>> ejbDescImpls;
    private List<BeanDeploymentArchive> beanDeploymentArchives;
    private SimpleServiceRegistry simpleServiceRegistry = null;
    public static final String WAR = "WAR";
    public static final String JAR = "JAR";
    public String bdaType;
    private DeploymentContext context;
    private final Map<AnnotatedType<?>, InjectionTarget<?>> itMap = new HashMap();
    private ClassLoader moduleClassLoaderForBDA = null;

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this.wClasses = new ArrayList();
        this.wUrls = new ArrayList<URL>();
        this.archive = archive;
        this.id = archive.getURI().getPath();
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
            this.ejbDescImpls.add(wbEjbDesc);
        }
        this.populate();
        try {
            this.archive.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.archive = null;
        this.moduleClassLoaderForBDA = Thread.currentThread().getContextClassLoader();
    }

    public BeanDeploymentArchiveImpl(String id, List<Class<?>> wClasses, List<URL> wUrls, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this.id = id;
        this.wClasses = wClasses;
        this.wUrls = wUrls;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
            this.ejbDescImpls.add(wbEjbDesc);
        }
        this.moduleClassLoaderForBDA = Thread.currentThread().getContextClassLoader();
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public Collection<String> getBeanClasses() {
        ArrayList<String> s = new ArrayList<String>();
        Iterator<Class<?>> iterator = this.wClasses.iterator();
        while (iterator.hasNext()) {
            String classname = iterator.next().getName();
            s.add(classname);
        }
        this.logger.log(Level.FINER, "set TCL for " + this.id + " to " + this.moduleClassLoaderForBDA);
        Thread.currentThread().setContextClassLoader(this.moduleClassLoaderForBDA);
        return s;
    }

    public Collection<Class<?>> getBeanClassObjects() {
        return this.wClasses;
    }

    public BeansXml getBeansXml() {
        WeldBootstrap wb = (WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class);
        return wb.parse(this.wUrls);
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescImpls;
    }

    public EjbDescriptor getEjbDescriptor(String ejbName) {
        EjbDescriptor<?> match = null;
        for (EjbDescriptor<?> next : this.ejbDescImpls) {
            if (!next.getEjbName().equals(ejbName)) continue;
            match = next;
            break;
        }
        return match;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String val = "|ID: " + this.getId() + ", bdaType= " + this.bdaType + ", Bean Classes #: " + this.getBeanClasses().size() + "\n";
        Collection<BeanDeploymentArchive> bdas = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : bdas) {
            String embedBDAType = "";
            if (bda instanceof BeanDeploymentArchiveImpl) {
                embedBDAType = ((BeanDeploymentArchiveImpl)bda).getBDAType();
            }
            val = val + "|---->ID: " + bda.getId() + ", bdaType= " + embedBDAType + ", Bean Classes #: " + bda.getBeanClasses().size() + "\n";
        }
        return val;
    }

    public String getBDAType() {
        return this.bdaType;
    }

    private void populate() {
        try {
            String entry;
            Enumeration entries;
            if (this.archive.exists(WEB_INF_BEANS_XML)) {
                this.logger.log(Level.FINE, "-processing " + this.archive.getURI() + " as it has WEB-INF/beans.xml");
                this.bdaType = WAR;
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (entry.endsWith(CLASS_SUFFIX)) {
                        entry = entry.substring(WEB_INF_CLASSES.length() + 1);
                        String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                        this.wClasses.add(this.getClassLoader().loadClass(className));
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    URI uri = this.archive.getURI();
                    File file = new File(uri.getPath() + entry);
                    URL beansXmlUrl = file.toURI().toURL();
                    this.wUrls.add(beansXmlUrl);
                }
                this.archive.close();
            }
            if (this.archive.exists(WEB_INF_LIB)) {
                this.logger.log(Level.FINE, "-processing WEB-INF/lib in " + this.archive.getURI());
                this.bdaType = WAR;
                entries = this.archive.entries(WEB_INF_LIB);
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (!entry.endsWith(JAR_SUFFIX) || entry.indexOf(47, WEB_INF_LIB.length() + 1) != -1) continue;
                    ReadableArchive jarArchive = this.archive.getSubArchive(entry);
                    if (jarArchive.exists(META_INF_BEANS_XML)) {
                        this.logger.log(Level.FINE, "-WEB-INF/lib: considering " + entry + " as a bean archive as it has beans.xml");
                        this.collectJarInfo(jarArchive);
                        continue;
                    }
                    this.logger.log(Level.FINE, "-WEB-INF/lib: skipping " + this.archive.getName() + " as it doesn't have beans.xml");
                }
            }
            if (this.archive.getName().endsWith(RAR_SUFFIX) || this.archive.getName().endsWith(EXPANDED_RAR_SUFFIX)) {
                this.collectRarInfo(this.archive);
            }
            if (this.archive.exists(META_INF_BEANS_XML)) {
                this.logger.log(Level.FINE, "-JAR processing: " + this.archive.getURI() + " as a jar since it has META-INF/beans.xml");
                this.bdaType = JAR;
                this.collectJarInfo(this.archive);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
    }

    private void collectJarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        this.logger.log(Level.FINE, "-collecting jar info for " + archive.getURI());
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            this.handleEntry(entry);
        }
    }

    private void handleEntry(String entry) throws ClassNotFoundException {
        if (entry.endsWith(CLASS_SUFFIX)) {
            String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
            this.wClasses.add(this.getClassLoader().loadClass(className));
        } else if (entry.endsWith("beans.xml")) {
            URL beansXmlUrl = Thread.currentThread().getContextClassLoader().getResource(entry);
            this.wUrls.add(beansXmlUrl);
        }
    }

    private void collectRarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        this.logger.log(Level.FINE, "-collecting rar info for " + archive.getURI());
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            if (entry.endsWith(JAR_SUFFIX)) {
                ReadableArchive jarArchive = archive.getSubArchive(entry);
                this.collectJarInfo(jarArchive);
                continue;
            }
            this.handleEntry(entry);
        }
    }

    private static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl;
        if (this.context.getClassLoader() != null) {
            cl = this.context.getClassLoader();
        } else if (Thread.currentThread().getContextClassLoader() != null) {
            this.logger.log(Level.FINE, "Using TCL");
            cl = Thread.currentThread().getContextClassLoader();
        } else {
            this.logger.log(Level.FINE, "TCL is null. Using DeploymentImpl's classloader");
            cl = BeanDeploymentArchiveImpl.class.getClassLoader();
        }
        this.moduleClassLoaderForBDA = cl;
        return cl;
    }

    public InjectionTarget<?> getInjectionTarget(AnnotatedType<?> annotatedType) {
        return this.itMap.get(annotatedType);
    }

    void putInjectionTarget(AnnotatedType<?> annotatedType, InjectionTarget<?> it) {
        this.itMap.put(annotatedType, it);
    }
}

