/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.ejb;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.interceptor.InvocationContext;
import org.glassfish.weld.ejb.BusinessInterfaceDescriptorImpl;
import org.jboss.weld.ejb.SessionBeanInterceptor;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private com.sun.enterprise.deployment.EjbDescriptor ejbDesc;

    public EjbDescriptorImpl(com.sun.enterprise.deployment.EjbDescriptor e) {
        this.ejbDesc = e;
        EjbInterceptor systemLevelCDIInterceptor = this.createSystemLevelCDIInterceptor();
        this.ejbDesc.addFrameworkInterceptor((InterceptorDescriptor)systemLevelCDIInterceptor);
    }

    public String getEjbName() {
        return this.ejbDesc.getName();
    }

    public com.sun.enterprise.deployment.EjbDescriptor getEjbDescriptor() {
        return this.ejbDesc;
    }

    public Class<T> getBeanClass() {
        Class<?> beanClassType = null;
        try {
            beanClassType = this.ejbDesc.getEjbBundleDescriptor().getClassLoader().loadClass(this.ejbDesc.getEjbClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return beanClassType;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        HashSet localBusIntfs = new HashSet();
        if (this.ejbDesc.getType().equals("Session")) {
            Class<?> localClass;
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.ejbDesc;
            Set localNames = sessionDesc.getLocalBusinessClassNames();
            HashSet<String> extraNames = new HashSet<String>();
            for (String local : localNames) {
                try {
                    localClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(local);
                    this.addIfLocal(localClass.getInterfaces(), extraNames);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            localNames.addAll(extraNames);
            if (sessionDesc.isLocalBean()) {
                localNames.add(sessionDesc.getEjbClassName());
            }
            for (String local : localNames) {
                try {
                    localClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(local);
                    BusinessInterfaceDescriptorImpl busIntfDesc = new BusinessInterfaceDescriptorImpl(localClass);
                    localBusIntfs.add(busIntfDesc);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return localBusIntfs;
    }

    public Collection<Method> getRemoveMethods() {
        EjbSessionDescriptor sessionDesc;
        HashSet<Method> removeMethods = new HashSet<Method>();
        if (this.ejbDesc.getType().equals("Session") && (sessionDesc = (EjbSessionDescriptor)this.ejbDesc).isStateful() && sessionDesc.hasRemoveMethods()) {
            for (EjbRemovalInfo next : sessionDesc.getAllRemovalInfo()) {
                MethodDescriptor mDesc = next.getRemoveMethod();
                Method m = mDesc.getMethod(this.ejbDesc);
                if (m == null) {
                    throw new IllegalStateException("Can't resolve remove method " + mDesc + " For EJB " + sessionDesc.getName());
                }
                removeMethods.add(m);
            }
        }
        return removeMethods;
    }

    public boolean isStateless() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isStateless();
    }

    public boolean isSingleton() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isSingleton();
    }

    public boolean isStateful() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isStateful();
    }

    public boolean isMessageDriven() {
        return this.ejbDesc.getType().equals("Message-driven");
    }

    private void addIfLocal(Class[] interfaces, Set<String> names) {
        for (Class next : interfaces) {
            if (next.getAnnotation(Local.class) != null) {
                names.add(next.getName());
            }
            this.addIfLocal(next.getInterfaces(), names);
        }
    }

    private void addIfRemote(Class[] interfaces, Set<String> names) {
        for (Class next : interfaces) {
            if (next.getAnnotation(Remote.class) != null) {
                names.add(next.getName());
            }
            this.addIfRemote(next.getInterfaces(), names);
        }
    }

    private EjbInterceptor createSystemLevelCDIInterceptor() {
        EjbInterceptor interceptor = new EjbInterceptor();
        Class<SessionBeanInterceptor> interceptorClass = SessionBeanInterceptor.class;
        String interceptorName = interceptorClass.getName();
        interceptor.setInterceptorClass(interceptorClass);
        try {
            Method aroundInvokeMethod = interceptorClass.getMethod("aroundInvoke", InvocationContext.class);
            if (aroundInvokeMethod != null) {
                LifecycleCallbackDescriptor aroundInvokeDesc = new LifecycleCallbackDescriptor();
                aroundInvokeDesc.setLifecycleCallbackClass(interceptorName);
                aroundInvokeDesc.setLifecycleCallbackMethod(aroundInvokeMethod.getName());
                interceptor.addAroundInvokeDescriptor(aroundInvokeDesc);
                LifecycleCallbackDescriptor aroundTimeoutDesc = new LifecycleCallbackDescriptor();
                aroundTimeoutDesc.setLifecycleCallbackClass(interceptorName);
                aroundTimeoutDesc.setLifecycleCallbackMethod(aroundInvokeMethod.getName());
                interceptor.addAroundTimeoutDescriptor(aroundTimeoutDesc);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Cannot find weld EJB interceptor aroundInvoke method");
        }
        return interceptor;
    }

    private Method getMethodForMethodAnnotation(Class c, String annotationClassName) {
        for (Method m : c.getDeclaredMethods()) {
            for (Annotation next : m.getDeclaredAnnotations()) {
                if (!next.annotationType().getName().equals(annotationClassName)) continue;
                return m;
            }
        }
        return null;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        HashSet remoteBusIntfs = new HashSet();
        if (this.ejbDesc.getType().equals("Session")) {
            Class<?> remoteClass;
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.ejbDesc;
            Set remoteNames = sessionDesc.getRemoteBusinessClassNames();
            HashSet<String> extraNames = new HashSet<String>();
            for (String local : remoteNames) {
                try {
                    remoteClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(local);
                    this.addIfRemote(remoteClass.getInterfaces(), extraNames);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            remoteNames.addAll(extraNames);
            if (sessionDesc.isLocalBean()) {
                remoteNames.add(sessionDesc.getEjbClassName());
            }
            for (String remote : remoteNames) {
                try {
                    remoteClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(remote);
                    BusinessInterfaceDescriptorImpl busIntfDesc = new BusinessInterfaceDescriptorImpl(remoteClass);
                    remoteBusIntfs.add(busIntfDesc);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return remoteBusIntfs;
    }
}

