/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.TypeClosureLazyValueHolder;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.introspector.jlr.AbstractWeldCallable;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldParameterImpl;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldMethodImpl<T, X>
extends AbstractWeldCallable<T, X, Method>
implements WeldMethod<T, X> {
    private final Method method;
    private final ArrayList<WeldParameter<?, X>> parameters;
    private final String propertyName;
    private final MethodSignature signature;

    public static <T, X> WeldMethodImpl<T, X> of(Method method, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        return new WeldMethodImpl<T, X>(method, (Class)Reflections.cast(method.getReturnType()), method.getGenericReturnType(), new TypeClosureLazyValueHolder(method.getGenericReturnType()), null, WeldMethodImpl.buildAnnotationMap(method.getAnnotations()), WeldMethodImpl.buildAnnotationMap(method.getDeclaredAnnotations()), declaringClass, classTransformer);
    }

    public static <T, X> WeldMethodImpl<T, X> of(AnnotatedMethod<? super X> method, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        return new WeldMethodImpl<T, X>(method.getJavaMember(), (Class)Reflections.cast(method.getJavaMember().getReturnType()), method.getBaseType(), new TypeClosureLazyValueHolder(method.getTypeClosure()), method, WeldMethodImpl.buildAnnotationMap(method.getAnnotations()), WeldMethodImpl.buildAnnotationMap(method.getAnnotations()), declaringClass, classTransformer);
    }

    private WeldMethodImpl(Method method, Class<T> rawType, Type type, LazyValueHolder<Set<Type>> typeClosure, AnnotatedMethod<? super X> annotatedMethod, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        super(annotationMap, declaredAnnotationMap, classTransformer, method, rawType, type, typeClosure, declaringClass);
        this.method = method;
        this.parameters = new ArrayList(method.getParameterTypes().length);
        if (annotatedMethod == null) {
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                WeldParameter parameter;
                Class<?> clazz;
                if (method.getParameterAnnotations()[i].length > 0) {
                    clazz = method.getParameterTypes()[i];
                    Type parametertype = method.getGenericParameterTypes()[i];
                    parameter = WeldParameterImpl.of(method.getParameterAnnotations()[i], clazz, parametertype, this, i, classTransformer);
                    this.parameters.add(parameter);
                    continue;
                }
                clazz = method.getParameterTypes()[i];
                Type parameterType = method.getGenericParameterTypes()[i];
                parameter = WeldParameterImpl.of(new Annotation[0], (Class)Reflections.cast(clazz), parameterType, this, i, classTransformer);
                this.parameters.add(parameter);
            }
        } else {
            if (annotatedMethod.getParameters().size() != method.getParameterTypes().length) {
                throw new DefinitionException(ReflectionMessage.INCORRECT_NUMBER_OF_ANNOTATED_PARAMETERS_METHOD, annotatedMethod.getParameters().size(), annotatedMethod, annotatedMethod.getParameters(), Arrays.asList(method.getParameterTypes()));
            }
            for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
                WeldParameter parameter = WeldParameterImpl.of(annotatedParameter.getAnnotations(), method.getParameterTypes()[annotatedParameter.getPosition()], annotatedParameter.getBaseType(), this, annotatedParameter.getPosition(), classTransformer);
                this.parameters.add(parameter);
            }
        }
        this.parameters.trimToSize();
        String propertyName = Reflections.getPropertyName(this.getDelegate());
        this.propertyName = propertyName == null ? this.getName() : propertyName;
        this.signature = new MethodSignatureImpl(this);
    }

    @Override
    public Method getDelegate() {
        return this.method;
    }

    @Override
    public List<WeldParameter<?, X>> getWeldParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Class<?>[] getParameterTypesAsArray() {
        return this.method.getParameterTypes();
    }

    @Override
    public List<WeldParameter<?, X>> getWeldParameters(Class<? extends Annotation> annotationType) {
        ArrayList ret = new ArrayList();
        for (WeldParameter<?, X> parameter : this.parameters) {
            if (!parameter.isAnnotationPresent(annotationType)) continue;
            ret.add(parameter);
        }
        return ret;
    }

    @Override
    public boolean isEquivalent(Method method) {
        return this.getDeclaringType().isEquivalent(method.getDeclaringClass()) && this.getName().equals(method.getName()) && Arrays.equals(this.getParameterTypesAsArray(), method.getParameterTypes());
    }

    @Override
    public T invokeOnInstance(Object instance, Object ... parameters) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = this.method;
        if (method.getDeclaringClass() != instance.getClass()) {
            method = SecureReflections.lookupMethod(instance.getClass(), this.getName(), this.getParameterTypesAsArray());
        }
        return SecureReflections.invoke(instance, method, parameters);
    }

    @Override
    public T invoke(Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return SecureReflections.invoke(instance, this.method, parameters);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String toString() {
        return "[method] " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(this.method.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(((Method)this.getJavaMember()).getModifiers())) + this.getDeclaringType().getName() + "." + this.getName() + Formats.formatAsFormalParameterList(this.getWeldParameters());
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return Collections.unmodifiableList((List)Reflections.cast(this.parameters));
    }

    @Override
    public boolean isGeneric() {
        return ((Method)this.getJavaMember()).getTypeParameters().length > 0;
    }
}

