/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.jboss.weld.serialization.spi.ProxyServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServicesImpl
implements ProxyServices {
    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this._getClassLoader();
                }
            });
        }
        return this._getClassLoader();
    }

    private ClassLoader _getClassLoader() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        return tcl;
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ClassLoader cl = ProxyServicesImpl.this._getClassLoader();
                        return Class.forName(className, true, cl);
                    }
                });
            }
            ClassLoader cl = this._getClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void cleanup() {
    }
}

