/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.common;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceSpec;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;

public class DataSourceObjectBuilder
implements Serializable {
    private DataSourceSpec spec;
    private Hashtable driverProperties = null;
    private MethodExecutor executor = null;
    private static Logger _logger = LogDomains.getLogger(DataSourceObjectBuilder.class, (String)"javax.enterprise.resource.resourceadapter");
    private static boolean jdbc40 = DataSourceObjectBuilder.detectJDBC40();
    private boolean debug = false;
    private static final StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public DataSourceObjectBuilder(DataSourceSpec spec) {
        this.spec = spec;
        this.executor = new MethodExecutor();
    }

    public Object constructDataSourceObject() throws ResourceException {
        this.driverProperties = this.parseDriverProperties(this.spec);
        Object dataSourceObject = this.getDataSourceObject();
        Method[] methods = dataSourceObject.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (this.driverProperties.containsKey(methodName.toUpperCase())) {
                Vector values = (Vector)this.driverProperties.get(methodName.toUpperCase());
                this.executor.runMethod(methods[i], dataSourceObject, values);
                continue;
            }
            if (methodName.equalsIgnoreCase("setUser")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(1), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setPassword")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(2), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setLoginTimeOut")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(4), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setLogWriter")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(5), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDatabaseName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(6), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDataSourceName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(7), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDescription")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(8), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setNetworkProtocol")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(9), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setPortNumber")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(10), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setRoleName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(11), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setServerName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(12), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxStatements")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(13), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setInitialPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(14), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMinPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(15), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(16), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxIdleTime")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(17), methods[i], dataSourceObject);
                continue;
            }
            if (!methodName.equalsIgnoreCase("setPropertyCycle")) continue;
            this.executor.runJavaBeanMethod(this.spec.getDetail(18), methods[i], dataSourceObject);
        }
        return dataSourceObject;
    }

    private Hashtable parseDriverProperties(DataSourceSpec spec) throws ResourceException {
        String delim = spec.getDetail(21);
        String escape = spec.getDetail(33);
        String prop = spec.getDetail(19);
        if (prop == null || prop.trim().equals("")) {
            return new Hashtable();
        }
        if (delim == null || delim.equals("")) {
            String msg = sm.getString("dsob.delim_not_specified");
            throw new ResourceException(msg);
        }
        if (escape == null || escape.equals("")) {
            String msg = sm.getString("dsob.escape_char_not_specified");
            throw new ResourceException(msg);
        }
        return this.parseDriverProperties(prop, escape, delim);
    }

    public Hashtable parseDriverProperties(String values, String escape, String delimiter) {
        Hashtable result = new Hashtable();
        String parsedValue = "";
        String name = "";
        String value = "";
        char escapeChar = escape.charAt(0);
        char delimiterChar = delimiter.charAt(0);
        while (values.length() > 0) {
            if (values.charAt(0) == delimiterChar) {
                if (values.charAt(1) == delimiterChar) {
                    value = parsedValue;
                    Vector<String> v = new Vector<String>();
                    v.add(value);
                    result.put(name, v);
                    parsedValue = "";
                    values = values.substring(2);
                    continue;
                }
                name = parsedValue.toUpperCase();
                parsedValue = "";
                values = values.substring(1);
                continue;
            }
            if (values.charAt(0) == escapeChar) {
                if (values.charAt(1) == escapeChar) {
                    parsedValue = parsedValue + values.charAt(1);
                } else if (values.charAt(1) == delimiterChar) {
                    parsedValue = parsedValue + values.charAt(1);
                }
                values = values.substring(2);
                continue;
            }
            if (values.charAt(0) == escapeChar) continue;
            parsedValue = parsedValue + values.charAt(0);
            values = values.substring(1);
        }
        return result;
    }

    private Object getDataSourceObject() throws ResourceException {
        String className = this.spec.getDetail(20);
        try {
            Class<?> dataSourceClass;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                dataSourceClass = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException cnfe) {
                cl = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getCommonClassLoader();
                dataSourceClass = Class.forName(className, true, cl);
            }
            Object dataSourceObject = dataSourceClass.newInstance();
            return dataSourceObject;
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe_ds", cnfe);
            String msg = sm.getString("dsob.class_not_found", (Object)className);
            throw new ResourceException(msg);
        }
        catch (InstantiationException ce) {
            _logger.log(Level.SEVERE, "jdbc.exc_inst", className);
            String msg = sm.getString("dsob.error_instantiating", (Object)className);
            throw new ResourceException(msg);
        }
        catch (IllegalAccessException ce) {
            _logger.log(Level.SEVERE, "jdbc.exc_acc_inst", className);
            String msg = sm.getString("dsob.access_error", (Object)className);
            throw new ResourceException(msg);
        }
    }

    public static boolean isJDBC40() {
        return jdbc40;
    }

    private static boolean detectJDBC40() {
        boolean jdbc40 = false;
        try {
            Class.forName("java.sql.Wrapper");
            jdbc40 = true;
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.FINEST, "could not find Wrapper(available in jdbc-40), jdk supports only jdbc-30");
        }
        return jdbc40;
    }
}

