/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

class ConfigurationListener2
extends ConfigurationListener
implements MetaTypeProvider {
    final String pid;
    private ObjectClassDefinition ocd;
    private final OsgiManager osgiManager;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$metatype$MetaTypeProvider;

    static ServiceRegistration create(OsgiManager osgiManager) {
        ConfigurationListener2 cl = new ConfigurationListener2(osgiManager);
        return ConfigurationListener2.registerService(cl, new String[]{(class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationListener2.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (class$org$osgi$service$metatype$MetaTypeProvider == null ? (class$org$osgi$service$metatype$MetaTypeProvider = ConfigurationListener2.class$("org.osgi.service.metatype.MetaTypeProvider")) : class$org$osgi$service$metatype$MetaTypeProvider).getName()});
    }

    private ConfigurationListener2(OsgiManager osgiManager) {
        super(osgiManager);
        this.pid = osgiManager.getConfigurationPid();
        this.osgiManager = osgiManager;
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!this.pid.equals(id)) {
            return null;
        }
        if (this.ocd == null) {
            final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
            adList.add(new AttributeDefinitionImpl("manager.root", "Root URI", "The root path to the OSGi Management Console.", "/system/console"));
            adList.add(new AttributeDefinitionImpl("default.render", "Default Page", "The name of the default configuration page when invoking the OSGi Management console.", "bundles"));
            adList.add(new AttributeDefinitionImpl("realm", "Realm", "The name of the HTTP Authentication Realm.", "OSGi Management Console"));
            adList.add(new AttributeDefinitionImpl("username", "User Name", "The name of the user allowed to access the OSGi Management Console. To disable authentication clear this value.", "admin"));
            adList.add(new AttributeDefinitionImpl("password", "Password", "The password for the user allowed to access the OSGi Management Console.", "admin"));
            adList.add(new AttributeDefinitionImpl("loglevel", "Log Level", "Logging Level", 3, new String[]{String.valueOf(2)}, 0, new String[]{"Debug", "Information", "Warn", "Error"}, new String[]{"4", "3", "2", "1"}));
            TreeMap<String, String> namesByClassName = new TreeMap<String, String>();
            ClassLoader loader = this.getClass().getClassLoader();
            String[] defaultPluginsClasses = OsgiManager.PLUGIN_CLASSES;
            for (int i = 0; i < defaultPluginsClasses.length; ++i) {
                try {
                    Object plugin = loader.loadClass(defaultPluginsClasses[i]).newInstance();
                    if (!(plugin instanceof AbstractWebConsolePlugin)) continue;
                    String name = ((AbstractWebConsolePlugin)((Object)plugin)).getTitle();
                    if (name.startsWith("%")) {
                        ResourceBundle rb = this.osgiManager.resourceBundleManager.getResourceBundle(((AbstractWebConsolePlugin)((Object)plugin)).getBundle(), Locale.ENGLISH);
                        name = rb.getString(name.substring(1));
                    }
                    namesByClassName.put(defaultPluginsClasses[i], name);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            String[] classes = namesByClassName.keySet().toArray(new String[namesByClassName.size()]);
            String[] names = namesByClassName.values().toArray(new String[namesByClassName.size()]);
            adList.add(new AttributeDefinitionImpl("plugins", "Plugins", "Select active plugins", 1, classes, Integer.MIN_VALUE, names, classes));
            this.ocd = new ObjectClassDefinition(){
                private final AttributeDefinition[] attrs;
                {
                    this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
                }

                public String getName() {
                    return "Apache Felix OSGi Management Console";
                }

                public InputStream getIcon(int arg0) {
                    return null;
                }

                public String getID() {
                    return ConfigurationListener2.this.pid;
                }

                public String getDescription() {
                    return "Configuration of the Apache Felix OSGi Management Console.";
                }

                public AttributeDefinition[] getAttributeDefinitions(int filter) {
                    return filter == 2 ? null : this.attrs;
                }
            };
        }
        return this.ocd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description, String defaultValue) {
            this(id, name, description, 1, new String[]{defaultValue}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

