/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.AttachmentProvider;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.ModeAwareConfigurationPrinter;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationRender
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "config";
    private static final String TITLE = "%configStatus.pluginTitle";
    private static final String[] CSS_REFS = new String[]{"/res/ui/configurationrender.css"};
    private static final Locale DEFAULT = Locale.ENGLISH;
    private static final SimpleDateFormat FILE_NAME_FORMAT = new SimpleDateFormat("'config/configuration-status-'yyyyMMdd'-'HHmmZ");
    private static final DateFormat DISPLAY_DATE_FORMAT = DateFormat.getDateTimeInstance(1, 1, Locale.US);
    private final ResourceBundleManager resourceBundleManager;
    private ServiceTracker cfgPrinterTracker;
    private int cfgPrinterTrackerCount;
    private ArrayList configurationPrinters;

    public ConfigurationRender(ResourceBundleManager resourceBundleManager) {
        super(LABEL, TITLE, CSS_REFS);
        this.resourceBundleManager = resourceBundleManager;
    }

    public void deactivate() {
        ServiceTracker oldTracker = this.cfgPrinterTracker;
        if (oldTracker != null) {
            oldTracker.close();
        }
        this.cfgPrinterTracker = null;
        this.configurationPrinters = null;
        super.deactivate();
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo().endsWith(".txt")) {
            response.setContentType("text/plain; charset=utf-8");
            PlainTextConfigurationWriter pw = new PlainTextConfigurationWriter(response.getWriter());
            this.printConfigurationStatus(pw, "txt");
            pw.flush();
        } else if (request.getPathInfo().endsWith(".zip")) {
            String type = this.getServletContext().getMimeType(request.getPathInfo());
            if (type == null) {
                type = "application/x-zip";
            }
            response.setContentType(type);
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            zip.setLevel(1);
            zip.setMethod(8);
            ZipConfigurationWriter pw = new ZipConfigurationWriter(zip);
            this.printConfigurationStatus(pw, "zip");
            pw.flush();
            this.addAttachments(pw, "zip");
            zip.finish();
        } else if (request.getPathInfo().endsWith(".nfo")) {
            WebConsoleUtil.setNoCache(response);
            response.setContentType("text/html; charset=utf-8");
            String name = request.getPathInfo();
            name = name.substring(name.lastIndexOf(47) + 1);
            name = name.substring(0, name.length() - 4);
            name = WebConsoleUtil.urlDecode(name);
            HtmlConfigurationWriter pw = new HtmlConfigurationWriter(response.getWriter());
            pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            pw.println("  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            pw.println("<head><title>dummy</title></head><body><div>");
            ArrayList printers = this.getConfigurationPrinters();
            Iterator i = printers.iterator();
            while (i.hasNext()) {
                PrinterDesc desc = (PrinterDesc)i.next();
                if (!desc.label.equals(name)) continue;
                this.printConfigurationPrinter(pw, desc, "web");
                pw.println("</div></body></html>");
                return;
            }
            response.sendError(500, "Invalid configuration printer: " + name);
        } else {
            super.doGet(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        pw.println("<script type='text/javascript' src='${appRoot}/res/ui/ui.tabs.paging.js'></script>");
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.println("$(document).ready(function() {$('#tabs').tabs().tabs('paging')} );");
        pw.println("// ]]>");
        pw.println("</script>");
        pw.println("<br/><p class=\"statline\">");
        Date currentTime = new Date();
        DateFormat dateFormat = DISPLAY_DATE_FORMAT;
        synchronized (dateFormat) {
            pw.print("Date: ");
            pw.println(DISPLAY_DATE_FORMAT.format(currentTime));
        }
        dateFormat = FILE_NAME_FORMAT;
        synchronized (dateFormat) {
            String fileName = FILE_NAME_FORMAT.format(currentTime);
            pw.print("<br/>Download as <a href='");
            pw.print(fileName);
            pw.print(".txt'>[Single File]</a> or as <a href='");
            pw.print(fileName);
            pw.println(".zip'>[ZIP]</a>");
        }
        pw.println("</p>");
        pw.println("<div id='tabs'> <!-- tabs container -->");
        pw.println("<ul> <!-- tabs on top -->");
        String pluginRoot = request.getAttribute("felix.webconsole.pluginRoot") + "/";
        ArrayList printers = this.getConfigurationPrinters();
        Iterator i = printers.iterator();
        while (i.hasNext()) {
            PrinterDesc desc = (PrinterDesc)i.next();
            String label = desc.label;
            String title = desc.title;
            pw.print("<li><a href='" + pluginRoot + label + ".nfo'>" + title + "</a></li>");
        }
        pw.println("</ul> <!-- end tabs on top -->");
        pw.println();
        pw.println("</div> <!-- end tabs container -->");
        pw.flush();
    }

    private void printConfigurationStatus(ConfigurationWriter pw, String mode) {
        Iterator cpi = this.getConfigurationPrinters().iterator();
        while (cpi.hasNext()) {
            PrinterDesc desc = (PrinterDesc)cpi.next();
            if (!desc.match(mode)) continue;
            this.printConfigurationPrinter(pw, desc, mode);
        }
    }

    private final ArrayList getConfigurationPrinters() {
        if (this.cfgPrinterTracker == null) {
            this.cfgPrinterTracker = new ServiceTracker(this.getBundleContext(), ConfigurationPrinter.SERVICE, null);
            this.cfgPrinterTracker.open();
            this.cfgPrinterTrackerCount = -1;
        }
        if (this.cfgPrinterTrackerCount != this.cfgPrinterTracker.getTrackingCount()) {
            TreeMap cp = new TreeMap();
            ServiceReference[] refs = this.cfgPrinterTracker.getServiceReferences();
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    ConfigurationPrinter cfgPrinter = (ConfigurationPrinter)this.cfgPrinterTracker.getService(refs[i]);
                    this.addConfigurationPrinter(cp, cfgPrinter, refs[i].getBundle(), refs[i].getProperty("felix.webconsole.label"), refs[i].getProperty("modes"));
                }
            }
            this.configurationPrinters = new ArrayList(cp.values());
            this.cfgPrinterTrackerCount = this.cfgPrinterTracker.getTrackingCount();
        }
        return this.configurationPrinters;
    }

    private final void addConfigurationPrinter(SortedMap printers, ConfigurationPrinter cfgPrinter, Bundle provider, Object labelProperty, Object mode) {
        if (cfgPrinter != null) {
            String title = this.getTitle(cfgPrinter.getTitle(), provider);
            String sortKey = title;
            if (printers.containsKey(sortKey)) {
                String idxTitle;
                int idx = -1;
                while (printers.containsKey(idxTitle = sortKey + ++idx)) {
                }
                sortKey = idxTitle;
            }
            String label = labelProperty instanceof String ? (String)labelProperty : sortKey;
            printers.put(sortKey, new PrinterDesc(cfgPrinter, title, label, mode));
        }
    }

    private final void printConfigurationPrinter(ConfigurationWriter pw, PrinterDesc desc, String mode) {
        pw.title(desc.title);
        ConfigurationPrinter cp = desc.printer;
        if (cp instanceof ModeAwareConfigurationPrinter) {
            ((ModeAwareConfigurationPrinter)cp).printConfiguration(pw, mode);
        } else {
            cp.printConfiguration(pw);
        }
        pw.end();
    }

    public static final void infoLine(PrintWriter pw, String indent, String label, Object value) {
        if (indent != null) {
            pw.print(indent);
        }
        if (label != null) {
            pw.print(label);
            pw.print(" = ");
        }
        pw.print(ConfigurationRender.asString(value));
        pw.println();
    }

    private static final String asString(Object value) {
        if (value == null) {
            return "n/a";
        }
        if (value.getClass().isArray()) {
            StringBuffer dest = new StringBuffer();
            Object[] values = (Object[])value;
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            return dest.toString();
        }
        return value.toString();
    }

    private final String getTitle(String title, Bundle provider) {
        if (!title.startsWith("%")) {
            return title;
        }
        ResourceBundle res = this.resourceBundleManager.getResourceBundle(provider, DEFAULT);
        return res.getString(title.substring(1));
    }

    private void addAttachments(ConfigurationWriter cf, String mode) throws IOException {
        Iterator cpi = this.getConfigurationPrinters().iterator();
        while (cpi.hasNext()) {
            URL[] attachments;
            PrinterDesc desc = (PrinterDesc)cpi.next();
            if (!desc.match(mode) || !(desc.printer instanceof AttachmentProvider) || (attachments = ((AttachmentProvider)((Object)desc.printer)).getAttachments(mode)) == null) continue;
            cf.handleAttachments(desc.title, attachments);
        }
    }

    private static class ZipConfigurationWriter
    extends ConfigurationWriter {
        private final ZipOutputStream zip;
        private int counter;

        ZipConfigurationWriter(ZipOutputStream zip) {
            super(new OutputStreamWriter(zip));
            this.zip = zip;
        }

        public void title(String title) {
            String name = MessageFormat.format("{0,number,000}-{1}.txt", new Integer(this.counter), title);
            ++this.counter;
            ZipEntry entry = new ZipEntry(name);
            try {
                this.zip.putNextEntry(entry);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        private OutputStream startFile(String title, String name) {
            String path = MessageFormat.format("{0,number,000}-{1}/{2}", new Integer(this.counter), title, name);
            ZipEntry entry = new ZipEntry(path);
            try {
                this.zip.putNextEntry(entry);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.zip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAttachments(String title, URL[] attachments) throws IOException {
            for (int i = 0; i < attachments.length; ++i) {
                int pos;
                URL current = attachments[i];
                String path = current.getPath();
                String name = path == null || path.length() == 0 ? "file" + Double.doubleToLongBits(Math.random()) : ((pos = path.lastIndexOf(47)) == -1 ? path : path.substring(pos + 1));
                OutputStream os = this.startFile(title, name);
                InputStream is = current.openStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
                this.end();
            }
            ++this.counter;
        }

        public void end() {
            this.flush();
            try {
                this.zip.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class PlainTextConfigurationWriter
    extends ConfigurationWriter {
        PlainTextConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        public void title(String title) {
            this.print("*** ");
            this.print(title);
            this.println(":");
        }

        public void end() {
            this.println();
        }
    }

    private static final class PrinterDesc {
        public final ConfigurationPrinter printer;
        public final String title;
        public final String label;
        private final String[] modes;
        private static final List CUSTOM_MODES = new ArrayList();

        public PrinterDesc(ConfigurationPrinter printer, String title, String label, Object modes) {
            this.printer = printer;
            this.title = title;
            this.label = label;
            if (modes == null || !(modes instanceof String) && !(modes instanceof String[])) {
                this.modes = null;
            } else if (modes instanceof String) {
                this.modes = CUSTOM_MODES.contains(modes) ? new String[]{modes.toString()} : null;
            } else {
                String[] values = (String[])modes;
                boolean valid = values.length > 0;
                for (int i = 0; i < values.length; ++i) {
                    if (CUSTOM_MODES.contains(values[i])) continue;
                    valid = false;
                    break;
                }
                this.modes = valid ? values : null;
            }
        }

        public boolean match(String mode) {
            if (this.modes == null) {
                return true;
            }
            for (int i = 0; i < this.modes.length; ++i) {
                if (!this.modes[i].equals(mode)) continue;
                return true;
            }
            return false;
        }

        static {
            CUSTOM_MODES.add("txt");
            CUSTOM_MODES.add("web");
            CUSTOM_MODES.add("zip");
        }
    }

    private static class HtmlConfigurationWriter
    extends ConfigurationWriter {
        private boolean doFilter;

        HtmlConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        public void title(String title) {
            this.doFilter = true;
        }

        public void end() {
            this.doFilter = false;
        }

        public void println() {
            if (this.doFilter) {
                super.write("<br/>", 0, 5);
            } else {
                super.println();
            }
        }

        public void write(int character) {
            if (this.doFilter && character == 60) {
                super.write("&lt;");
            } else {
                super.write(character);
            }
        }

        public void write(char[] chars, int off, int len) {
            if (this.doFilter) {
                this.writeFiltered(new String(chars, off, len));
            } else {
                super.write(chars, off, len);
            }
        }

        public void write(String string, int off, int len) {
            if (this.doFilter) {
                this.writeFiltered(string.substring(off, len));
            } else {
                super.write(string, off, len);
            }
        }

        private void writeFiltered(String string) {
            string = WebConsoleUtil.escapeHtml(string);
            super.write(string, 0, string.length());
        }
    }

    private static abstract class ConfigurationWriter
    extends PrintWriter {
        ConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        abstract void title(String var1);

        abstract void end();

        public void handleAttachments(String title, URL[] urls) throws IOException {
            throw new UnsupportedOperationException("handleAttachments not supported by this configuration writer: " + this);
        }
    }
}

