/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="jdbc-resource")
@I18n(value="jdbc.resource.manager")
@ConfiguredBy(value=Resources.class)
public class JDBCResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCResourceManager.class);
    private static final String DESCRIPTION = "description";
    private String jndiName = null;
    private String description = null;
    private String poolName = null;
    private String enabled = Boolean.TRUE.toString();

    public String getResourceType() {
        return "jdbc-resource";
    }

    /*
     * Unable to fully structure code
     */
    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, Server targetServer, boolean requiresNewTransaction) throws Exception {
        this.setAttributes(attributes);
        if (this.jndiName == null) {
            msg = JDBCResourceManager.localStrings.getLocalString("create.jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            return new ResourceStatus(1, msg);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof BindableResource) || !((BindableResource)resource).getJndiName().equals(this.jndiName)) continue;
            msg = JDBCResourceManager.localStrings.getLocalString("create.jdbc.resource.duplicate", "A resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg, true);
        }
        if (!this.isConnPoolExists(resources, this.poolName)) {
            msg = JDBCResourceManager.localStrings.getLocalString("create.jdbc.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of jdbc connection pools.", new Object[]{this.poolName});
            status = new ResourceStatus(1, msg);
            return status;
        }
        if (requiresNewTransaction) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        return JDBCResourceManager.this.createResource(param, properties);
                    }
                }, (ConfigBeanProxy)resources);
                if (targetServer.isResourceRefExists(this.jndiName)) ** GOTO lbl27
                targetServer.createResourceRef(this.enabled, this.jndiName);
            }
            catch (TransactionFailure tfe) {
                msg = JDBCResourceManager.localStrings.getLocalString("create.jdbc.resource.fail", "JDBC resource {0} create failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
                status = new ResourceStatus(1, msg);
                status.setException((Throwable)tfe);
                return status;
            }
        } else {
            this.createResource(resources, properties);
        }
lbl27:
        // 3 sources

        msg = JDBCResourceManager.localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private void setAttributes(HashMap attributes) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.poolName = (String)attributes.get("pool-name");
        this.enabled = (String)attributes.get("enabled");
    }

    private JdbcResource createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private JdbcResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcResource jdbcResource = (JdbcResource)param.createChild(JdbcResource.class);
        jdbcResource.setJndiName(this.jndiName);
        if (this.description != null) {
            jdbcResource.setDescription(this.description);
        }
        jdbcResource.setPoolName(this.poolName);
        jdbcResource.setEnabled(this.enabled);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)jdbcResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                jdbcResource.getProperty().add(prop);
            }
        }
        return jdbcResource;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties) throws Exception {
        this.setAttributes(attributes);
        return this.createConfigBean(resources, properties);
    }

    public ResourceStatus delete(Resources resources, final JdbcResource[] jdbcResources, final String jndiName, Server targetServer) throws Exception {
        if (jndiName == null) {
            String msg = localStrings.getLocalString("jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            return new ResourceStatus(1, msg);
        }
        if (!this.isResourceExists(resources, jndiName)) {
            String msg = localStrings.getLocalString("delete.jdbc.resource.notfound", "A JDBC resource named {0} does not exist.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (JdbcResource resource : jdbcResources) {
                        if (!resource.getJndiName().equals(jndiName)) continue;
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
                return new ResourceStatus(1, msg);
            }
            targetServer.deleteResourceRef(jndiName);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbc.resource.deleteSuccess", "JDBC resource {0} deleted successfully", new Object[]{jndiName});
        return new ResourceStatus(0, msg);
    }

    public ArrayList list(JdbcResource[] jdbcResources) {
        ArrayList<String> list = new ArrayList<String>();
        for (JdbcResource r : jdbcResources) {
            list.add(r.getJndiName());
        }
        return list;
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnPoolExists(Resources resources, String poolName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcConnectionPool) || !((JdbcConnectionPool)resource).getName().equals(poolName)) continue;
            return true;
        }
        return false;
    }
}

