/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.DataSource;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

@ConnectionDefinition(connectionFactory=javax.sql.DataSource.class, connectionFactoryImpl=DataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class DMManagedConnectionFactory
extends ManagedConnectionFactory {
    Properties props;
    private static Logger _logger = LogDomains.getLogger(DMManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = false;

    @Override
    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        if (this.dsObjBuilder == null) {
            this.dsObjBuilder = new DataSourceObjectBuilder(this.spec);
        }
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        try {
            Class.forName(this.spec.getDetail(20));
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe", cnfe);
            throw new ResourceException("The driver could not be loaded: " + this.spec.getDetail(20));
        }
        Connection dsConn = null;
        Properties driverProps = new Properties();
        Hashtable properties = this.dsObjBuilder.parseDriverProperties(this.spec, false);
        Set keys = properties.keySet();
        for (String key : keys) {
            String value = null;
            Vector values = (Vector)properties.get(key);
            if (!values.isEmpty() && values.size() == 1) {
                value = (String)values.firstElement();
            } else if (values.size() > 1) {
                this.logFine("More than one value for key : " + key);
            }
            String prop = this.getParsedKey(key);
            driverProps.put(prop, value);
            if (!prop.equalsIgnoreCase("URL") || this.spec.getDetail(3) != null) continue;
            this.setConnectionURL(value);
        }
        try {
            if (cxRequestInfo != null) {
                driverProps.setProperty("user", pc.getUserName());
                driverProps.setProperty("password", new String(pc.getPassword()));
            } else {
                String user = this.spec.getDetail(1);
                String password = this.spec.getDetail(2);
                if (user != null) {
                    driverProps.setProperty("user", user);
                }
                if (password != null) {
                    driverProps.setProperty("password", password);
                }
            }
            dsConn = DriverManager.getConnection(this.spec.getDetail(3), driverProps);
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_create_mc", sqle);
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage());
        }
        ManagedConnection mc = this.constructManagedConnection(null, dsConn, pc, this);
        this.setIsolation(mc);
        this.isValid(mc);
        return mc;
    }

    private String getParsedKey(String key) throws ResourceException {
        int indexOfSet;
        String parsedKey;
        block6: {
            parsedKey = null;
            indexOfSet = -1;
            try {
                indexOfSet = key.indexOf("set");
            }
            catch (NullPointerException npe) {
                if (!this.debug) break block6;
                _logger.log(Level.FINE, "jdbc.exc_caught_ign", npe.getMessage());
            }
        }
        if (indexOfSet == 0) {
            block7: {
                try {
                    parsedKey = key.substring(indexOfSet + 3, key.length()).trim();
                }
                catch (IndexOutOfBoundsException iobe) {
                    if (!this.debug) break block7;
                    _logger.log(Level.FINE, "jdbc.exc_caught_ign", iobe.getMessage());
                }
            }
            if (parsedKey.equals("")) {
                throw new ResourceException("Invalid driver properties string - Key cannot be an empty string");
            }
        }
        return parsedKey;
    }

    private Properties getPropertiesObj() throws ResourceException {
        if (this.props != null) {
            return this.props;
        }
        this.props = new Properties();
        this.props.setProperty("user", this.getUser());
        this.props.setProperty("password", this.getPassword());
        String driverProps = this.spec.getDetail(19);
        String delimiter = this.spec.getDetail(21);
        if (driverProps != null && !driverProps.trim().equals("")) {
            if (delimiter == null || delimiter.equals("")) {
                throw new ResourceException("Invalid driver properties string - delimiter not properly set!!");
            }
            StringTokenizer st = new StringTokenizer(driverProps, delimiter);
            while (st.hasMoreTokens()) {
                String value;
                String key;
                block16: {
                    int indexOfEqualsSign;
                    String keyValuePair;
                    block15: {
                        block14: {
                            keyValuePair = null;
                            try {
                                keyValuePair = st.nextToken();
                            }
                            catch (NoSuchElementException nsee) {
                                throw new ResourceException("Invalid driver properties string - Key value pair not available: " + nsee.getMessage());
                            }
                            indexOfEqualsSign = -1;
                            try {
                                indexOfEqualsSign = keyValuePair.indexOf("=");
                                if (indexOfEqualsSign == -1) {
                                    throw new ResourceException("Invalid driver properties string - Key value pair should be of the form key = value");
                                }
                            }
                            catch (NullPointerException npe) {
                                if (!this.debug) break block14;
                                _logger.log(Level.FINE, "jdbc.exc_caught_ign", npe.getMessage());
                            }
                        }
                        key = null;
                        try {
                            key = keyValuePair.substring(0, indexOfEqualsSign).trim();
                        }
                        catch (IndexOutOfBoundsException iobe) {
                            if (!this.debug) break block15;
                            _logger.log(Level.FINE, "jdbc.exc_caught_ign", iobe.getMessage());
                        }
                    }
                    if (key.equals("")) {
                        throw new ResourceException("Invalid driver properties string - Key cannot be an empty string");
                    }
                    value = null;
                    try {
                        value = keyValuePair.substring(indexOfEqualsSign + 1).trim();
                    }
                    catch (IndexOutOfBoundsException iobe) {
                        if (!this.debug) break block16;
                        _logger.log(Level.FINE, "jdbc.exc_caught_ign", iobe.getMessage());
                    }
                }
                this.props.setProperty(key, value);
            }
        }
        return this.props;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof DMManagedConnectionFactory) {
            DMManagedConnectionFactory otherMCF = (DMManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    @Override
    public void setLoginTimeOut(String loginTimeOut) {
        block2: {
            int timeOut = 0;
            try {
                timeOut = Integer.valueOf(loginTimeOut);
                DriverManager.setLoginTimeout(timeOut);
                this.spec.setDetail(4, loginTimeOut);
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                _logger.log(Level.FINE, "jdbc.exc_caught_ign", e.getMessage());
            }
        }
    }

    @Override
    @ConfigProperty(type=String.class, defaultValue="org.apache.derby.jdbc.ClientDriver")
    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public void setURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getURL() {
        return this.spec.getDetail(3);
    }

    public void setConnectionURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getConnectionURL() {
        return this.spec.getDetail(3);
    }

    @Override
    public Object getDataSource() throws ResourceException {
        return null;
    }
}

