/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.jdbc.admin.cli.JDBCConnectionPoolManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Cluster(value={RuntimeType.ALL})
@Service(name="delete-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jdbc.connection.pool")
public class DeleteJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJdbcConnectionPool.class);
    @Param(optional=true, defaultValue="false")
    Boolean cascade;
    @Param(name="jdbc_connection_pool_id", primary=true)
    String jdbc_connection_pool_id;
    @Param(optional=true)
    String target;
    @Inject
    Resources resources;
    @Inject
    Server[] servers;
    @Inject
    JdbcConnectionPool[] connPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JDBCConnectionPoolManager jdbcConnMgr = new JDBCConnectionPoolManager();
            ResourceStatus rs = jdbcConnMgr.delete(this.servers, this.resources, this.connPools, this.cascade.toString(), this.jdbc_connection_pool_id);
            if (rs.getStatus() == 0) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                if (rs.getMessage() != null) {
                    report.setMessage(rs.getMessage());
                }
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                if (rs.getException() != null) {
                    report.setFailureCause(rs.getException());
                    Logger.getLogger(DeleteJdbcConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-jdbc-connection-pool", rs.getException());
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(DeleteJdbcConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-jdbc-connection-pool", e);
            String msg = e.getMessage() != null ? e.getMessage() : localStrings.getLocalString("delete.jdbc.connection.pool.fail", "{0} delete failed ", new Object[]{this.jdbc_connection_pool_id});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

