/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jdbcra-mon", group="monitoring")
@ManagedObject
@Description(value="JDBC RA Statistics")
public class JdbcStatsProvider {
    private CountStatisticImpl numStatementCacheHit = new CountStatisticImpl("NumStatementCacheHit", "count", "The total number of Statement Cache hits.");
    private CountStatisticImpl numStatementCacheMiss = new CountStatisticImpl("NumStatementCacheMiss", "count", "The total number of Statement Cache misses.");
    private String poolName;

    public JdbcStatsProvider(String poolName) {
        this.poolName = poolName;
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheHitEvent")
    public void statementCacheHitEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.poolName)) {
            this.numStatementCacheHit.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheMissEvent")
    public void statementCacheMissEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.poolName)) {
            this.numStatementCacheMiss.increment();
        }
    }

    @ManagedAttribute(id="numstatementcachehit")
    public CountStatistic getNumStatementCacheHit() {
        return this.numStatementCacheHit.getStatistic();
    }

    @ManagedAttribute(id="numstatementcachemiss")
    public CountStatistic getNumStatementCacheMiss() {
        return this.numStatementCacheMiss.getStatistic();
    }
}

