/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.admin.cli.resources.BindableResourcesHelper;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@Cluster(value={RuntimeType.DAS})
@Service(name="list-jdbc-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.jdbc.resources")
public class ListJdbcResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJdbcResources.class);
    @Param(primary=true, optional=true, defaultValue="server", alias="targetName")
    private String target;
    @Inject
    private JdbcResource[] jdbcResources;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private JDBCResourceManager jdbcMgr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList list = this.jdbcMgr.list(this.jdbcResources);
            for (String jndiName : list) {
                if (!this.bindableResourcesHelper.resourceExists(jndiName, this.target)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
            }
            if (report.getTopMessagePart().getChildren().size() == 0) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("list.jdbc.resources.empty", "Nothing to list."));
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jdbc.resources.failed", "List JDBC resources failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

