/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.monitoring;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceCache;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jdbcra-mon", group="monitoring")
@ManagedObject
@Description(value="JDBC RA Statistics")
public class JdbcStatsProvider {
    private StringStatisticImpl freqUsedSqlQueries = new StringStatisticImpl("FreqUsedSqlQueries", "List", "Most frequently used sql queries");
    private CountStatisticImpl numStatementCacheHit = new CountStatisticImpl("NumStatementCacheHit", "count", "The total number of Statement Cache hits.");
    private CountStatisticImpl numStatementCacheMiss = new CountStatisticImpl("NumStatementCacheMiss", "count", "The total number of Statement Cache misses.");
    private String poolName;
    private SQLTraceCache sqlTraceCache;

    public JdbcStatsProvider(String poolName, int sqlTraceCacheSize, long timeToKeepQueries) {
        this.poolName = poolName;
        if (sqlTraceCacheSize > 0) {
            this.sqlTraceCache = new SQLTraceCache(poolName, sqlTraceCacheSize, timeToKeepQueries);
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheHitEvent")
    public void statementCacheHitEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.poolName)) {
            this.numStatementCacheHit.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheMissEvent")
    public void statementCacheMissEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.poolName)) {
            this.numStatementCacheMiss.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:sqltracing:cacheSqlQueryEvent")
    public void cacheSqlQueryEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="sql") String sql) {
        if (poolName != null && poolName.equals(this.poolName) && this.sqlTraceCache != null && sql != null) {
            SQLTrace cacheObj = new SQLTrace(sql, 1, System.currentTimeMillis());
            this.sqlTraceCache.checkAndUpdateCache(cacheObj);
        }
    }

    @ManagedAttribute(id="numstatementcachehit")
    public CountStatistic getNumStatementCacheHit() {
        return this.numStatementCacheHit;
    }

    @ManagedAttribute(id="numstatementcachemiss")
    public CountStatistic getNumStatementCacheMiss() {
        return this.numStatementCacheMiss;
    }

    @ManagedAttribute(id="frequsedsqlqueries")
    public StringStatistic getfreqUsedSqlQueries() {
        if (this.sqlTraceCache != null) {
            this.freqUsedSqlQueries.setCurrent(this.sqlTraceCache.getTopQueries());
        }
        return this.freqUsedSqlQueries;
    }

    public SQLTraceCache getSqlTraceCache() {
        return this.sqlTraceCache;
    }
}

