/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.appserv.connectors.internal.spi.MCFLifecycleListener;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.common.DataSourceSpec;
import com.sun.gjc.monitoring.JdbcStatsProvider;
import com.sun.gjc.spi.JdbcObjectsFactory;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ResourceAdapter;
import com.sun.gjc.util.SQLTraceDelegator;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.glassfish.api.jdbc.ConnectionValidation;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;

public abstract class ManagedConnectionFactory
implements javax.resource.spi.ManagedConnectionFactory,
ValidatingManagedConnectionFactory,
MCFLifecycleListener,
ResourceAdapterAssociation,
Serializable {
    protected DataSourceSpec spec = new DataSourceSpec();
    protected transient DataSourceObjectBuilder dsObjBuilder;
    protected PrintWriter logWriter = null;
    protected javax.resource.spi.ResourceAdapter ra = null;
    private static Logger _logger = LogDomains.getLogger(ManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    protected boolean statementWrapping;
    private JdbcObjectsFactory jdbcObjectsFactory = JdbcObjectsFactory.getInstance();
    protected SQLTraceDelegator sqlTraceDelegator;
    protected LazyEnlistableConnectionManager cm_;
    protected boolean isLazyCm_;
    private int statementCacheSize = 0;
    private String statementCacheType = null;
    private long statementLeakTimeout = 0L;
    private boolean statementLeakReclaim = false;
    private JdbcStatsProvider jdbcStatsProvider = null;
    protected static final StringManager localStrings = StringManager.getManager(DataSourceObjectBuilder.class);
    protected static final int JVM_OPTION_STATEMENT_WRAPPING_ON = 1;
    protected static final int JVM_OPTION_STATEMENT_WRAPPING_OFF = 0;
    protected static final int JVM_OPTION_STATEMENT_WRAPPING_NOT_SET = -1;
    private static int wrapStatement = -1;

    public Object createConnectionFactory() {
        this.logFine("In createConnectionFactory()");
        return this.jdbcObjectsFactory.getDataSourceInstance(this, null);
    }

    public Object createConnectionFactory(ConnectionManager cxManager) {
        this.logFine("In createConnectionFactory(javax.resource.spi.ConnectionManager cxManager)");
        DataSource cf = this.jdbcObjectsFactory.getDataSourceInstance(this, cxManager);
        if (cxManager instanceof LazyEnlistableConnectionManager) {
            this.cm_ = (LazyEnlistableConnectionManager)cxManager;
            this.isLazyCm_ = true;
        }
        return cf;
    }

    public abstract javax.resource.spi.ManagedConnection createManagedConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract boolean equals(Object var1);

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        this.logFine("In getResourceAdapter");
        return this.ra;
    }

    public int hashCode() {
        this.logFine("In hashCode");
        return this.spec.hashCode();
    }

    public javax.resource.spi.ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In matchManagedConnections");
        if (connectionSet == null) {
            return null;
        }
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        Iterator iter = connectionSet.iterator();
        ManagedConnection mc = null;
        while (iter.hasNext()) {
            try {
                mc = (ManagedConnection)iter.next();
            }
            catch (NoSuchElementException nsee) {
                _logger.log(Level.SEVERE, "jdbc.exc_iter");
                throw new ResourceException(nsee.getMessage());
            }
            if (pc == null && this.equals(mc.getManagedConnectionFactory())) {
                return mc;
            }
            if (!SecurityUtils.isPasswordCredentialEqual(pc, mc.getPasswordCredential())) continue;
            return mc;
        }
        return null;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        Iterator iter = connectionSet.iterator();
        HashSet<ManagedConnection> invalidConnections = new HashSet<ManagedConnection>();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            try {
                this.isValid(mc);
            }
            catch (ResourceException re) {
                invalidConnections.add(mc);
                mc.connectionErrorOccurred((Exception)((Object)re), null);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "jdbc.invalid_connection", re);
            }
        }
        return invalidConnections;
    }

    void isValid(ManagedConnection mc) throws ResourceException {
        boolean connectionValidationRequired;
        if (mc == null || mc.isTransactionInProgress()) {
            return;
        }
        String conVal = this.spec.getDetail(25);
        boolean bl = connectionValidationRequired = conVal == null ? false : Boolean.valueOf(conVal.toLowerCase());
        if (!connectionValidationRequired) {
            return;
        }
        String validationMethod = this.spec.getDetail(26).toLowerCase();
        mc.checkIfValid();
        Connection con = mc.getActualConnection();
        if (validationMethod.equals("custom-validation")) {
            this.isValidByCustomValidation(con, this.spec.getDetail(36));
        } else if (validationMethod.equals("auto-commit")) {
            this.isValidByAutoCommit(con);
        } else if (validationMethod.equals("meta-data")) {
            this.isValidByMetaData(con);
        } else if (validationMethod.equals("table")) {
            this.isValidByTableQuery(con, this.spec.getDetail(27));
        } else {
            throw new ResourceException("The validation method is not proper");
        }
    }

    protected void isValidByCustomValidation(Connection con, String validationClassName) throws ResourceException {
        boolean isValid = false;
        if (con == null) {
            throw new ResourceException("The connection is not valid as the connection is null");
        }
        try {
            Class<?> validationClass = Thread.currentThread().getContextClassLoader().loadClass(validationClassName);
            ConnectionValidation valClass = (ConnectionValidation)validationClass.newInstance();
            isValid = valClass.isConnectionValid(con);
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "jdbc.exc_custom_validation", validationClassName);
            throw new ResourceException((Throwable)e);
        }
        if (!isValid) {
            _logger.log(Level.INFO, "jdbc.exc_custom_validation", validationClassName);
            throw new ResourceException("Custom validation detected invalid connection");
        }
    }

    protected void isValidByAutoCommit(Connection con) throws ResourceException {
        if (con == null) {
            throw new ResourceException("The connection is not valid as the connection is null");
        }
        try {
            boolean ac = con.getAutoCommit();
            if (ac) {
                con.setAutoCommit(false);
            } else {
                con.rollback();
                con.setAutoCommit(true);
            }
            con.setAutoCommit(ac);
        }
        catch (Exception sqle) {
            _logger.log(Level.INFO, "jdbc.exc_autocommit_validation");
            throw new ResourceException((Throwable)sqle);
        }
    }

    protected void isValidByMetaData(Connection con) throws ResourceException {
        if (con == null) {
            throw new ResourceException("The connection is not valid as the connection is null");
        }
        try {
            con.getMetaData();
        }
        catch (Exception sqle) {
            _logger.log(Level.INFO, "jdbc.exc_metadata_validation");
            throw new ResourceException((Throwable)sqle);
        }
    }

    protected void isValidByTableQuery(Connection con, String tableName) throws ResourceException {
        if (con == null) {
            throw new ResourceException("The connection is not valid as the connection is null");
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*) FROM " + tableName);
            rs = stmt.executeQuery();
        }
        catch (Exception sqle) {
            _logger.log(Level.INFO, "jdbc.exc_table_validation", tableName);
            throw new ResourceException((Throwable)sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    protected void setIsolation(ManagedConnection mc) throws ResourceException {
        Connection con = mc.getActualConnection();
        if (con == null) {
            return;
        }
        String tranIsolation = this.spec.getDetail(28);
        if (tranIsolation != null && !tranIsolation.equals("")) {
            int tranIsolationInt = this.getTransactionIsolationInt(tranIsolation);
            try {
                con.setTransactionIsolation(tranIsolationInt);
                mc.setLastTransactionIsolationLevel(tranIsolationInt);
            }
            catch (SQLException sqle) {
                _logger.log(Level.SEVERE, "jdbc.exc_tx_iso", sqle);
                throw new ResourceException("The transaction isolation could not be set: " + sqle.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void resetIsolation(ManagedConnection mc, int tranIsol) throws ResourceException {
        String guaranteeIsolationLevel;
        Connection con = mc.getActualConnection();
        if (con == null) {
            return;
        }
        String tranIsolation = this.spec.getDetail(28);
        if (tranIsolation == null || tranIsolation.equals("") || (guaranteeIsolationLevel = this.spec.getDetail(29)) == null || guaranteeIsolationLevel.equals("")) return;
        boolean guarantee = Boolean.valueOf(guaranteeIsolationLevel.toLowerCase());
        if (guarantee) {
            int tranIsolationInt = this.getTransactionIsolationInt(tranIsolation);
            try {
                if (tranIsolationInt == con.getTransactionIsolation()) return;
                con.setTransactionIsolation(tranIsolationInt);
                return;
            }
            catch (SQLException sqle) {
                _logger.log(Level.SEVERE, "jdbc.exc_tx_iso", sqle);
                throw new ResourceException("The isolation level could not be set: " + sqle.getMessage());
            }
        }
        try {
            if (tranIsol == con.getTransactionIsolation()) return;
            con.setTransactionIsolation(tranIsol);
            return;
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_tx_iso", sqle);
            throw new ResourceException("The isolation level could not be set: " + sqle.getMessage());
        }
    }

    private void detectSqlTraceListeners() {
        String sqlTraceListeners = this.getSqlTraceListeners();
        String delimiter = ",";
        if (sqlTraceListeners != null && !sqlTraceListeners.equals("null")) {
            this.sqlTraceDelegator = new SQLTraceDelegator(this.getPoolMonitoringSubTreeRoot());
            StringTokenizer st = new StringTokenizer(sqlTraceListeners, delimiter);
            while (st.hasMoreTokens()) {
                String sqlTraceListener = st.nextToken().trim();
                if (sqlTraceListener.equals("")) continue;
                Class<?> listenerClass = null;
                SQLTraceListener listener = null;
                Constructor<?>[] constructors = null;
                Class<?>[] parameterTypes = null;
                Object[] initargs = null;
                try {
                    listenerClass = Thread.currentThread().getContextClassLoader().loadClass(sqlTraceListener);
                }
                catch (ClassNotFoundException ex) {
                    _logger.log(Level.SEVERE, "jdbc.sql_trace_listener_cnfe", sqlTraceListener);
                }
                Class<?>[] intf = listenerClass.getInterfaces();
                for (int i = 0; i < intf.length; ++i) {
                    Class<?> interfaceName = intf[i];
                    if (!interfaceName.getName().equals("org.glassfish.api.jdbc.SQLTraceListener")) continue;
                    try {
                        for (Constructor<?> constructor : constructors = listenerClass.getConstructors()) {
                            parameterTypes = constructor.getParameterTypes();
                            if (parameterTypes == null || parameterTypes.length != 0) continue;
                            listener = (SQLTraceListener)constructor.newInstance(initargs);
                        }
                    }
                    catch (InstantiationException ex) {
                        _logger.log(Level.SEVERE, "jdbc.sql_trace_listener_exception", ex.getMessage());
                    }
                    catch (IllegalAccessException ex) {
                        _logger.log(Level.SEVERE, "jdbc.sql_trace_listener_exception", ex.getMessage());
                    }
                    catch (IllegalArgumentException ex) {
                        _logger.log(Level.SEVERE, "jdbc.sql_trace_listener_exception", ex.getMessage());
                    }
                    catch (InvocationTargetException ex) {
                        _logger.log(Level.SEVERE, "jdbc.sql_trace_listener_exception", ex.getMessage());
                    }
                    catch (SecurityException ex) {
                        _logger.log(Level.SEVERE, "jdbc.sql_trace_listener_exception", ex.getMessage());
                    }
                    this.sqlTraceDelegator.registerSQLTraceListener(listener);
                }
            }
        }
    }

    private int getTransactionIsolationInt(String tranIsolation) throws ResourceException {
        if (tranIsolation.equalsIgnoreCase("read-uncommitted")) {
            return 1;
        }
        if (tranIsolation.equalsIgnoreCase("read-committed")) {
            return 2;
        }
        if (tranIsolation.equalsIgnoreCase("repeatable-read")) {
            return 4;
        }
        if (tranIsolation.equalsIgnoreCase("serializable")) {
            return 8;
        }
        throw new ResourceException("Invalid transaction isolation; the transaction isolation level can be empty or any of the following: read-uncommitted, read-committed, repeatable-read, serializable");
    }

    protected void validateAndSetIsolation(ManagedConnection mc) throws ResourceException {
        this.isValid(mc);
        this.setIsolation(mc);
    }

    private void detectStatementCachingSupport() {
        String cacheSize = this.getStatementCacheSize();
        String cacheType = this.getStatementCacheType();
        if (cacheSize != null) {
            try {
                this.statementCacheSize = Integer.valueOf(cacheSize);
                _logger.log(Level.FINE, "StatementCaching Size : " + this.statementCacheSize);
                if (cacheType == null || cacheType.trim().equals("")) {
                    _logger.fine(" Default StatementCaching Type : " + localStrings.getString("jdbc.statement-cache.default.datastructure"));
                } else {
                    _logger.fine("StatementCaching Type : " + cacheType);
                }
            }
            catch (NumberFormatException nfe) {
                _logger.fine("Exception while setting StatementCacheSize : " + nfe.getMessage());
            }
        }
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public void setResourceAdapter(javax.resource.spi.ResourceAdapter ra) {
        this.ra = ra;
    }

    @ConfigProperty(type=String.class, defaultValue="APP")
    public void setUser(String user) {
        this.spec.setDetail(1, user);
    }

    public String getUser() {
        return this.spec.getDetail(1);
    }

    @ConfigProperty(type=String.class, defaultValue="APP")
    public void setPassword(String passwd) {
        this.spec.setDetail(2, passwd);
    }

    public String getPassword() {
        return this.spec.getDetail(2);
    }

    @ConfigProperty(type=String.class, defaultValue="org.apache.derby.jdbc.ClientConnectionPoolDataSource")
    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public String getClassName() {
        return this.spec.getDetail(20);
    }

    @ConfigProperty(type=String.class, defaultValue="false")
    public void setConnectionValidationRequired(String conVldReq) {
        this.spec.setDetail(25, conVldReq);
    }

    public String getConnectionValidationRequired() {
        return this.spec.getDetail(25);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setValidationMethod(String validationMethod) {
        this.spec.setDetail(26, validationMethod);
    }

    public String getValidationMethod() {
        return this.spec.getDetail(26);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setValidationTableName(String table) {
        this.spec.setDetail(27, table);
    }

    public String getValidationTableName() {
        return this.spec.getDetail(27);
    }

    public void setValidationClassName(String className) {
        try {
            Class<?> validationClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            boolean isAssignable = ConnectionValidation.class.isAssignableFrom(validationClass);
            if (!isAssignable) {
                _logger.log(Level.SEVERE, "jdbc.set_custom_validation_class_name_failure", className);
                throw new ResourceException("The Custom validation class name isnot valid as it does not implement " + ConnectionValidation.class.getName());
            }
            this.spec.setDetail(36, className);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.set_custom_validation_class_name_failure", ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            _logger.log(Level.SEVERE, "jdbc.set_custom_validation_class_name_failure", ex.getMessage());
        }
    }

    public String getValidationClassName() {
        return this.spec.getDetail(36);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setTransactionIsolation(String trnIsolation) {
        this.spec.setDetail(28, trnIsolation);
    }

    public String getTransactionIsolation() {
        return this.spec.getDetail(28);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setGuaranteeIsolationLevel(String guaranteeIsolation) {
        this.spec.setDetail(29, guaranteeIsolation);
    }

    public String getGuaranteeIsolationLevel() {
        return this.spec.getDetail(29);
    }

    protected boolean isEqual(PasswordCredential pc, String user, String password) {
        String thisUser = pc == null ? null : pc.getUserName();
        char[] passwordArray = pc == null ? null : pc.getPassword();
        char[] tmpPasswordArray = password == null ? null : password.toCharArray();
        return this.isStringEqual(thisUser, user) && Arrays.equals(passwordArray, tmpPasswordArray);
    }

    private boolean isStringEqual(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    @ConfigProperty(type=String.class, defaultValue="localhost")
    public void setServerName(String serverName) {
        this.spec.setDetail(12, serverName);
    }

    public String getServerName() {
        return this.spec.getDetail(12);
    }

    @ConfigProperty(type=String.class, defaultValue="1527")
    public void setPortNumber(String portNumber) {
        this.spec.setDetail(10, portNumber);
    }

    public String getPortNumber() {
        return this.spec.getDetail(10);
    }

    public void setJdbc30DataSource(String booleanValue) {
        this.spec.setDetail(32, booleanValue);
    }

    public String getJdbc30DataSource() {
        return this.spec.getDetail(32);
    }

    @ConfigProperty(type=String.class, defaultValue="testdb")
    public void setDatabaseName(String databaseName) {
        this.spec.setDetail(6, databaseName);
    }

    public String getDatabaseName() {
        return this.spec.getDetail(6);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setDataSourceName(String dsn) {
        this.spec.setDetail(7, dsn);
    }

    public String getDataSourceName() {
        return this.spec.getDetail(7);
    }

    public void setStatementWrapping(String wrapping) {
        this.spec.setDetail(31, wrapping);
        this.computeStatementWrappingStatus();
    }

    public String getStatementWrapping() {
        return this.spec.getDetail(31);
    }

    public void setStatementCacheSize(String value) {
        this.spec.setDetail(34, value);
        this.detectStatementCachingSupport();
    }

    public String getStatementCacheSize() {
        return this.spec.getDetail(34);
    }

    public void setStatementLeakTimeoutInSeconds(String value) {
        this.spec.setDetail(43, value);
        this.detectStatementLeakSupport();
    }

    public String getStatementLeakTimeoutInSeconds() {
        return this.spec.getDetail(43);
    }

    public void setStatementLeakReclaim(String value) {
        this.spec.setDetail(44, value);
    }

    public String getStatementLeakReclaim() {
        return this.spec.getDetail(44);
    }

    public void setPoolMonitoringSubTreeRoot(String value) {
        this.spec.setDetail(40, value);
    }

    public String getPoolMonitoringSubTreeRoot() {
        return this.spec.getDetail(40);
    }

    public String getStatementCacheType() {
        return this.spec.getDetail(35);
    }

    public void setStatementCacheType(String statementCacheType) {
        this.spec.setDetail(35, statementCacheType);
    }

    public String getNumberOfTopQueriesToReport() {
        return this.spec.getDetail(41);
    }

    public void setNumberOfTopQueriesToReport(String numTopQueriesToReport) {
        this.spec.setDetail(41, numTopQueriesToReport);
    }

    public String getTimeToKeepQueriesInMinutes() {
        return this.spec.getDetail(42);
    }

    public void setTimeToKeepQueriesInMinutes(String timeToKeepQueries) {
        this.spec.setDetail(42, timeToKeepQueries);
    }

    public String getInitSql() {
        return this.spec.getDetail(39);
    }

    public void setInitSql(String initSql) {
        if (initSql != null && !initSql.equalsIgnoreCase("null") && !initSql.equals("")) {
            this.spec.setDetail(39, initSql);
        }
    }

    public void setStatementTimeout(String timeout) {
        this.spec.setDetail(30, timeout);
    }

    public String getStatementTimeout() {
        return this.spec.getDetail(30);
    }

    public String getSqlTraceListeners() {
        return this.spec.getDetail(38);
    }

    public void setSqlTraceListeners(String sqlTraceListeners) {
        if (sqlTraceListeners != null) {
            this.spec.setDetail(38, sqlTraceListeners);
            this.detectSqlTraceListeners();
        }
    }

    @ConfigProperty(type=String.class, defaultValue="Derby driver for datasource")
    public void setDescription(String desc) {
        this.spec.setDetail(8, desc);
    }

    public String getDescription() {
        return this.spec.getDetail(8);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setNetworkProtocol(String nwProtocol) {
        this.spec.setDetail(9, nwProtocol);
    }

    public String getNetworkProtocol() {
        return this.spec.getDetail(9);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setRoleName(String roleName) {
        this.spec.setDetail(11, roleName);
    }

    public String getRoleName() {
        return this.spec.getDetail(11);
    }

    @ConfigProperty(type=String.class, defaultValue="0")
    public void setLoginTimeOut(String loginTimeOut) {
        this.spec.setDetail(4, loginTimeOut);
    }

    public String getLoginTimeOut() {
        return this.spec.getDetail(4);
    }

    @ConfigProperty(type=String.class, defaultValue="#")
    public void setDelimiter(String delim) {
        this.spec.setDetail(21, delim);
    }

    public String getDelimiter() {
        return this.spec.getDetail(21);
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.spec.setDetail(33, escapeCharacter);
    }

    public String getEscapeCharacter() {
        return this.spec.getDetail(33);
    }

    @ConfigProperty(type=String.class, defaultValue="")
    public void setDriverProperties(String driverProps) {
        this.spec.setDetail(19, driverProps);
    }

    public String getDriverProperties() {
        return this.spec.getDetail(19);
    }

    protected ManagedConnection constructManagedConnection(PooledConnection pc, Connection sqlCon, PasswordCredential passCred, ManagedConnectionFactory mcf) throws ResourceException {
        return new ManagedConnection(pc, sqlCon, passCred, mcf, this.getPoolMonitoringSubTreeRoot(), this.statementCacheSize, this.statementCacheType, this.sqlTraceDelegator, this.statementLeakTimeout, this.statementLeakReclaim);
    }

    public Object getDataSource() throws ResourceException {
        if (this.dsObjBuilder == null) {
            this.dsObjBuilder = new DataSourceObjectBuilder(this.spec);
        }
        return this.dsObjBuilder.constructDataSourceObject();
    }

    private static int getStatementWrappingJVMOption() {
        int result = -1;
        String str = System.getProperty("com.sun.appserv.jdbc.wrapJdbcObjects");
        if ("true".equalsIgnoreCase(str)) {
            result = 1;
        } else if ("false".equalsIgnoreCase(str)) {
            result = 0;
        }
        return result;
    }

    protected void computeStatementWrappingStatus() {
        boolean poolProperty = false;
        String statementWrappingString = this.getStatementWrapping();
        if (statementWrappingString != null) {
            poolProperty = Boolean.valueOf(statementWrappingString);
        }
        this.statementWrapping = wrapStatement == 1 || wrapStatement == -1 && poolProperty;
    }

    public boolean isStatementWrappingEnabled() {
        return this.statementWrapping;
    }

    public JdbcObjectsFactory getJdbcObjectsFactory() {
        return this.jdbcObjectsFactory;
    }

    protected void logFine(String logMessage) {
        _logger.log(Level.FINE, logMessage);
    }

    public void mcfCreated() {
        String poolMonitoringSubTreeRoot = this.getPoolMonitoringSubTreeRoot();
        String sqlTraceListeners = this.getSqlTraceListeners();
        int sqlTraceCacheSize = 0;
        long timeToKeepQueries = 0L;
        if (sqlTraceListeners != null && !sqlTraceListeners.equals("null")) {
            sqlTraceCacheSize = this.getNumberOfTopQueriesToReport() != null && !this.getNumberOfTopQueriesToReport().equals("null") ? Integer.parseInt(this.getNumberOfTopQueriesToReport()) : 10;
            timeToKeepQueries = this.getTimeToKeepQueriesInMinutes() != null && !this.getTimeToKeepQueriesInMinutes().equals("null") ? (long)Integer.parseInt(this.getTimeToKeepQueriesInMinutes()) : 5L;
        }
        _logger.finest("MCF Created");
        if (this.statementCacheSize > 0 || sqlTraceListeners != null && !sqlTraceListeners.equals("null") || this.statementLeakTimeout > 0L) {
            this.jdbcStatsProvider = new JdbcStatsProvider(poolMonitoringSubTreeRoot, sqlTraceCacheSize, timeToKeepQueries);
            StatsProviderManager.register((String)"jdbc-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)poolMonitoringSubTreeRoot, (Object)this.jdbcStatsProvider);
            if (this.jdbcStatsProvider.getSqlTraceCache() != null) {
                _logger.finest("Scheduling timer task for sql trace caching");
                Timer timer = ((ResourceAdapter)this.ra).getTimer();
                this.jdbcStatsProvider.getSqlTraceCache().scheduleTimerTask(timer);
            }
            _logger.finest("Registered JDBCRA Stats Provider");
        }
    }

    public void mcfDestroyed() {
        _logger.finest("MCF Destroyed");
        if (this.jdbcStatsProvider != null) {
            if (this.jdbcStatsProvider.getSqlTraceCache() != null) {
                _logger.finest("Canceling timer task for sql trace caching");
                this.jdbcStatsProvider.getSqlTraceCache().cancelTimerTask();
            }
            StatsProviderManager.unregister((Object)this.jdbcStatsProvider);
            this.jdbcStatsProvider = null;
            _logger.finest("Unregistered JDBCRA Stats Provider");
        }
    }

    private void detectStatementLeakSupport() {
        String stmtLeakTimeout = this.getStatementLeakTimeoutInSeconds();
        String stmtLeakReclaim = this.getStatementLeakReclaim();
        if (stmtLeakTimeout != null) {
            this.statementLeakTimeout = (long)Integer.valueOf(stmtLeakTimeout).intValue() * 1000L;
            this.statementLeakReclaim = Boolean.valueOf(stmtLeakReclaim);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "StatementLeakTimeout in seconds: " + this.statementLeakTimeout + " & StatementLeakReclaim: " + this.statementLeakReclaim + " for pool : " + this.getPoolMonitoringSubTreeRoot());
            }
        }
    }

    static {
        wrapStatement = ManagedConnectionFactory.getStatementWrappingJVMOption();
    }
}

