/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base.datastructure;

import com.sun.gjc.monitoring.StatementCacheProbeProvider;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.CacheObjectKey;
import com.sun.gjc.spi.base.PreparedStatementWrapper;
import com.sun.gjc.spi.base.datastructure.Cache;
import com.sun.logging.LogDomains;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LRUCacheImpl
implements Cache {
    private Map<CacheObjectKey, CacheEntry> list;
    private int maxSize;
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    private StatementCacheProbeProvider probeProvider = null;
    private String poolName;

    public LRUCacheImpl(String poolName, int maxSize) {
        this.maxSize = maxSize;
        this.poolName = poolName;
        this.list = new LinkedHashMap<CacheObjectKey, CacheEntry>();
        try {
            if (this.probeProvider == null) {
                this.probeProvider = new StatementCacheProbeProvider();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object checkAndUpdateCache(CacheObjectKey key) {
        Object result = null;
        CacheEntry entry = this.list.get(key);
        if (entry != null) {
            result = entry.entryObj;
            _logger.finest("Cache Hit");
            this.probeProvider.statementCacheHitEvent(this.poolName);
        } else {
            _logger.finest("Cache Miss");
            this.probeProvider.statementCacheMissEvent(this.poolName);
        }
        return result;
    }

    @Override
    public void addToCache(CacheObjectKey key, Object o, boolean force) {
        if (force || !this.list.containsKey(key)) {
            if (this.list.size() >= this.maxSize) {
                this.purge();
            }
            CacheEntry entry = new CacheEntry(key, o);
            this.list.put(key, entry);
        }
    }

    @Override
    public void clearCache() {
        _logger.fine("clearing objects in cache");
        this.list.clear();
    }

    @Override
    public void flushCache() {
        while (this.list.size() != 0) {
            this.purge();
        }
    }

    @Override
    public void purge() {
        block2: {
            Iterator<CacheObjectKey> keyIterator = this.list.keySet().iterator();
            if (!keyIterator.hasNext()) break block2;
            CacheObjectKey key = keyIterator.next();
            CacheEntry entry = this.list.get(key);
            try {
                PreparedStatementWrapper ps = (PreparedStatementWrapper)entry.entryObj;
                ps.setCached(false);
                ps.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            keyIterator.remove();
        }
    }

    @Override
    public void purge(Object obj) {
        block4: {
            PreparedStatementWrapper tmpPS = (PreparedStatementWrapper)obj;
            Iterator<CacheObjectKey> keyIterator = this.list.keySet().iterator();
            if (!keyIterator.hasNext()) break block4;
            CacheObjectKey key = keyIterator.next();
            CacheEntry entry = this.list.get(key);
            try {
                PreparedStatementWrapper ps = (PreparedStatementWrapper)entry.entryObj;
                if (ps.equals(tmpPS)) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Purging an entry from cache");
                    }
                    ps.setCached(false);
                    ps.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            keyIterator.remove();
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public Set getObjects() {
        HashSet<Object> set = new HashSet<Object>();
        for (CacheEntry entry : this.list.values()) {
            set.add(entry.entryObj);
        }
        return set;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public class CacheEntry {
        private CacheObjectKey key;
        private Object entryObj;

        public CacheEntry(CacheObjectKey key, Object o) {
            this.key = key;
            this.entryObj = o;
        }
    }
}

