/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="jdbc-connection-pool")
@I18n(value="add.resources")
public class JDBCConnectionPoolManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCConnectionPoolManager.class);
    private String datasourceclassname = null;
    private String restype = null;
    private String steadypoolsize = "8";
    private String maxpoolsize = "32";
    private String maxwait = "60000";
    private String poolresize = "2";
    private String idletimeout = "300";
    private String initsql = null;
    private String isolationlevel = null;
    private String isisolationguaranteed = Boolean.TRUE.toString();
    private String isconnectvalidatereq = Boolean.FALSE.toString();
    private String validationmethod = "table";
    private String validationtable = null;
    private String failconnection = Boolean.FALSE.toString();
    private String allownoncomponentcallers = Boolean.FALSE.toString();
    private String nontransactionalconnections = Boolean.FALSE.toString();
    private String validateAtmostOncePeriod = "0";
    private String connectionLeakTimeout = "0";
    private String connectionLeakReclaim = Boolean.FALSE.toString();
    private String connectionCreationRetryAttempts = "0";
    private String connectionCreationRetryInterval = "10";
    private String driverclassname = null;
    private String sqltracelisteners = null;
    private String statementTimeout = "-1";
    private String statementcachesize = "0";
    private String lazyConnectionEnlistment = Boolean.FALSE.toString();
    private String lazyConnectionAssociation = Boolean.FALSE.toString();
    private String associateWithThread = Boolean.FALSE.toString();
    private String matchConnections = Boolean.FALSE.toString();
    private String maxConnectionUsageCount = "0";
    private String ping = Boolean.FALSE.toString();
    private String pooling = Boolean.TRUE.toString();
    private String validationclassname = null;
    private String wrapJDBCObjects = Boolean.TRUE.toString();
    private String description = null;
    private String jdbcconnectionpoolid = null;

    public String getResourceType() {
        return "jdbc-connection-pool";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target) throws Exception {
        this.setAttributes(attributes);
        ResourceStatus validationStatus = this.isValid(resources);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return JDBCConnectionPoolManager.this.createResource(param, properties);
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} create failed: {1}", new Object[]{this.jdbcconnectionpoolid, tfe.getMessage()});
            return new ResourceStatus(1, msg);
        }
        String msg = localStrings.getLocalString("create.jdbc.connection.pool.success", "JDBC connection pool {0} created successfully", new Object[]{this.jdbcconnectionpoolid});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.jdbcconnectionpoolid == null) {
            String msg = localStrings.getLocalString("add.resources.noJdbcConnectionPoolId", "No pool name defined for JDBC Connection pool.");
            return new ResourceStatus(1, msg);
        }
        for (ResourcePool pool : resources.getResources(ResourcePool.class)) {
            if (!pool.getName().equals(this.jdbcconnectionpoolid)) continue;
            String msg = localStrings.getLocalString("create.jdbc.connection.pool.duplicate", "A resource {0} already exists.", new Object[]{this.jdbcconnectionpoolid});
            return new ResourceStatus(1, msg, true);
        }
        if (this.validationmethod.equals("table") && this.isconnectvalidatereq.equals(Boolean.TRUE.toString()) && this.validationtable == null) {
            String msg = localStrings.getLocalString("create.jdbc.connection.pool.validationtable_required", "--validationtable is required if --validationmethod=table and --isconnectvalidatereq=true.");
            return new ResourceStatus(1, msg, true);
        }
        return status;
    }

    private JdbcConnectionPool createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcConnectionPool newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private JdbcConnectionPool createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcConnectionPool newResource = (JdbcConnectionPool)param.createChild(JdbcConnectionPool.class);
        newResource.setWrapJdbcObjects(this.wrapJDBCObjects);
        if (this.validationtable != null) {
            newResource.setValidationTableName(this.validationtable);
        }
        newResource.setValidateAtmostOncePeriodInSeconds(this.validateAtmostOncePeriod);
        if (this.isolationlevel != null) {
            newResource.setTransactionIsolationLevel(this.isolationlevel);
        }
        newResource.setSteadyPoolSize(this.steadypoolsize);
        newResource.setStatementTimeoutInSeconds(this.statementTimeout);
        if (this.restype != null) {
            newResource.setResType(this.restype);
        }
        newResource.setPoolResizeQuantity(this.poolresize);
        newResource.setNonTransactionalConnections(this.nontransactionalconnections);
        newResource.setMaxWaitTimeInMillis(this.maxwait);
        newResource.setMaxPoolSize(this.maxpoolsize);
        newResource.setMaxConnectionUsageCount(this.maxConnectionUsageCount);
        newResource.setMatchConnections(this.matchConnections);
        newResource.setLazyConnectionEnlistment(this.lazyConnectionEnlistment);
        newResource.setLazyConnectionAssociation(this.lazyConnectionAssociation);
        newResource.setIsIsolationLevelGuaranteed(this.isisolationguaranteed);
        newResource.setIsConnectionValidationRequired(this.isconnectvalidatereq);
        newResource.setIdleTimeoutInSeconds(this.idletimeout);
        newResource.setFailAllConnections(this.failconnection);
        if (this.datasourceclassname != null) {
            newResource.setDatasourceClassname(this.datasourceclassname);
        }
        newResource.setConnectionValidationMethod(this.validationmethod);
        newResource.setConnectionLeakTimeoutInSeconds(this.connectionLeakTimeout);
        newResource.setConnectionLeakReclaim(this.connectionLeakReclaim);
        newResource.setConnectionCreationRetryIntervalInSeconds(this.connectionCreationRetryInterval);
        newResource.setConnectionCreationRetryAttempts(this.connectionCreationRetryAttempts);
        newResource.setAssociateWithThread(this.associateWithThread);
        newResource.setAllowNonComponentCallers(this.allownoncomponentcallers);
        newResource.setStatementCacheSize(this.statementcachesize);
        if (this.validationclassname != null) {
            newResource.setValidationClassname(this.validationclassname);
        }
        newResource.setInitSql(this.initsql);
        if (this.sqltracelisteners != null) {
            newResource.setSqlTraceListeners(this.sqltracelisteners);
        }
        newResource.setPooling(this.pooling);
        newResource.setPing(this.ping);
        if (this.driverclassname != null) {
            newResource.setDriverClassname(this.driverclassname);
        }
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setName(this.jdbcconnectionpoolid);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public void setAttributes(HashMap attrList) {
        this.datasourceclassname = (String)attrList.get("datasource-classname");
        this.restype = (String)attrList.get("res-type");
        this.steadypoolsize = (String)attrList.get("steady-pool-size");
        this.maxpoolsize = (String)attrList.get("max-pool-size");
        this.maxwait = (String)attrList.get("max-wait-time-in-millis");
        this.poolresize = (String)attrList.get("pool-resize-quantity");
        this.idletimeout = (String)attrList.get("idle-timeout-in-seconds");
        this.isolationlevel = (String)attrList.get("transaction-isolation-level");
        this.isisolationguaranteed = (String)attrList.get("is-isolation-level-guaranteed");
        this.isconnectvalidatereq = (String)attrList.get("is-connection-validation-required");
        this.validationmethod = (String)attrList.get("connection-validation-method");
        this.validationtable = (String)attrList.get("validation-table-name");
        this.failconnection = (String)attrList.get("fail-all-connections");
        this.allownoncomponentcallers = (String)attrList.get("allow-non-component-callers");
        this.nontransactionalconnections = (String)attrList.get("non-transactional-connections");
        this.validateAtmostOncePeriod = (String)attrList.get("validate-atmost-once-period-in-seconds");
        this.connectionLeakTimeout = (String)attrList.get("connection-leak-timeout-in-seconds");
        this.connectionLeakReclaim = (String)attrList.get("connection-leak-reclaim");
        this.connectionCreationRetryAttempts = (String)attrList.get("connection-creation-retry-attempts");
        this.connectionCreationRetryInterval = (String)attrList.get("connection-creation-retry-interval-in-seconds");
        this.statementTimeout = (String)attrList.get("statement-timeout-in-seconds");
        this.lazyConnectionEnlistment = (String)attrList.get("lazy-connection-enlistment");
        this.lazyConnectionAssociation = (String)attrList.get("lazy-connection-association");
        this.associateWithThread = (String)attrList.get("associate-with-thread");
        this.matchConnections = (String)attrList.get("match-connections");
        this.maxConnectionUsageCount = (String)attrList.get("max-connection-usage-count");
        this.wrapJDBCObjects = (String)attrList.get("wrap-jdbc-objects");
        this.description = (String)attrList.get(DESCRIPTION);
        this.jdbcconnectionpoolid = (String)attrList.get("name");
        this.statementcachesize = (String)attrList.get("statement-cache-size");
        this.validationclassname = (String)attrList.get("validation-classname");
        this.initsql = (String)attrList.get("init-sql");
        this.sqltracelisteners = (String)attrList.get("sql-trace-listeners");
        this.pooling = (String)attrList.get("pooling");
        this.ping = (String)attrList.get("ping");
        this.driverclassname = (String)attrList.get("driver-classname");
    }

    public ResourceStatus delete(Server[] servers, final Resources resources, String cascade, final String poolName) throws Exception {
        if (poolName == null) {
            String msg = localStrings.getLocalString("jdbcConnPool.resource.noJndiName", "No id defined for JDBC Connection pool.");
            return new ResourceStatus(1, msg);
        }
        if (!this.isResourceExists(resources, poolName)) {
            String msg = localStrings.getLocalString("delete.jdbc.connection.pool.notfound", "A JDBC connection pool named {0} does not exist.", new Object[]{poolName});
            return new ResourceStatus(1, msg);
        }
        try {
            Object obj = this.deleteAssociatedResources(servers, resources, Boolean.parseBoolean(cascade), poolName);
            if (obj instanceof Integer && (Integer)obj == 1) {
                String msg = localStrings.getLocalString("delete.jdbc.connection.pool.pool_in_use", "JDBC Connection pool {0} delete failed ", new Object[]{poolName});
                return new ResourceStatus(1, msg);
            }
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcConnectionPool cp = (JdbcConnectionPool)resources.getResourceByName(JdbcConnectionPool.class, poolName);
                    return param.getResources().remove(cp);
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("delete.jdbc.connection.pool.notfound", "A JDBC connection pool named {0} does not exist.", new Object[]{poolName});
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = tfe.getMessage() != null ? tfe.getMessage() : localStrings.getLocalString("jdbcConnPool.resource.deletionFailed", "JDBC Connection pool {0} delete failed ", new Object[]{poolName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbcConnPool.resource.deleteSuccess", "JDBC Connection pool {0} deleted successfully", new Object[]{poolName});
        return new ResourceStatus(0, msg);
    }

    private boolean isResourceExists(Resources resources, String poolName) {
        return resources.getResourceByName(JdbcConnectionPool.class, poolName) != null;
    }

    private Object deleteAssociatedResources(final Server[] servers, Resources resources, final boolean cascade, final String poolName) throws TransactionFailure {
        return ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

            public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                Resource res = null;
                for (Resource resource : param.getResources()) {
                    if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getPoolName().equals(poolName)) continue;
                    if (cascade) {
                        JDBCConnectionPoolManager.this.deleteResourceRefs(servers, ((JdbcResource)resource).getJndiName());
                        res = resource;
                        break;
                    }
                    return 1;
                }
                if (res != null) {
                    param.getResources().remove(res);
                }
                return null;
            }
        }, (ConfigBeanProxy)resources);
    }

    private void deleteResourceRefs(Server[] servers, String refName) throws TransactionFailure {
        for (Server server : servers) {
            server.deleteResourceRef(refName);
        }
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes);
        ResourceStatus status = null;
        status = !validate ? new ResourceStatus(0, "") : this.isValid(resources);
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }
}

