/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base.datastructure;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.datastructure.Cache;
import com.sun.gjc.spi.base.datastructure.LRUCacheImpl;
import com.sun.gjc.spi.base.datastructure.SynchronizedCache;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.glassfish.resource.common.PoolInfo;

public class CacheFactory {
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    protected static final StringManager localStrings = StringManager.getManager(DataSourceObjectBuilder.class);

    public static Cache getDataStructure(PoolInfo poolInfo, String className, int maxSize) throws ResourceException {
        Cache stmtCacheStructure;
        if (className == null || className.trim().equals("")) {
            CacheFactory.debug("Initializing LRU Cache Implementation");
            stmtCacheStructure = new LRUCacheImpl(poolInfo, maxSize);
        } else {
            stmtCacheStructure = CacheFactory.initCustomCacheStructurePrivileged(className, maxSize);
        }
        if (!stmtCacheStructure.isSynchronized()) {
            return new SynchronizedCache(stmtCacheStructure);
        }
        return stmtCacheStructure;
    }

    private static Cache initCustomCacheStructurePrivileged(final String className, final int cacheSize) throws ResourceException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cache result = null;
                try {
                    result = CacheFactory.initializeCacheStructure(className, cacheSize);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, localStrings.getString("jdbc.statement-cache.datastructure.init.failure", (Object)className));
                    _logger.log(Level.WARNING, localStrings.getString("jdbc.statement-cache.datastructure.init.failure.exception", (Object)e));
                }
                return result;
            }
        });
        if (result != null) {
            return (Cache)result;
        }
        throw new ResourceException("Unable to initalize custom DataStructure for Statement Cahe : " + className);
    }

    private static Cache initializeCacheStructure(String className, int maxSize) throws Exception {
        Object[] constructorParameters = new Object[]{maxSize};
        Class<?> class1 = Class.forName(className);
        Constructor<?> constructor = class1.getConstructor(class1, Integer.class);
        Cache ds = (Cache)constructor.newInstance(constructorParameters);
        return ds;
    }

    private static void debug(String debugStatement) {
        _logger.log(Level.FINE, debugStatement);
    }
}

