/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.logging.LogDomains;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

@Connector(description={"Resource adapter wrapping implementation of driver"}, displayName={"Resource Adapter"}, vendorName="Sun Microsystems", eisType="Database", version="1.0", authMechanisms={@AuthenticationMechanism(authMechanism="BasicPassword", credentialInterface=AuthenticationMechanism.CredentialInterface.PasswordCredential)})
public class ResourceAdapter
implements javax.resource.spi.ResourceAdapter {
    private static ResourceAdapter ra;
    private BootstrapContext bootstrapContext;
    private Timer timer;
    private static Logger _logger;

    public ResourceAdapter() {
        ra = this;
    }

    public static ResourceAdapter getInstance() {
        if (ra == null) {
            throw new IllegalStateException("ResourceAdapter not initialized");
        }
        return ra;
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws NotSupportedException {
        throw new NotSupportedException("This method is not supported for this JDBC connector");
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws NotSupportedException {
        throw new NotSupportedException("This method is not supported for this JDBC connector");
    }

    public void start(BootstrapContext ctx) {
        this.bootstrapContext = ctx;
    }

    public void stop() {
        _logger.finest("Cancelling the timer");
        if (this.timer != null) {
            this.timer.purge();
            this.timer.cancel();
        }
    }

    public Timer getTimer() {
        if (this.bootstrapContext != null && this.timer == null) {
            _logger.finest("Creating the timer");
            try {
                this.timer = this.bootstrapContext.createTimer();
            }
            catch (UnavailableException ex) {
                _logger.log(Level.SEVERE, "jdbc-ra.timer_creation_exception", ex.getMessage());
            }
        }
        return this.timer;
    }

    static {
        _logger = LogDomains.getLogger(ResourceAdapter.class, (String)"javax.enterprise.resource.resourceadapter");
    }
}

