/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.DataSource;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

@ConnectionDefinition(connectionFactory=javax.sql.DataSource.class, connectionFactoryImpl=DataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class CPManagedConnectionFactory
extends ManagedConnectionFactory {
    private transient ConnectionPoolDataSource cpDataSourceObj;
    private static Logger _logger = LogDomains.getLogger(CPManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    @Override
    public ConnectionPoolDataSource getDataSource() throws ResourceException {
        if (this.cpDataSourceObj == null) {
            try {
                this.cpDataSourceObj = (ConnectionPoolDataSource)super.getDataSource();
            }
            catch (ClassCastException cce) {
                _logger.log(Level.SEVERE, "jdbc.exc_cce_CP", cce);
                throw new ResourceException(cce.getMessage());
            }
        }
        return this.cpDataSourceObj;
    }

    @Override
    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        ConnectionPoolDataSource dataSource = this.getDataSource();
        PooledConnection cpConn = null;
        try {
            cpConn = this.isEqual(pc, this.getUser(), this.getPassword()) ? dataSource.getPooledConnection() : dataSource.getPooledConnection(pc.getUserName(), new String(pc.getPassword()));
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.exc_create_ds_conn", sqle);
            }
            StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);
            String msg = sm.getString("jdbc.cannot_allocate_connection", (Object)sqle.getMessage());
            ResourceAllocationException rae = new ResourceAllocationException(msg, (Throwable)sqle);
            throw rae;
        }
        ManagedConnection mc = this.constructManagedConnection(cpConn, null, pc, this);
        mc.initializeConnectionType(1);
        this.validateAndSetIsolation(mc);
        return mc;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof CPManagedConnectionFactory) {
            CPManagedConnectionFactory otherMCF = (CPManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    public void setMaxStatements(String maxStmts) {
        this.spec.setDetail(13, maxStmts);
    }

    public String getMaxStatements() {
        return this.spec.getDetail(13);
    }

    public void setInitialPoolSize(String initPoolSz) {
        this.spec.setDetail(14, initPoolSz);
    }

    public String getInitialPoolSize() {
        return this.spec.getDetail(14);
    }

    public void setMinPoolSize(String minPoolSz) {
        this.spec.setDetail(15, minPoolSz);
    }

    public String getMinPoolSize() {
        return this.spec.getDetail(15);
    }

    public void setMaxPoolSize(String maxPoolSz) {
        this.spec.setDetail(16, maxPoolSz);
    }

    public String getMaxPoolSize() {
        return this.spec.getDetail(16);
    }

    public void setMaxIdleTime(String maxIdleTime) {
        this.spec.setDetail(17, maxIdleTime);
    }

    public String getMaxIdleTime() {
        return this.spec.getDetail(17);
    }

    public void setPropertyCycle(String propCycle) {
        this.spec.setDetail(18, propCycle);
    }

    public String getPropertyCycle() {
        return this.spec.getDetail(18);
    }
}

