/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnection;
import com.sun.logging.LogDomains;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransactionException;

public class LocalTransaction
implements javax.resource.spi.LocalTransaction {
    private ManagedConnection mc;
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnection.class, (String)"javax.enterprise.resource.resourceadapter");

    public LocalTransaction(ManagedConnection mc) {
        this.mc = mc;
    }

    public void begin() throws ResourceException {
        this.mc.transactionStarted();
        try {
            this.mc.getActualConnection().setAutoCommit(false);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during begin() : " + sqle);
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public void commit() throws ResourceException {
        try {
            this.mc.getActualConnection().commit();
            this.mc.getActualConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during commit() : " + sqle);
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            this.mc.transactionCompleted();
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.mc.getActualConnection().rollback();
            this.mc.getActualConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during rollback() : " + sqle);
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            this.mc.transactionCompleted();
        }
    }
}

