/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverLoader {
    private static Logger logger = Logger.getLogger(JDBCDriverLoader.class.getPackage().getName());
    private static final String DRIVER_INTERFACE_NAME = "java.sql.Driver";
    private static final String META_INF_SERVICES_DRIVER_FILE = "META-INF/services/java.sql.Driver";
    private static final String DBVENDOR_MAPPINGS_ROOT = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "databases" + File.separator + "dbvendormapping" + File.separator;
    private static final String DS_PROPERTIES = "ds.properties";
    private static final String CPDS_PROPERTIES = "cpds.properties";
    private static final String XADS_PROPERTIES = "xads.properties";
    private static final String DRIVER_PROPERTIES = "driver.properties";
    private static final String VENDOR_PROPERTIES = "dbvendor.properties";
    private static final Locale locale = Locale.getDefault();
    public static final Map<String, Map<String, String>> dbVendorMappings = new HashMap<String, Map<String, String>>();
    private ClassLoader cl;

    public JDBCDriverLoader(ClassLoader cl) {
        this.cl = cl;
    }

    private static void loadMappings() {
        dbVendorMappings.put("javax.sql.DataSource", JDBCDriverLoader.loadProperties(DS_PROPERTIES));
        dbVendorMappings.put("javax.sql.ConnectionPoolDataSource", JDBCDriverLoader.loadProperties(CPDS_PROPERTIES));
        dbVendorMappings.put("javax.sql.XADataSource", JDBCDriverLoader.loadProperties(XADS_PROPERTIES));
        dbVendorMappings.put(DRIVER_INTERFACE_NAME, JDBCDriverLoader.loadProperties(DRIVER_PROPERTIES));
        dbVendorMappings.put("dbvendor", JDBCDriverLoader.loadProperties(VENDOR_PROPERTIES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String type) {
        Properties fileProperties = new Properties();
        String fileName = DBVENDOR_MAPPINGS_ROOT + type;
        File mappingFile = new File(fileName);
        if (mappingFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(mappingFile);
                try {
                    fileProperties.load(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException ioe) {
                logger.fine("IO Exception while loading properties file [ " + mappingFile.getAbsolutePath() + " ] : " + ioe);
            }
        } else {
            logger.warning("File not found : " + mappingFile.getAbsolutePath());
        }
        return fileProperties;
    }

    private Set<String> getDatabaseVendorNames() {
        Map<String, String> vendors = dbVendorMappings.get("dbvendor");
        return vendors.keySet();
    }

    private String getDBVendor(String className, String type) {
        String dbVendor = null;
        Map<String, String> map = dbVendorMappings.get(type);
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!entry.getValue().equalsIgnoreCase(className)) continue;
            dbVendor = entry.getKey();
            break;
        }
        return dbVendor;
    }

    private String getImplClassNameFromMapping(String dbVendor, String resType) {
        Map<String, String> fileProperties = dbVendorMappings.get(resType);
        if (fileProperties == null) {
            throw new IllegalStateException("Unknown resource type [ " + resType + " ]");
        }
        return fileProperties.get(dbVendor.toUpperCase(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadDriverInformation(File f) {
        JarFile jarFile = null;
        Properties properties = new Properties();
        try {
            jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                Properties properties2;
                String dbVendor;
                String implClass;
                ZipEntry zipEntry = e.nextElement();
                if (zipEntry == null) continue;
                String entry = zipEntry.getName();
                if (META_INF_SERVICES_DRIVER_FILE.equals(entry)) {
                    InputStream metaInf = jarFile.getInputStream(zipEntry);
                    implClass = this.processMetaInfServicesDriverFile(metaInf);
                    if (implClass != null && this.isLoaded(implClass, DRIVER_INTERFACE_NAME, this.cl)) {
                        String vendor = this.getVendorFromManifest(f);
                        Set<String> dbVendorNames = this.getDatabaseVendorNames();
                        if (vendor != null && dbVendorNames.contains(vendor)) {
                            String dsClassName = this.getImplClassNameFromMapping(vendor, "javax.sql.DataSource");
                            String cpdsClassName = this.getImplClassNameFromMapping(vendor, "javax.sql.ConnectionPoolDataSource");
                            String xadsClassName = this.getImplClassNameFromMapping(vendor, "javax.sql.XADataSource");
                            String driverClassName = implClass;
                            properties.put("javax.sql.DataSource", dsClassName);
                            properties.put("javax.sql.ConnectionPoolDataSource", cpdsClassName);
                            properties.put("javax.sql.XADataSource", xadsClassName);
                            properties.put(DRIVER_INTERFACE_NAME, driverClassName);
                            Properties properties3 = properties;
                            return properties3;
                        }
                        if (vendor != null) {
                            Set<String> xadsClasses;
                            Set<String> cpdsClasses;
                            Set<String> dsClasses = this.getImplClassesByIteration(f, "javax.sql.DataSource", vendor, this.cl);
                            if (dsClasses.size() == 1) {
                                properties.put("javax.sql.DataSource", dsClasses.toArray()[0]);
                            }
                            if ((cpdsClasses = this.getImplClassesByIteration(f, "javax.sql.ConnectionPoolDataSource", vendor, this.cl)).size() == 1) {
                                properties.put("javax.sql.ConnectionPoolDataSource", cpdsClasses.toArray()[0]);
                            }
                            if ((xadsClasses = this.getImplClassesByIteration(f, "javax.sql.XADataSource", vendor, this.cl)).size() == 1) {
                                properties.put("javax.sql.XADataSource", xadsClasses.toArray()[0]);
                            }
                            properties.put(DRIVER_INTERFACE_NAME, implClass);
                            Properties properties4 = properties;
                            return properties4;
                        }
                    }
                    logger.finest("Driver loader : implClass = " + implClass);
                }
                if (!entry.endsWith(".class")) continue;
                if (entry.toUpperCase(locale).contains("DATASOURCE")) {
                    implClass = this.getClassName(entry);
                    if (implClass == null) continue;
                    if (this.isLoaded(implClass, "javax.sql.XADataSource", this.cl)) {
                        dbVendor = this.getDBVendor(implClass, "javax.sql.XADataSource");
                        if (dbVendor != null) {
                            this.detectImplClasses(properties, dbVendor);
                            properties2 = properties;
                            return properties2;
                        }
                        properties.put("javax.sql.XADataSource", implClass);
                        continue;
                    }
                    if (this.isLoaded(implClass, "javax.sql.ConnectionPoolDataSource", this.cl)) {
                        dbVendor = this.getDBVendor(implClass, "javax.sql.ConnectionPoolDataSource");
                        if (dbVendor != null) {
                            this.detectImplClasses(properties, dbVendor);
                            properties2 = properties;
                            return properties2;
                        }
                        properties.put("javax.sql.ConnectionPoolDataSource", implClass);
                        continue;
                    }
                    if (!this.isLoaded(implClass, "javax.sql.DataSource", this.cl)) continue;
                    dbVendor = this.getDBVendor(implClass, "javax.sql.DataSource");
                    if (dbVendor != null) {
                        this.detectImplClasses(properties, dbVendor);
                        properties2 = properties;
                        return properties2;
                    }
                    properties.put("javax.sql.DataSource", implClass);
                    continue;
                }
                if (!entry.toUpperCase(locale).contains("DRIVER") || (implClass = this.getClassName(entry)) == null || !this.isLoaded(implClass, DRIVER_INTERFACE_NAME, this.cl)) continue;
                dbVendor = this.getDBVendor(implClass, DRIVER_INTERFACE_NAME);
                if (dbVendor != null) {
                    this.detectImplClasses(properties, dbVendor);
                    properties2 = properties;
                    return properties2;
                }
                properties.put(DRIVER_INTERFACE_NAME, implClass);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while getting Jdbc driver classnames ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        if (properties.get(DRIVER_INTERFACE_NAME) != null) {
            return properties;
        }
        throw new RuntimeException("Unable to introspect jar [ " + f.getName() + " ] for Driver Class, " + "no implementation for java.sql.Driver is found");
    }

    private void detectImplClasses(Properties properties, String dbVendor) {
        String xads = this.getImplClassNameFromMapping(dbVendor, "javax.sql.XADataSource");
        String cpds = this.getImplClassNameFromMapping(dbVendor, "javax.sql.ConnectionPoolDataSource");
        String ds = this.getImplClassNameFromMapping(dbVendor, "javax.sql.DataSource");
        String driver = this.getImplClassNameFromMapping(dbVendor, DRIVER_INTERFACE_NAME);
        properties.put("javax.sql.XADataSource", xads);
        properties.put("javax.sql.ConnectionPoolDataSource", cpds);
        properties.put("javax.sql.DataSource", ds);
        properties.put(DRIVER_INTERFACE_NAME, driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getImplClassesByIteration(File f, String resType, String dbVendor, ClassLoader cl) {
        TreeSet<String> implClassNames = new TreeSet<String>();
        String implClass = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                if (zipEntry == null) continue;
                String entry = zipEntry.getName();
                if (DRIVER_INTERFACE_NAME.equals(resType) && META_INF_SERVICES_DRIVER_FILE.equals(entry)) {
                    InputStream inputStream = jarFile.getInputStream(zipEntry);
                    implClass = this.processMetaInfServicesDriverFile(inputStream);
                    if (implClass != null && this.isLoaded(implClass, resType, cl) && this.isVendorSpecific(f, dbVendor, implClass)) {
                        implClassNames.add(implClass);
                    }
                    logger.finest("Driver loader : implClass = " + implClass);
                }
                if (!entry.endsWith(".class") || entry.toUpperCase(locale).indexOf("DATASOURCE") == -1 && entry.toUpperCase(locale).indexOf("DRIVER") == -1 || (implClass = this.getClassName(entry)) == null || !this.isLoaded(implClass, resType, cl) || !this.isVendorSpecific(f, dbVendor, implClass)) continue;
                implClassNames.add(implClass);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while getting Jdbc driver classnames ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        return implClassNames;
    }

    private boolean isNotAbstract(Class cls) {
        int modifier = cls.getModifiers();
        return !Modifier.isAbstract(modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processMetaInfServicesDriverFile(InputStream inputStream) {
        String driverClassName = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            reader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                driverClassName = line;
            }
        }
        catch (IOException ioex) {
            logger.finest("DriverLoader : exception while processing META-INF directory for DriverClassName " + ioex);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Error while closing file handle after reading META-INF file : ", ex);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Error while closing file handle after reading META-INF file : ", ex);
            }
        }
        return driverClassName;
    }

    private boolean isLoaded(String classname, String resType, ClassLoader loader) {
        Class<?> cls = null;
        try {
            cls = loader.loadClass(classname);
        }
        catch (Throwable t) {
            cls = null;
        }
        return this.isResType(cls, resType);
    }

    private boolean isResType(Class cls, String resType) {
        boolean isResType = false;
        if (cls != null) {
            if ("javax.sql.DataSource".equals(resType)) {
                if (DataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if ("javax.sql.ConnectionPoolDataSource".equals(resType)) {
                if (ConnectionPoolDataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if ("javax.sql.XADataSource".equals(resType)) {
                if (XADataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if (DRIVER_INTERFACE_NAME.equals(resType) && Driver.class.isAssignableFrom(cls)) {
                isResType = this.isNotAbstract(cls);
            }
        }
        return isResType;
    }

    private String getClassName(String classname) {
        classname = classname.replaceAll("/", ".");
        classname = classname.substring(0, classname.lastIndexOf(".class"));
        return classname;
    }

    private boolean isVendorSpecific(File f, String dbVendor, String className) {
        boolean isVendorSpecific = false;
        String vendor = this.getVendorFromManifest(f);
        if (vendor == null) {
            if (this.isVendorSpecific(dbVendor, className)) {
                isVendorSpecific = true;
            }
        } else if (vendor.equalsIgnoreCase(dbVendor) || vendor.toUpperCase(locale).indexOf(dbVendor.toUpperCase()) != -1) {
            isVendorSpecific = true;
        }
        return isVendorSpecific;
    }

    private boolean isVendorSpecific(String dbVendor, String className) {
        return className.toUpperCase(locale).indexOf(dbVendor.toUpperCase()) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVendorFromManifest(File f) {
        String vendor = null;
        JarFile jarFile = null;
        try {
            Attributes mainAttributes;
            jarFile = new JarFile(f);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (mainAttributes = manifest.getMainAttributes()) != null && (vendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR.toString())) == null) {
                vendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString());
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while reading manifest file : ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        return vendor;
    }

    static {
        JDBCDriverLoader.loadMappings();
    }
}

