/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.PHashMapMMF;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TxnAckList {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String BASENAME = "txnack";
    private PHashMap tidMap = null;
    private boolean useMemoryMappedFile = true;
    private HashMap emptyHashMap = new HashMap();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];
    private File backingFile = null;
    private LoadException loadException = null;

    TxnAckList(File file, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = this.config.getSizeProperty("imq.persist.file.transaction.file.size", 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.useMemoryMappedFile = this.config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true);
            this.tidMap = this.useMemoryMappedFile ? new PHashMapMMF(this.backingFile, sizeString.getBytes(), 1024, false, bl) : new PHashMap(this.backingFile, sizeString.getBytes(), 1024, false, bl);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4054", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4054"), iOException);
        }
        try {
            this.tidMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4054", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4054"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4054", (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4054"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4198", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(throwable.getKey());
                loadException.setValue(throwable.getValue());
                loadException.setKeyCause(throwable.getKeyCause());
                loadException.setValueCause(throwable.getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = throwable.getNextException();
            }
        }
        throwable = this.tidMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of transaction data", throwable);
        }
        if (bl && Store.getDEBUG()) {
            this.logger.log(1, "TxnAckList initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "TxnAckList: loaded acks for " + this.tidMap.size() + " transactions");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    TxnAckList(File file, File file2, boolean bl) throws BrokerException {
        Throwable throwable;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4203", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(throwable.getKey());
                loadException.setValue(throwable.getValue());
                loadException.setKeyCause(throwable.getKeyCause());
                loadException.setValueCause(throwable.getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = throwable.getNextException();
            }
        }
        throwable = pHashMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of transaction data in old store", throwable);
        }
        try {
            this.tidMap = this.config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true) ? new PHashMapMMF(this.backingFile, file3.length(), 1024, false, false) : new PHashMap(this.backingFile, file3.length(), 1024, false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), iOException);
        }
        try {
            this.tidMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this.logger.log(32, "B4156", (Object)file3, (Object)this.backingFile, (Throwable)pHashMapLoadException);
            throw new BrokerException(this.br.getString("B4156", file3, this.backingFile), pHashMapLoadException);
        }
        throwable = this.tidMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of transaction data", throwable);
        }
        for (Map.Entry entry : pHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.tidMap.put(k, v);
        }
        pHashMap.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "TxnAckList: upgraded acks for " + this.tidMap.size() + " txns");
        }
        if (bl && !file3.delete()) {
            this.logger.log(32, "B1044", (Object)file3);
        }
    }

    void storeAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        try {
            boolean bl2 = false;
            HashSet hashSet = (HashSet)this.tidMap.get((Object)transactionUID);
            if (hashSet == null) {
                bl2 = true;
                hashSet = new HashSet();
            } else if (hashSet.contains(transactionAcknowledgement)) {
                this.logger.log(32, "B3062", (Object)transactionAcknowledgement, (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3062", transactionAcknowledgement, transactionUID));
            }
            hashSet.add(transactionAcknowledgement);
            Object object = this.tidMap.put((Object)transactionUID, hashSet, bl2);
            if (bl2 && object != null) {
                hashSet = (HashSet)this.tidMap.get((Object)transactionUID);
                hashSet.add(transactionAcknowledgement);
                this.tidMap.put((Object)transactionUID, (Object)hashSet);
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4056", (Object)transactionAcknowledgement.toString(), (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B4056", transactionAcknowledgement.toString(), transactionUID.toString()), runtimeException);
        }
    }

    void storeAcks(TransactionUID transactionUID, TransactionAcknowledgement[] transactionAcknowledgementArray, boolean bl) throws BrokerException {
        List<TransactionAcknowledgement> list = Arrays.asList(transactionAcknowledgementArray);
        try {
            boolean bl2 = false;
            HashSet hashSet = (HashSet)this.tidMap.get((Object)transactionUID);
            if (hashSet == null) {
                bl2 = true;
                hashSet = new HashSet(list.size());
            }
            hashSet.addAll(list);
            Object object = this.tidMap.put((Object)transactionUID, hashSet, bl2);
            if (bl2 && object != null) {
                hashSet = (HashSet)this.tidMap.get((Object)transactionUID);
                hashSet.addAll(list);
                this.tidMap.put((Object)transactionUID, (Object)hashSet);
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4056", (Object)list.toString(), (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B4056", list.toString(), transactionUID.toString()), runtimeException);
        }
    }

    HashMap getAllAcks() {
        if (this.tidMap.size() == 0) {
            return this.emptyHashMap;
        }
        HashMap hashMap = new HashMap(this.tidMap.size());
        Set set = this.tidMap.entrySet();
        for (Map.Entry entry : set) {
            HashSet hashSet = (HashSet)entry.getValue();
            TransactionAcknowledgement[] transactionAcknowledgementArray = hashSet.toArray(this.emptyAckArray);
            hashMap.put(entry.getKey(), transactionAcknowledgementArray);
        }
        return hashMap;
    }

    public TransactionUID[] getAllTids() {
        TransactionUID[] transactionUIDArray = null;
        Set set = this.tidMap.keySet();
        transactionUIDArray = new TransactionUID[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            transactionUIDArray[n] = (TransactionUID)iterator.next();
        }
        return transactionUIDArray;
    }

    TransactionAcknowledgement[] getAcks(TransactionUID transactionUID) throws BrokerException {
        HashSet hashSet = (HashSet)this.tidMap.get((Object)transactionUID);
        if (hashSet != null) {
            return hashSet.toArray(this.emptyAckArray);
        }
        return this.emptyAckArray;
    }

    void removeAcks(TransactionUID transactionUID, boolean bl) throws BrokerException {
        try {
            HashSet hashSet = (HashSet)this.tidMap.remove((Object)transactionUID);
            if (bl) {
                this.sync(transactionUID);
            }
            if (hashSet != null) {
                hashSet.clear();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4060", (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B4060", transactionUID.toString()), runtimeException);
        }
    }

    void clearAll(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnAckList.clearAll() called");
        }
        try {
            this.tidMap.clear();
            if (bl) {
                this.sync(null);
            }
        }
        catch (Exception exception) {
            this.logger.log(32, this.br.getString("B4055", this.backingFile), (Throwable)exception);
        }
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnAckList: closing, " + this.tidMap.size() + " transactions has acks");
        }
        this.tidMap.close();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Txn acks", String.valueOf(this.tidMap.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nTransaction acknowledgements");
        printStream.println("----------------------------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("Number of transactions containing acknowledgements: " + this.tidMap.size());
    }

    public int getNumberOfTxnAcks() {
        int n = 0;
        for (Map.Entry entry : this.tidMap.entrySet()) {
            HashSet hashSet = (HashSet)entry.getValue();
            n += hashSet.size();
        }
        return n;
    }

    void sync(TransactionUID transactionUID) throws BrokerException {
        try {
            this.tidMap.force((Object)transactionUID);
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.backingFile, iOException);
        }
    }
}

