/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.AdminConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ConcurrentEndpointConsumer;
import com.sun.messaging.jms.ra.ConnectionManager;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.LifecycleManagedBroker;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.management.remote.JMXServiceURL;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class ResourceAdapter
implements javax.resource.spi.ResourceAdapter,
ExceptionListener,
Serializable,
EventListener {
    private String raUID = null;
    private transient BootstrapContext b_context = null;
    protected transient WorkManager workMgr = null;
    private transient boolean started;
    private transient boolean stopping;
    private transient HashMap<Integer, MessageEndpointFactory> epFactories = null;
    private transient HashMap<Integer, EndpointConsumer> epConsumers = null;
    private transient HashMap<Integer, Integer> epFactoryToConsumer = null;
    private transient int _factoryID = 0;
    private transient int _consumerID = 0;
    private transient XAConnectionFactory xacf = null;
    protected transient XAConnectionImpl xac = null;
    private transient Method onMessage = null;
    private transient boolean logRCFailures = true;
    private static final transient String _className = "com.sun.messaging.jms.ra.ResourceAdapter";
    protected static final transient String _lgrNameBase = "javax.resourceadapter.mqjmsra";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerB = Logger.getLogger("javax.resourceadapter.mqjmsra");
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_RA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_RA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_RA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    protected static final transient ConnectionManager _cm = new ConnectionManager();
    protected static final transient Version _version = new Version();
    private static boolean isXAJoinAllowed = Boolean.valueOf(System.getProperty("imq.jmsra.isXAJoinAllowed", "false"));
    protected String userName = "guest";
    protected String password = "guest";
    private boolean reconnectEnabled = false;
    private int reconnectInterval = 5000;
    private int reconnectAttempts = 6;
    private String addressListBehavior = "PRIORITY";
    private int addressListIterations = 1;
    private int maxLoopDelay = 120000;
    private boolean inAppClientContainer = false;
    private boolean inClusteredContainer = false;
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    public static final String BROKER_TYPE_SOMEDIRECT = "DIRECT";
    protected static final String BROKER_TYPE_APIDIRECT = "APIDIRECT";
    protected static final String BROKER_TYPE_RADIRECT = "RADIRECT";
    private static final String DIRECT_MODE_DEFAULT = "true";
    private static final String APIDIRECT_MODE_DEFAULT = "false";
    private String groupName = null;
    private transient LifecycleManagedBroker lmb = new LifecycleManagedBroker();
    private transient String jmxServiceURLList = null;
    private boolean isJMXServiceURLListValid = false;
    private transient String jmxServiceURL = null;
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String brokerBindAddress = null;
    private int brokerPort = 7676;
    private String brokerType = "REMOTE";
    private String connectionURL = "";
    private transient HashMap<String, String[]> jmxConnectorEnv = null;

    public ResourceAdapter() {
        _loggerL.entering(_className, "constructor()");
        this.started = false;
    }

    public synchronized void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        _loggerL.entering(_className, "start()", bootstrapContext);
        this.stopping = false;
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: start:Previously started:Ignoring");
        } else {
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMS Resource Adapter starting...");
            this.b_context = bootstrapContext;
            if (this.b_context != null) {
                this.workMgr = this.b_context.getWorkManager();
            }
            this._adjustInAppClientContainer();
            this.xacf = new XAConnectionFactory();
            if (!this.inAppClientContainer) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty("imq.DaemonThreads", ResourceAdapter.DIRECT_MODE_DEFAULT);
                        return null;
                    }
                });
            }
            if (!this._isRemote()) {
                this.lmb.start();
            }
            try {
                this.configureFactory();
                if (!BROKER_TYPE_RADIRECT.equals(this.brokerType)) {
                    this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                    _loggerL.fine("MQJMSRA_RA1101: start:cID=" + this.xac._getConnectionID());
                    this.init();
                }
            }
            catch (JMSException jMSException) {
                if (this.lmb.isStarted() && this.lmb.isLocal()) {
                    this.lmb.stop();
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:JMSException on createConnection=" + jMSException.getMessage());
                resourceAdapterInternalException.initCause((Throwable)jMSException);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                jMSException.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
            this.epFactories = new HashMap(10);
            this.epConsumers = new HashMap(10);
            this.epFactoryToConsumer = new HashMap(10);
            this._setOnMessageMethod();
            this.started = true;
            _loggerL.config(_lgrMID_INF + this.toString());
            _loggerL.config("MQJMSRA_RA1101: start:SJSMQ JMSRA Connection Factory Config=" + this.xacf.getCurrentConfiguration());
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA Started:" + this.brokerType);
        }
        _loggerL.exiting(_className, "start()");
    }

    public synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        this.stopping = true;
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: stop:Previously stopped:Ignoring");
        } else {
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA stopping...");
            this.removeAllConsumers();
            if (this.xac != null) {
                try {
                    if (_loggerL.isLoggable(Level.FINER)) {
                        _loggerL.finer("MQJMSRA_RA1101: stop:close:cID=" + this.xac._getConnectionID());
                    }
                    this.xac.close();
                }
                catch (JMSException jMSException) {
                    _loggerL.logp(Level.WARNING, _className, "stop()", "MQJMSRA_RA2001: Exception on close:Ignoring:", jMSException);
                }
            }
            if (_cm != null) {
                _cm.destroyConnections();
            }
            if (!this._isRemote()) {
                this.lmb.stop();
            }
            this.started = false;
        }
        _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA stopped.");
        _loggerL.exiting(_className, "stop()");
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException {
        Object[] objectArray = new Object[]{messageEndpointFactory, activationSpec};
        _loggerIM.entering(_className, "endpointActivation()", objectArray);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", objectArray);
            NotSupportedException notSupportedException = new NotSupportedException("MQJMSRA-endpointActivation:Error:RA not started:aborting");
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)notSupportedException);
            throw notSupportedException;
        }
        EndpointConsumer endpointConsumer = System.getProperty("imq.jmsra.endpoint.concurrent", APIDIRECT_MODE_DEFAULT).equals(DIRECT_MODE_DEFAULT) ? new ConcurrentEndpointConsumer(this, messageEndpointFactory, activationSpec, this._isRADirect()) : new EndpointConsumer(this, messageEndpointFactory, activationSpec, this._isRADirect());
        try {
            endpointConsumer.startMessageConsumer();
            if (_loggerIM.isLoggable(Level.FINER)) {
                _loggerIM.finer("MQJMSRA_RA1101: endpointActivation:createMessageConsumer:DONE:fID=" + endpointConsumer.getFactoryID() + " cID=" + endpointConsumer.getConsumerID());
            }
        }
        catch (Exception exception) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: :Failed due to:" + exception.getMessage(), objectArray);
            NotSupportedException notSupportedException = new NotSupportedException("MQJMSRA-endpointActivation:Exception on createMessageConsumer:");
            notSupportedException.initCause((Throwable)exception);
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)notSupportedException);
            throw notSupportedException;
        }
        _loggerIM.exiting(_className, "endpointActivation()");
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        Object[] objectArray = new Object[]{messageEndpointFactory, activationSpec};
        _loggerIM.entering(_className, "endpointDeactivation()", objectArray);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointDeactivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", objectArray);
        } else {
            int n = this.matchMessageFactory(messageEndpointFactory);
            if (n != -1) {
                int n2 = this._getConsumerIDbyFactoryID(n);
                EndpointConsumer endpointConsumer = this._getEndpointConsumer(n2);
                endpointConsumer.setDeactivated();
                try {
                    if (_loggerIM.isLoggable(Level.FINER)) {
                        _loggerIM.finer("MQJMSRA_RA1101: endpointDeactivation:stopMessageConsumer:fID=" + n + " cID=" + n2);
                    }
                    endpointConsumer.stopMessageConsumer();
                }
                catch (Exception exception) {
                    _loggerIM.logp(Level.WARNING, _className, "endpointDeactivation()", "MQJMSRA_RA2001: Exception on stopMessageConsumer:Ignoring:", exception);
                    exception.printStackTrace();
                }
                this.removeFromMaps(n);
            } else {
                _loggerIM.log(Level.WARNING, "MQJMSRA_RA2001: endpointDeactivation:Ignoring:Not found:" + activationSpec.toString());
            }
        }
        _loggerIM.exiting(_className, "endpointDeactivation()");
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecArray) throws ResourceException {
        _loggerL.entering(_className, "getXAResources()");
        XAResource[] xAResourceArray = new XAResource[]{};
        _loggerL.exiting(_className, "getXAResources()");
        return xAResourceArray;
    }

    public void onException(JMSException jMSException) {
        _loggerL.entering(_className, "onException()", (Object)jMSException);
        _loggerL.warning("MQJMSRA_RA2001: onException:Connection Failed:" + jMSException.getMessage());
        this.logRCFailures = true;
        int n = this.reconnectInterval;
        int n2 = 0;
        while (this.started && !this.stopping) {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                _loggerL.warning("MQJMSRA_RA2001: onException:Reconnecting...Loop Attempt# " + ++n2 + ":Delayed " + n + " milliseconds.");
                this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                this.init();
                _loggerL.warning("MQJMSRA_RA2001: onException:Reconnect successfull on loop# " + n2);
                break;
            }
            catch (JMSException jMSException2) {
                if (this.logRCFailures) {
                    _loggerL.severe("MQJMSRA_RA2001: onException:Reconnect unsuccessfull on loop# " + n2 + ":" + jMSException2.getMessage());
                    jMSException2.printStackTrace();
                } else {
                    _loggerL.severe("MQJMSRA_RA2001: onException:Reconnect unsuccessfull on loop# " + n2);
                }
                this.logRCFailures = false;
                if (n >= this.maxLoopDelay || (n *= 3) <= this.maxLoopDelay) continue;
                n = this.maxLoopDelay;
            }
        }
        _loggerL.exiting(_className, "onException()");
    }

    public void onEvent(Event event) {
        _loggerL.entering(_className, "onEvent()", event);
        _loggerL.info("MQJMSRA_RA1101: onEvent:Connection Event:" + (event == null ? "null" : event.toString()));
    }

    public synchronized void setUserName(String string) {
        _loggerL.entering(_className, "setUserName()", string);
        this.userName = string;
    }

    public String getUserName() {
        _loggerL.entering(_className, "getUserName()", this.userName);
        return this.userName;
    }

    public synchronized void setPassword(String string) {
        _loggerL.entering(_className, "setPassword()");
        this.password = string;
    }

    public String getPassword() {
        _loggerL.entering(_className, "getPassword()");
        return this.password;
    }

    public synchronized void setReconnectEnabled(boolean bl) {
        _loggerL.entering(_className, "setReconnectEnabled()", Boolean.toString(bl));
        this.reconnectEnabled = bl;
    }

    public boolean getReconnectEnabled() {
        _loggerL.entering(_className, "getReconnectEnabled()", Boolean.toString(this.reconnectEnabled));
        return this.reconnectEnabled;
    }

    public synchronized void setReconnectInterval(int n) {
        _loggerL.entering(_className, "setReconnectInterval()", Integer.toString(n));
        this.reconnectInterval = n;
    }

    public int getReconnectInterval() {
        _loggerL.entering(_className, "getReconnectInterval()", Integer.toString(this.reconnectInterval));
        return this.reconnectInterval;
    }

    public synchronized void setReconnectAttempts(int n) {
        _loggerL.entering(_className, "setReconnectAttempts()", Integer.toString(n));
        this.reconnectAttempts = n;
    }

    public int getReconnectAttempts() {
        _loggerL.entering(_className, "getReconnectAttempts()", Integer.toString(this.reconnectAttempts));
        return this.reconnectAttempts;
    }

    public synchronized void setAddressListBehavior(String string) {
        _loggerL.entering(_className, "setAddressListBehavior()", string);
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(string) ? "RANDOM" : "PRIORITY";
    }

    public String getAddressListBehavior() {
        _loggerL.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        return this.addressListBehavior;
    }

    public synchronized void setAddressListIterations(int n) {
        _loggerL.entering(_className, "setAddressListIterations()", Integer.toString(n));
        if (n < 1) {
            _loggerL.warning("MQJMSRA_RA2001: setAddressListIterations:Invalid value:" + Integer.toString(n) + ":Setting to 1");
            this.addressListIterations = 1;
        } else {
            this.addressListIterations = n;
        }
    }

    public int getAddressListIterations() {
        _loggerL.entering(_className, "getAddressListIterations()", Integer.toString(this.addressListIterations));
        return this.addressListIterations;
    }

    public synchronized void setInAppClientContainer(boolean bl) {
        _loggerL.entering(_className, "setInAppClientContainer()", Boolean.toString(bl));
        this.inAppClientContainer = bl;
        this._adjustInAppClientContainer();
    }

    public boolean getInAppClientContainer() {
        _loggerL.entering(_className, "getInAppClientContainer()", Boolean.toString(this.inAppClientContainer));
        return this.inAppClientContainer;
    }

    public synchronized void setInClusteredContainer(boolean bl) {
        _loggerL.entering(_className, "setInClusteredContainer()", Boolean.toString(bl));
        this.inClusteredContainer = bl;
    }

    public boolean getInClusteredContainer() {
        _loggerL.entering(_className, "getInClusteredContainer()", Boolean.toString(this.inClusteredContainer));
        return this.inClusteredContainer;
    }

    public synchronized void setGroupName(String string) {
        _loggerL.entering(_className, "setGroupName()", string);
        this.groupName = string;
    }

    public String getGroupName() {
        _loggerL.entering(_className, "getGroupName()", this.groupName);
        return this.groupName;
    }

    public synchronized void setBrokerType(String string) {
        _loggerL.entering(_className, "setBrokerType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:RA already started:Disallowing change from:" + this.brokerType + ":to:" + string);
            return;
        }
        if ("DIRECT".equals(string) || BROKER_TYPE_EMBEDDED.equals(string)) {
            this.brokerType = ResourceAdapter._isDirectDefault() ? "DIRECT" : BROKER_TYPE_EMBEDDED;
            if ("DIRECT".equals(this.brokerType)) {
                if (ResourceAdapter._useAPIDirectImplementation()) {
                    _loggerL.info("MQJMSRA_RA1101:  Using new API DIRECT mode");
                    this.brokerType = BROKER_TYPE_APIDIRECT;
                } else {
                    _loggerL.info("MQJMSRA_RA1101:  Using old JMSRA DIRECT mode");
                    this.brokerType = BROKER_TYPE_RADIRECT;
                }
            }
        } else if (BROKER_TYPE_LOCAL.equals(string) || BROKER_TYPE_REMOTE.equals(string)) {
            this.brokerType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + string + ":remaining at brokerType=" + this.brokerType);
        }
        this.lmb.setBrokerType(string);
    }

    public String getBrokerType() {
        _loggerL.entering(_className, "getBrokerType()", this.brokerType);
        return this.brokerType;
    }

    public synchronized void setBrokerInstanceName(String string) {
        _loggerL.entering(_className, "setBrokerInstanceName()", string);
        this.lmb.setBrokerInstanceName(string);
    }

    public String getBrokerInstanceName() {
        String string = this.lmb.getBrokerInstanceName();
        _loggerL.entering(_className, "getBrokerInstanceName()", string);
        return string;
    }

    public synchronized void setBrokerBindAddress(String string) {
        _loggerL.entering(_className, "setBrokerBindAddress()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:RA already started:Disallowing change from:" + this.brokerBindAddress + ":to:" + string);
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.brokerBindAddress = string;
            this.lmb.setBrokerBindAddress(string);
        }
        catch (UnknownHostException unknownHostException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:Ignoring Invalid Address:" + string + ":ExceptionMsg=" + unknownHostException.getMessage());
        }
    }

    public String getBrokerBindAddress() {
        _loggerL.entering(_className, "getBrokerBindAddress()", this.brokerBindAddress);
        return this.brokerBindAddress;
    }

    public synchronized void setBrokerPort(int n) {
        _loggerL.entering(_className, "setBrokerPort()", new Integer(n));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + n);
            return;
        }
        this.brokerPort = n;
        this.lmb.setBrokerPort(n);
    }

    public int getBrokerPort() {
        _loggerL.entering(_className, "getBrokerPort()", new Integer(this.brokerPort));
        return this.brokerPort;
    }

    public synchronized void setConnectionURL(String string) {
        String string2 = string;
        _loggerL.entering(_className, "setConnectionURL()", string2);
        this.connectionURL = string;
        this.lmb.setConnectionURL(string);
        this.isJMXServiceURLListValid = false;
    }

    public String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        if ("".equals(this.connectionURL)) {
            _loggerL.fine("MQJMSRA_RA1101: getConnectionURL:returning default of 'localhost' for empty connectionURL");
            return "localhost";
        }
        return this.connectionURL;
    }

    public synchronized void setBrokerHomeDir(String string) {
        _loggerL.entering(_className, "setBrokerHomeDir()", string);
        this.lmb.setBrokerHomeDir(string);
    }

    public String getBrokerHomeDir() {
        String string = this.lmb.getBrokerHomeDir();
        _loggerL.entering(_className, "getBrokerHomeDir()", string);
        return string;
    }

    public synchronized void setBrokerVarDir(String string) {
        _loggerL.entering(_className, "setBrokerVarDir()", string);
        this.lmb.setBrokerVarDir(string);
    }

    public String getBrokerVarDir() {
        String string = this.lmb.getBrokerVarDir();
        _loggerL.entering(_className, "getBrokerVarDir()", string);
        return string;
    }

    public synchronized void setBrokerLibDir(String string) {
        _loggerL.entering(_className, "setBrokerLibDir()", string);
        this.lmb.setBrokerLibDir(string);
    }

    public String getBrokerLibDir() {
        String string = this.lmb.getBrokerLibDir();
        _loggerL.entering(_className, "getBrokerLibDir()", string);
        return string;
    }

    public synchronized void setBrokerJavaDir(String string) {
        _loggerL.entering(_className, "setBrokerJavaDir()", string);
        this.lmb.setBrokerJavaDir(string);
    }

    public String getBrokerJavaDir() {
        String string = this.lmb.getBrokerJavaDir();
        _loggerL.entering(_className, "getBrokerJavaDir()", string);
        return string;
    }

    public synchronized void setBrokerArgs(String string) {
        _loggerL.entering(_className, "setBrokerArgs()", string);
        this.lmb.setBrokerArgs(string);
    }

    public String getBrokerArgs() {
        String string = this.lmb.getBrokerArgs();
        _loggerL.entering(_className, "getBrokerArgs()", string);
        return string;
    }

    public synchronized void setMasterBroker(String string) {
        _loggerL.entering(_className, "setMasterBroker()", string);
        this.lmb.setMasterBroker(string);
    }

    public String getMasterBroker() {
        String string = this.lmb.getMasterBroker();
        _loggerL.entering(_className, "getMasterBroker()", string);
        return string;
    }

    public void setBrokerStartTimeout(int n) {
        _loggerL.entering(_className, "setBrokerStartTimeout()", n);
        this.lmb.setBrokerStartTimeout(n);
    }

    public int getBrokerStartTimeout() {
        int n = this.lmb.getBrokerStartTimeout();
        _loggerL.entering(_className, "getBrokerStartTimeout()", n);
        return n;
    }

    public synchronized void setAdminUsername(String string) {
        _loggerL.entering(_className, "setAdminUsername()", string);
        this.adminUsername = string;
        this.lmb.setAdminUsername(string);
    }

    public String getAdminUsername() {
        _loggerL.entering(_className, "getAdminUsername()", this.adminUsername);
        return this.adminUsername;
    }

    public synchronized void setAdminPassword(String string) {
        _loggerL.entering(_className, "setAdminPassword()");
        this.adminPassword = string;
        this.lmb.setAdminPassword(string);
    }

    public String getAdminPassword() {
        _loggerL.entering(_className, "getAdminPassword()");
        return this.adminPassword;
    }

    public synchronized void setAdminPassFile(String string) {
        _loggerL.entering(_className, "setAdminPassFile()", string);
        this.lmb.setAdminPassFile(string);
    }

    public String getAdminPassFile() {
        String string = this.lmb.getAdminPassFile();
        _loggerL.entering(_className, "getAdminPassFile()", string);
        return string;
    }

    public synchronized HashMap getJMXConnectorEnv() {
        _loggerL.entering(_className, "getJMXConnectorEnv()");
        if (this.jmxConnectorEnv == null) {
            this.jmxConnectorEnv = new HashMap();
            String[] stringArray = new String[]{this.getAdminUsername(), this.getAdminPassword()};
            this.jmxConnectorEnv.put("jmx.remote.credentials", stringArray);
        }
        return this.jmxConnectorEnv;
    }

    public synchronized String getJMXServiceURLList() {
        _loggerL.entering(_className, "getJMXServiceURLList()", "For addressList = " + this.getConnectionURL());
        if (this.isJMXServiceURLListValid) {
            _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
            return this.jmxServiceURLList;
        }
        AdminConnectionFactory adminConnectionFactory = new AdminConnectionFactory();
        try {
            adminConnectionFactory.setProperty("imqDefaultAdminUsername", this.getAdminUsername());
            adminConnectionFactory.setProperty("imqDefaultAdminPassword", this.getAdminPassword());
        }
        catch (Exception exception) {
            _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception configuring AdminConnectionFactory:Message=" + exception.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("");
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getConnectionURL(), " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (_loggerL.isLoggable(Level.FINER)) {
                _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:addressList component = " + string2);
            }
            try {
                adminConnectionFactory.setProperty("imqAddress", string2);
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:address=" + string2);
                }
                string = adminConnectionFactory.getJMXServiceURL().toString();
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:JMXServiceURL string for addressList component " + string2 + " = " + string);
                }
                stringBuffer.append(string + " ");
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception:Message=" + exception.getMessage());
            }
        }
        this.jmxServiceURLList = stringBuffer.toString();
        this.isJMXServiceURLListValid = true;
        _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
        return this.jmxServiceURLList;
    }

    public synchronized String getJMXServiceURL() {
        _loggerL.entering(_className, "getJMXServiceURL()");
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: getJMXServiceURL:RA not started:Returning null");
            return null;
        }
        if (this.jmxServiceURL == null && !BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            AdminConnectionFactory adminConnectionFactory = new AdminConnectionFactory();
            try {
                adminConnectionFactory.setProperty("imqAddress", "mq://" + (this.getBrokerBindAddress() != null ? this.getBrokerBindAddress() : "localhost") + ":" + Integer.toString(this.getBrokerPort()) + "/jmxrmi");
                adminConnectionFactory.setProperty("imqDefaultAdminUsername", this.getAdminUsername());
                adminConnectionFactory.setProperty("imqDefaultAdminPassword", this.getAdminPassword());
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception configuring AdminConnectionFactory:Message=" + exception.getMessage());
            }
            try {
                JMXServiceURL jMXServiceURL = adminConnectionFactory.getJMXServiceURL();
                this.jmxServiceURL = jMXServiceURL.toString();
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception:Message=" + exception.getMessage());
            }
        }
        _loggerL.exiting(_className, "getJMXServiceURL()", this.jmxServiceURL);
        return this.jmxServiceURL;
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean bl) {
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", new Boolean(bl));
        this.lmb.setUseJNDIRmiServiceURL(bl);
    }

    public boolean getUseJNDIRmiServiceURL() {
        boolean bl = this.getUseJNDIRmiServiceURL();
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", new Boolean(bl));
        return bl;
    }

    public synchronized void setStartRmiRegistry(boolean bl) {
        _loggerL.entering(_className, "setStartRmiRegistry()", new Boolean(bl));
        this.lmb.setStartRmiRegistry(bl);
    }

    public boolean getStartRmiRegistry() {
        boolean bl = this.lmb.getStartRmiRegistry();
        _loggerL.entering(_className, "getStartRmiRegistry()", new Boolean(bl));
        return bl;
    }

    public synchronized void setRmiRegistryPort(int n) {
        _loggerL.entering(_className, "setRmiRegistryPort()", new Integer(n));
        this.lmb.setRmiRegistryPort(n);
    }

    public int getRmiRegistryPort() {
        int n = this.lmb.getRmiRegistryPort();
        _loggerL.entering(_className, "getRmiRegistryPort()", new Integer(n));
        return n;
    }

    public synchronized void setUseSSLJMXConnector(boolean bl) {
        _loggerL.entering(_className, "setUseSSLJMXConnector()", new Boolean(bl));
        this.lmb.setUseSSLJMXConnector(bl);
    }

    public boolean getUseSSLJMXConnector() {
        boolean bl = this.lmb.getUseSSLJMXConnector();
        _loggerL.entering(_className, "getUseSSLJMXConnector()", new Boolean(bl));
        return bl;
    }

    public synchronized void setBrokerEnableHA(boolean bl) {
        _loggerL.entering(_className, "setBrokerEnableHA()", new Boolean(bl));
        this.lmb.setBrokerEnableHA(bl);
    }

    public boolean getBrokerEnableHA() {
        boolean bl = this.lmb.getBrokerEnableHA();
        _loggerL.entering(_className, "getBrokerEnableHA()", new Boolean(bl));
        return bl;
    }

    public synchronized void setClusterId(String string) {
        _loggerL.entering(_className, "setClusterId()", string);
        this.lmb.setClusterId(string);
    }

    public String getClusterId() {
        String string = this.lmb.getClusterId();
        _loggerL.entering(_className, "getClusterId()", string);
        return string;
    }

    public synchronized void setBrokerId(String string) {
        _loggerL.entering(_className, "setBrokerId()", string);
        this.lmb.setBrokerId(string);
    }

    public String getBrokerId() {
        String string = this.lmb.getBrokerId();
        _loggerL.entering(_className, "getBrokerId()", string);
        return string;
    }

    public synchronized void setDBType(String string) {
        _loggerL.entering(_className, "setDBType()", string);
        this.lmb.setDBType(string);
    }

    public String getDBType() {
        String string = this.lmb.getDBType();
        _loggerL.entering(_className, "getDBType()", string);
        return string;
    }

    public synchronized void setDBProps(Properties properties) {
        _loggerL.entering(_className, "setDBProps()", properties);
        this.lmb.setDBProps(properties);
    }

    public Properties getDBProps() {
        Properties properties = this.lmb.getDBProps();
        _loggerL.entering(_className, "getDBProps()", properties);
        return properties;
    }

    public synchronized void setDSProps(Properties properties) {
        _loggerL.entering(_className, "setDSProps()", properties);
        this.lmb.setDSProps(properties);
    }

    public Properties getDSProps() {
        Properties properties = this.lmb.getDSProps();
        _loggerL.entering(_className, "getDSProps()", properties);
        return properties;
    }

    protected String _getEffectiveConnectionURL() {
        _loggerL.entering(_className, "_getEffectiveConnectionURL()");
        String string = null;
        if (BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            string = this.getConnectionURL();
        } else if (BROKER_TYPE_LOCAL.equals(this.brokerType) | BROKER_TYPE_EMBEDDED.equals(this.brokerType) | BROKER_TYPE_RADIRECT.equals(this.brokerType)) {
            string = (this.getBrokerBindAddress() != null ? this.getBrokerBindAddress() : "localhost") + ":" + Integer.toString(this.getBrokerPort());
            if (this.getConnectionURL() != null && !"".equals(this.getConnectionURL())) {
                string = string + "," + this.getConnectionURL();
            }
        } else {
            string = "mq://localhost/direct";
        }
        _loggerL.exiting(_className, "_getEffectiveConnectionURL()", string);
        return string;
    }

    protected XAConnectionFactory _getXACF() {
        return this.xacf;
    }

    protected String _getRAUID() {
        return this.raUID;
    }

    protected Method _getOnMessageMethod() {
        if (this.onMessage == null) {
            this._setOnMessageMethod();
        }
        return this.onMessage;
    }

    private void configureFactory() throws JMSException {
        Object var1_1 = null;
        if (!BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            this.xacf.setProperty("imqAddressList", this._getEffectiveConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", "PRIORITY");
        } else {
            this.xacf.setProperty("imqAddressList", this.getConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
        }
        this.xacf.setProperty("imqDefaultUsername", this.userName);
        this.xacf.setProperty("imqDefaultPassword", this.password);
        this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
        this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
        this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
        this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
    }

    private void init() throws JMSException {
        if (this.xac != null) {
            if (this.inClusteredContainer && this.raUID == null) {
                this.raUID = Long.toString(this.xac.generateUID());
            }
            this.xac.setExceptionListener(this);
            this.xac.setEventListener(this);
        }
        if (_loggerL.isLoggable(Level.FINER)) {
            _loggerL.finer("MQJMSRA_RA1101: init:DONE:raUID=" + this.raUID);
        }
    }

    private int createFactoryID() {
        return ++this._factoryID;
    }

    private int createConsumerID() {
        return ++this._consumerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = this.createFactoryID();
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.put(new Integer(n), messageEndpointFactory);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageFactory(int n) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageEndpointFactory _getMessageFactory(int n) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            MessageEndpointFactory messageEndpointFactory = this.epFactories.get(new Integer(n));
            return messageEndpointFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int matchMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = -1;
        if (messageEndpointFactory != null) {
            HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
            synchronized (hashMap) {
                Set<Map.Entry<Integer, MessageEndpointFactory>> set = this.epFactories.entrySet();
                if (set != null) {
                    for (Map.Entry entry : set) {
                        if (!messageEndpointFactory.equals(entry.getValue())) continue;
                        Integer n2 = (Integer)entry.getKey();
                        n = n2;
                        break;
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactorytoConsumerLink(int n, int n2) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.put(new Integer(n), new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFactorytoConsumerLink(int n) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.remove(new Integer(n));
        }
    }

    private int _getConsumerIDbyFactoryID(int n) {
        return this.epFactoryToConsumer.get(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addEndpointConsumer(EndpointConsumer endpointConsumer) {
        int n = this.createConsumerID();
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.put(new Integer(n), endpointConsumer);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEndpointConsumer(int n) {
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.remove(new Integer(n));
        }
    }

    private EndpointConsumer _getEndpointConsumer(int n) {
        EndpointConsumer endpointConsumer = this.epConsumers.get(new Integer(n));
        return endpointConsumer;
    }

    private void removeFromMaps(int n) {
        int n2 = this._getConsumerIDbyFactoryID(n);
        this.removeEndpointConsumer(n2);
        this.removeMessageFactory(n);
        this.removeFactorytoConsumerLink(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConsumers() {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            Set<Map.Entry<Integer, MessageEndpointFactory>> set = this.epFactories.entrySet();
            if (set != null) {
                for (Map.Entry entry : set) {
                    int n = (Integer)entry.getKey();
                    int n2 = this._getConsumerIDbyFactoryID(n);
                    EndpointConsumer endpointConsumer = this._getEndpointConsumer(n2);
                    try {
                        endpointConsumer.stopMessageConsumer();
                    }
                    catch (Exception exception) {
                        System.err.println("MQJMSRA:RA::Error:stopMessageConsumer exception:ignoring");
                    }
                }
                this.clearMaps();
            }
        }
    }

    private void clearMaps() {
        this.epFactories.clear();
        this.epConsumers.clear();
        this.epFactoryToConsumer.clear();
    }

    private void _setOnMessageMethod() {
        Method method = null;
        try {
            Class<MessageListener> clazz = MessageListener.class;
            Class[] classArray = new Class[]{Message.class};
            method = clazz.getMethod("onMessage", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this.onMessage = method;
    }

    private void _adjustInAppClientContainer() {
        String string = System.getProperty("imq.jmsra.inACC");
        if (string != null) {
            System.err.println("MQJMSRA:RA:AIACC:SystemProp imq.jmsra.inACC is NOT null!!");
            if (DIRECT_MODE_DEFAULT.equals(string)) {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC true");
                this.inAppClientContainer = true;
            } else {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC false");
                this.inAppClientContainer = false;
            }
        } else if (this.workMgr != null) {
            try {
                this.workMgr.doWork(new Work(){

                    public void run() {
                    }

                    public void release() {
                    }
                });
            }
            catch (Exception exception) {
                this.inAppClientContainer = true;
            }
        } else {
            this.inAppClientContainer = true;
        }
    }

    protected static boolean _isDirectDefault() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct", DIRECT_MODE_DEFAULT));
    }

    protected static boolean _useAPIDirectImplementation() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.apidirect", APIDIRECT_MODE_DEFAULT));
    }

    public String toString() {
        return "SJSMQ JMSRA ResourceAdapter configuration=\n\traUID                    =" + this.raUID + "\n" + "\tGroupName                =" + this.groupName + "\n" + "\tbrokerType               =" + this.brokerType + "\n" + "\tbrokerBindAddress        =" + this.brokerBindAddress + "\n" + "\tbrokerPort               =" + this.brokerPort + "\n" + "\tConnectionURL            =" + this.connectionURL + "\n" + "\tRADIRECT Mode allowed    =" + this._isRADirectAllowed() + "\n" + "\tAPIDIRECT Mode allowed   =" + this._isAPIDirectAllowed() + "\n" + "\tDIRECT Mode default      =" + this._isDirectDefault() + "\n" + "\tUse APIDIRECT impl       =" + this._useAPIDirectImplementation() + "\n" + "\tUserName                 =" + this.userName + "\n" + "\tPassword                 =" + ("guest".equals(this.password) ? "<default>" : "<modified>") + "\n" + "\tadminUsername            =" + this.adminUsername + "\n" + "\tadminPassword            =" + ("admin".equals(this.adminPassword) ? "<default>" : "<modified>") + "\n" + "\tReconnectEnabled         =" + this.reconnectEnabled + "\n" + "\tReconnectInterval        =" + this.reconnectInterval + "\n" + "\tReconnectAttempts        =" + this.reconnectAttempts + "\n" + "\tAddressListBehavior      =" + this.addressListBehavior + "\n" + "\tAddressListIterations    =" + this.addressListIterations + "\n" + "\tInAppClientContainer     =" + this.inAppClientContainer + "\n" + "\tInClusteredContainer     =" + this.inClusteredContainer + "\n" + "\tjmxServiceURL            =" + this.jmxServiceURL + "\n" + this.lmb.toString();
    }

    public static ConnectionManager _getConnectionManager() {
        return _cm;
    }

    public JMSService _getJMSService() {
        JMSService jMSService = null;
        if (this.lmb != null) {
            jMSService = this.lmb._getJMSService();
        }
        return jMSService;
    }

    protected static final JMSService _getRAJMSService() {
        return LifecycleManagedBroker._getRAJMSService();
    }

    public boolean _isAnyDirect() {
        return BROKER_TYPE_RADIRECT.equals(this.brokerType) | BROKER_TYPE_APIDIRECT.equals(this.brokerType);
    }

    public boolean _isRADirect() {
        return BROKER_TYPE_RADIRECT.equals(this.brokerType);
    }

    public boolean _isAPIDirect() {
        return BROKER_TYPE_APIDIRECT.equals(this.brokerType);
    }

    public boolean _isEmbedded() {
        return BROKER_TYPE_EMBEDDED.equals(this.brokerType);
    }

    public boolean _isRemote() {
        return BROKER_TYPE_REMOTE.equals(this.brokerType);
    }

    public boolean _isRADirectAllowed() {
        return this._isRADirect() && !this.inAppClientContainer;
    }

    public boolean _isAPIDirectAllowed() {
        return this._isAPIDirect() && !this.inAppClientContainer;
    }

    public boolean _isAnyDirectAllowed() {
        return this._isAnyDirect() && !this.inAppClientContainer;
    }

    public void setDoInitOnlyOnStart(boolean bl) {
        if (bl) {
            throw new RuntimeException("setDoInitOnlyOnStart(true) is not supported any more");
        }
    }

    public static boolean isXAJoinAllowed() {
        return isXAJoinAllowed;
    }
}

