/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-jms-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jms.resource")
public class DeleteJMSResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJMSResource.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ConnectorResource[] connResources;
    @Inject
    ConnectorConnectionPool[] connPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("delete.jms.resource.noJndiName", "No JNDI name defined for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport subReport = report.addSubActionsReport();
        ConnectorResource cresource = null;
        for (ConnectorResource cr : this.connResources) {
            if (!cr.getJndiName().equals(this.jndiName)) continue;
            cresource = cr;
        }
        if (cresource == null) {
            Properties params = new Properties();
            params.setProperty("jndi_name", this.jndiName);
            this.commandRunner.doCommand("delete-admin-object", params, subReport);
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSAdminObject", "Unable to Delete Admin Object."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            String defPoolName = this.jndiName;
            String poolName = cresource.getPoolName();
            if (poolName != null && poolName.equals(defPoolName)) {
                Properties params = new Properties();
                params.setProperty("connector_resource_name", this.jndiName);
                this.commandRunner.doCommand("delete-connector-resource", params, subReport);
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSResource", "Unable to Delete Connector Resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                params = new Properties();
                params.setProperty("poolname", this.jndiName);
                this.commandRunner.doCommand("delete-connector-connection-pool", params, subReport);
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSPool", "Unable to Delete Connector Connection Pool."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                Properties params = new Properties();
                params.setProperty("connector_resource_name", this.jndiName);
                this.commandRunner.doCommand("delete-connector-resource", params, subReport);
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSResource", "Unable to Delete Connector Resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

