/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.Hashtable;

public class AuthHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();

    public AuthHandler(ConnectionManager connectionManager) {
        this.connectionList = connectionManager;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        Object object2;
        String string;
        int n;
        block29: {
            Object object3;
            byte[] byArray;
            block34: {
                block33: {
                    AccessController accessController;
                    block30: {
                        block32: {
                            block31: {
                                block28: {
                                    byte[] byArray2 = null;
                                    ByteBuffer byteBuffer = packet.getMessageBodyByteBuffer();
                                    int n2 = byteBuffer.remaining();
                                    byArray2 = new byte[n2];
                                    byteBuffer.get(byArray2);
                                    String string2 = null;
                                    accessController = iMQConnection.getAccessController();
                                    boolean bl = packet.getIndempotent();
                                    byArray = null;
                                    n = 500;
                                    string = null;
                                    if (iMQConnection.isAuthenticated()) {
                                        if (!bl) {
                                            string2 = "already authenticated";
                                            this.logger.log(16, "Received unexpected authentication " + iMQConnection.getRemoteConnectionString() + ":" + (Object)((Object)iMQConnection.getConnectionUID()));
                                            n = 500;
                                        } else {
                                            n = 200;
                                        }
                                        byArray2 = null;
                                    } else if (!iMQConnection.setConnectionState(3)) {
                                        string2 = "bad connection state";
                                        n = 503;
                                        byArray2 = null;
                                    }
                                    if (byArray2 != null) {
                                        try {
                                            byArray = accessController.handleResponse(byArray2, packet.getSequence());
                                            n = 200;
                                            if (byArray == null) {
                                                object2 = (IMQService)iMQConnection.getService();
                                                object3 = ServiceType.getServiceTypeString((int)((IMQService)object2).getServiceType());
                                                try {
                                                    object = ((IMQService)object2).getAuthCacheData();
                                                    ((AuthCacheData)object).setCacheData(accessController.getCacheData());
                                                    accessController.checkConnectionPermission(((IMQService)object2).getName(), (String)object3);
                                                }
                                                catch (AccessControlException accessControlException) {
                                                    string2 = "Forbidden";
                                                    n = 403;
                                                    accessController.logout();
                                                    this.logger.log(16, Globals.getBrokerResources().getKString("B2040", ((IMQService)object2).getName(), object3) + " - " + accessControlException.getMessage(), (Throwable)accessControlException);
                                                    string = iMQConnection.getUserName();
                                                }
                                            }
                                        }
                                        catch (FailedLoginException failedLoginException) {
                                            object3 = (IMQService)iMQConnection.getService();
                                            string = failedLoginException.getUser();
                                            n = 413;
                                            string2 = failedLoginException.getMessage();
                                            this.logger.log(16, "B2130", (Throwable)failedLoginException);
                                        }
                                        catch (OutOfMemoryError outOfMemoryError) {
                                            throw outOfMemoryError;
                                        }
                                        catch (Throwable throwable) {
                                            n = 403;
                                            string2 = throwable.getMessage();
                                            this.logger.log(32, throwable.getMessage(), throwable);
                                        }
                                    }
                                    object2 = new Packet(iMQConnection.useDirectBuffers());
                                    object2.setConsumerID(packet.getConsumerID());
                                    object3 = new Hashtable();
                                    if (string2 != null) {
                                        ((Hashtable)object3).put("JMQReason", string2);
                                    }
                                    if (byArray2 != null) break block28;
                                    object2.setPacketType(13);
                                    ((Hashtable)object3).put("JMQStatus", new Integer(n));
                                    object2.setProperties((Hashtable)object3);
                                    break block29;
                                }
                                if (byArray != null && !iMQConnection.setConnectionState(2)) {
                                    n = 503;
                                    byArray = null;
                                }
                                if (byArray != null) break block30;
                                if (n == 200 && !iMQConnection.setConnectionState(4)) {
                                    n = 503;
                                }
                                object2.setPacketType(13);
                                ((Hashtable)object3).put("JMQStatus", new Integer(n));
                                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                                if (IMQBasicConnection.getDumpPacket()) break block31;
                                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                                if (!IMQBasicConnection.getDumpOutPacket()) break block32;
                            }
                            ((Hashtable)object3).put("JMQReqID", packet.getSysMessageID().toString());
                        }
                        object2.setProperties((Hashtable)object3);
                        break block29;
                    }
                    object2.setPacketType(38);
                    ((Hashtable)object3).put("JMQAuthType", accessController.getAuthType());
                    ((Hashtable)object3).put("JMQChallenge", false);
                    IMQBasicConnection cfr_ignored_2 = (IMQBasicConnection)iMQConnection;
                    if (IMQBasicConnection.getDumpPacket()) break block33;
                    IMQBasicConnection cfr_ignored_3 = (IMQBasicConnection)iMQConnection;
                    if (!IMQBasicConnection.getDumpOutPacket()) break block34;
                }
                ((Hashtable)object3).put("JMQReqID", packet.getSysMessageID().toString());
            }
            object2.setProperties((Hashtable)object3);
            object2.setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage((Packet)object2);
        if (n != 200) {
            object = (IMQService)iMQConnection.getService();
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyConnectionReject(((IMQService)object).getName(), string, iMQConnection.remoteHostString());
            }
            iMQConnection.closeConnection(true, 4, Globals.getBrokerResources().getKString("B0064"));
        } else {
            object = Globals.getAgent();
            if (object != null) {
                ((Agent)object).registerConnection(iMQConnection.getConnectionUID().longValue());
                ((Agent)object).notifyConnectionOpen(iMQConnection.getConnectionUID().longValue());
            }
        }
        return true;
    }
}

