/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-jms-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jms.resource")
public class CreateJMSResource
implements AdminCommand {
    @Param(name="restype")
    String resourceType;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="property", optional=true)
    Properties props;
    @Param(optional=true)
    String target = "server";
    @Param(name="description", optional=true)
    String description;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ConnectorConnectionPool[] connPools;
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String UNIFIED_CF = "javax.jms.ConnectionFactory";
    private static final String DEFAULT_JMS_ADAPTER = "jmsra";
    private static final String DEFAULT_OPERAND = "DEFAULT";
    private static final String NAME = "Name";
    private static final String IMQ_DESTINATION_NAME = "imqDestinationName";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSResource.class);
    Hashtable mapping = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.resourceType == null) {
            report.setMessage(localStrings.getLocalString("create.jms.resource.noResourceType", "No Resoruce Type defined for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("create.jms.resource.noJndiName", "No JNDI name defined for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.populateJmsRAMap();
        if (this.props != null) {
            Enumeration<Object> en = this.props.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String raKey = this.getMappedName(key);
                if (raKey == null) {
                    raKey = key;
                }
                this.props.put(raKey, (String)this.props.get(key));
                this.props.remove(key);
            }
        }
        ActionReport subReport = report.addSubActionsReport();
        if (this.resourceType.equals(TOPIC_CF) || this.resourceType.equals(QUEUE_CF) || this.resourceType.equals(UNIFIED_CF)) {
            ConnectorConnectionPool cpool = null;
            for (ConnectorConnectionPool cp : this.connPools) {
                if (!cp.getName().equals(this.jndiName)) continue;
                cpool = cp;
            }
            boolean createdPool = false;
            if (cpool == null) {
                Properties parameters = this.populateConnectionPoolParameters();
                this.commandRunner.doCommand("create-connector-connection-pool", parameters, subReport);
                createdPool = true;
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateConnectionPool", "Unable to create connection pool."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            Properties params = this.populateConnectionResourceParameters();
            this.commandRunner.doCommand("create-connector-resource", params, subReport);
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateConnectorResource", "Unable to create connection resource."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                if (createdPool) {
                    this.commandRunner.doCommand("delete-connector-connection-pool", this.populateConnectionPoolParameters(), subReport);
                }
                return;
            }
        } else if (this.resourceType.equals(TOPIC) || this.resourceType.equals(QUEUE)) {
            Properties aoAttrList;
            block17: {
                aoAttrList = new Properties();
                try {
                    Properties properties = this.validateDestinationResourceProps(this.props, this.jndiName);
                    aoAttrList.put("property", properties);
                }
                catch (Exception e) {
                    if (!ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) break block17;
                    report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateConnectorResource", "Unable to create connector resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            aoAttrList.setProperty(DEFAULT_OPERAND, this.jndiName);
            aoAttrList.setProperty("restype", this.resourceType);
            aoAttrList.setProperty("raname", DEFAULT_JMS_ADAPTER);
            if (this.enabled != null) {
                aoAttrList.put("enabled", this.enabled);
            }
            this.commandRunner.doCommand("create-admin-object", aoAttrList, subReport);
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateAdminObject", "Unable to create admin object."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }

    private void populateJmsRAMap() {
        this.mapping = new Hashtable();
        this.mapping.put(IMQ_DESTINATION_NAME, NAME);
        this.mapping.put("imqDestinationDescription", "Description");
        this.mapping.put("imqConnectionURL", "ConnectionURL");
        this.mapping.put("imqDefaultUsername", "UserName");
        this.mapping.put("imqDefaultPassword", "Password");
        this.mapping.put("imqConfiguredClientID", "ClientId");
        this.mapping.put("imqAddressList", "AddressList");
        this.mapping.put("MessageServiceAddressList", "AddressList");
    }

    public String getMappedName(String key) {
        return (String)this.mapping.get(key);
    }

    private Properties populateConnectionPoolParameters() {
        String steadyPoolSize = null;
        String maxPoolSize = null;
        String poolResizeQuantity = null;
        String idleTimeoutInSecs = null;
        String maxWaitTimeInMillis = null;
        String failAllConnections = null;
        String transactionSupport = null;
        if (this.props != null) {
            Enumeration<Object> keys = this.props.keys();
            while (keys.hasMoreElements()) {
                String propKey = (String)keys.nextElement();
                if ("steady-pool-size".equals(propKey)) {
                    steadyPoolSize = this.props.getProperty(propKey);
                    continue;
                }
                if ("max-pool-size".equals(propKey)) {
                    maxPoolSize = this.props.getProperty(propKey);
                    continue;
                }
                if ("pool-resize-quantity".equals(propKey)) {
                    poolResizeQuantity = this.props.getProperty(propKey);
                    continue;
                }
                if ("idle-timeout-in-seconds".equals(propKey)) {
                    idleTimeoutInSecs = this.props.getProperty(propKey);
                    continue;
                }
                if ("max-wait-time-in-millis".equals(propKey)) {
                    maxWaitTimeInMillis = this.props.getProperty(propKey);
                    continue;
                }
                if ("transaction-support".equals(propKey)) {
                    transactionSupport = this.props.getProperty(propKey);
                    continue;
                }
                if (!"fail-all-connections".equals(propKey)) continue;
                failAllConnections = this.props.getProperty(propKey);
            }
        }
        Properties parameters = new Properties();
        parameters.setProperty("poolname", this.jndiName);
        if (this.description != null) {
            parameters.setProperty("description", this.description);
        }
        String raName = DEFAULT_JMS_ADAPTER;
        parameters.setProperty("raname", raName);
        parameters.setProperty("connectiondefinition", this.resourceType);
        parameters.setProperty("maxpoolsize", maxPoolSize == null ? "250" : maxPoolSize);
        parameters.setProperty("steadypoolsize", steadyPoolSize == null ? "1" : steadyPoolSize);
        if (poolResizeQuantity != null) {
            parameters.setProperty("poolresize", poolResizeQuantity);
        }
        if (idleTimeoutInSecs != null) {
            parameters.setProperty("idletimeout", idleTimeoutInSecs);
        }
        if (maxWaitTimeInMillis != null) {
            parameters.setProperty("maxwait", maxWaitTimeInMillis);
        }
        if (failAllConnections != null) {
            parameters.setProperty("failconnection", failAllConnections);
        }
        if (transactionSupport != null) {
            parameters.setProperty("transactionsupport", transactionSupport);
        }
        return parameters;
    }

    private Properties populateConnectionResourceParameters() {
        Properties parameters = new Properties();
        parameters.setProperty("jndi_name", this.jndiName);
        parameters.put("enabled", this.enabled);
        parameters.setProperty("poolname", this.jndiName);
        if (this.description != null) {
            parameters.setProperty("description", this.description);
        }
        return parameters;
    }

    private Properties validateDestinationResourceProps(Properties props, String jndiName) throws Exception {
        String providedDestinationName = null;
        if (props != null) {
            providedDestinationName = this.getProvidedDestinationName(props);
        } else {
            props = new Properties();
        }
        if (providedDestinationName != null) {
            if (!this.isSyntaxValid(providedDestinationName)) {
                throw new Exception(localStrings.getLocalString("admin.mbeans.rmb.destination_name_invalid", jndiName, new Object[]{providedDestinationName}));
            }
        } else {
            String newDestName = this.computeDestinationName(jndiName);
            props.put(NAME, newDestName);
        }
        return props;
    }

    private String getProvidedDestinationName(Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)props.get(key);
            if (!NAME.equals(key) && !IMQ_DESTINATION_NAME.equals(key) || value == null || value.length() == 0) continue;
            return value;
        }
        return null;
    }

    private boolean isSyntaxValid(String name) {
        char[] namechars = name.toCharArray();
        if (Character.isJavaIdentifierStart(namechars[0]) || namechars[0] == '*' || namechars[0] == '>') {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i]) || namechars[i] == '.' || namechars[i] == '*' || namechars[i] == '>') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private String computeDestinationName(String providedJndiName) {
        char[] jndiName = providedJndiName.toCharArray();
        char[] finalName = new char[jndiName.length];
        finalName[0] = Character.isJavaIdentifierStart(jndiName[0]) ? jndiName[0] : 95;
        for (int i = 1; i < jndiName.length; ++i) {
            finalName[i] = Character.isJavaIdentifierPart(jndiName[i]) ? jndiName[i] : 95;
        }
        return new String(finalName);
    }
}

