/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.runtime.BrokerInstance;
import com.sun.messaging.jmq.jmsclient.runtime.ClientRuntime;
import com.sun.messaging.jmq.jmsserver.BrokerProcess;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSRABroker;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedBrokerRunner
implements BrokerEventListener {
    private static final String JMSBROKER_CLASS = "com.sun.messaging.jmq.jmsserver.JMSRA_BrokerProcess";
    private Properties brokerProps = null;
    private JMSRABroker raDirectBroker;
    private BrokerInstance apiDirectBroker;
    private JMSService jmsservice = null;
    private BrokerProcess bp = null;
    private String brokerType;
    private static final transient String _className = "com.sun.messaging.jms.ra.EmbeddedBrokerRunner";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_EB";
    protected static final transient String _lgrMID_EET = "MQJMSRA_EB1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_EB1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_EB2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_EB3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_EB4001: ";

    public EmbeddedBrokerRunner(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, String string8, boolean bl, int n2, boolean bl2, boolean bl3, String string9, String string10, String string11, Properties properties) {
        Object[] objectArray;
        if (_loggerL.isLoggable(Level.FINER)) {
            objectArray = new Object[]{string2, string3, Integer.toString(n), string4, string5, string6, string7, string8, new Boolean(bl), new Integer(n2), new Boolean(bl2), new Boolean(bl3), string9, string11, properties};
            _loggerL.entering(_className, "constructor()", objectArray);
        }
        this.brokerType = string;
        objectArray = this.assembleBrokerArgs(string2, n, string4, string5, string6, string8, bl, n2, bl2);
        this.createTheInVMBrokerInstance();
        this.brokerProps = this.parseArgs((String[])objectArray);
        if (string3 != null && !"localhost".equals(string3)) {
            this.brokerProps.setProperty("imq.hostname", string3);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string12 = (String)enumeration.nextElement();
            if (string12 == null) continue;
            String string13 = properties.getProperty(string12);
            this.brokerProps.setProperty(string12, string13);
        }
    }

    private String[] assembleBrokerArgs(String string, int n, String string2, String string3, String string4, String string5, boolean bl, int n2, boolean bl2) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (string5 != null && !"".equals(string5)) {
            stringArray = new StringTokenizer(string5, " ");
            while (stringArray.hasMoreTokens()) {
                String string6 = stringArray.nextToken();
                vector.add(string6);
            }
        }
        vector.add("-port");
        vector.add(Integer.toString(n));
        if (string != null) {
            vector.add("-name");
            vector.add(string);
        }
        if (string2 != null) {
            vector.add("-imqhome");
            vector.add(string2);
        }
        if (string4 != null) {
            vector.add("-varhome");
            vector.add(string4);
        }
        if (string3 != null && !"".equals(string3)) {
            vector.add("-libhome");
            vector.add(string3);
        }
        if (bl) {
            if (bl2) {
                vector.add("-startRmiRegistry");
            } else {
                vector.add("-useRmiRegistry");
            }
            vector.add("-rmiRegistryPort");
            vector.add(Integer.toString(n2));
        }
        vector.add("-save");
        vector.add("-silent");
        stringArray = vector.toArray(new String[0]);
        return stringArray;
    }

    private void createTheInVMBrokerInstance() {
        if ("APIDIRECT".equals(this.brokerType)) {
            ClientRuntime clientRuntime = ClientRuntime.getRuntime();
            try {
                this.apiDirectBroker = clientRuntime.createBrokerInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg=" + classNotFoundException.getMessage());
                classNotFoundException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg=" + illegalAccessException.getMessage());
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg=" + instantiationException.getMessage());
                instantiationException.printStackTrace();
            }
        } else {
            try {
                this.raDirectBroker = (JMSRABroker)Class.forName(JMSBROKER_CLASS).newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg=" + illegalAccessException.getMessage());
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg=" + classNotFoundException.getMessage());
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg=" + instantiationException.getMessage());
                instantiationException.printStackTrace();
            }
        }
    }

    private Properties parseArgs(String[] stringArray) {
        Properties properties = null;
        properties = "APIDIRECT".equals(this.brokerType) ? this.apiDirectBroker.parseArgs(stringArray) : this.raDirectBroker.parseArgs(stringArray);
        return properties;
    }

    public synchronized void init() {
        _loggerL.entering(_className, "init()");
        if (this.apiDirectBroker != null) {
            this.apiDirectBroker.init(this.brokerProps, this);
        } else if (this.raDirectBroker != null) {
            int n = -1;
            try {
                n = this.raDirectBroker.start(true, this.brokerProps, this, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _loggerL.severe("MQJMSRA_EB4001: run:Broker Init Failure:IllegalArgumentException Message=" + illegalArgumentException.getMessage());
            }
            if (n != 0) {
                throw new RuntimeException("EMBEDDED Broker init failure:code = " + n);
            }
            _loggerL.info("MQJMSRA_EB1101: run:EMBEDDED broker initialized with code =" + n);
        }
    }

    public synchronized void start() {
        _loggerL.entering(_className, "start()");
        _loggerL.config("MQJMSRA_EB1101: EB-start:brokerProps=" + this.brokerProps.toString());
        if (this.apiDirectBroker != null) {
            this.apiDirectBroker.start();
        } else if (this.raDirectBroker != null) {
            int n = -1;
            try {
                n = this.raDirectBroker.start(true, this.brokerProps, this, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _loggerL.severe("MQJMSRA_EB4001: run:Broker Start Failure:IllegalArgumentException Message=" + illegalArgumentException.getMessage());
            }
            if (n != 0) {
                throw new RuntimeException("EMBEDDED Broker start failure:code = " + n);
            }
            _loggerL.info("MQJMSRA_EB1101: EMBEDDED broker started with code =" + n);
        }
    }

    protected synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        try {
            if (this.apiDirectBroker != null) {
                this.apiDirectBroker.stop();
                this.apiDirectBroker.shutdown();
                this.apiDirectBroker = null;
            } else {
                this.raDirectBroker.stop(true);
            }
        }
        catch (Exception exception) {
            _loggerL.severe("MQJMSRA_EB4001: stop:Exception on in-VM broker shutdown:msg=" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public JMSService getJMSService() {
        if (this.apiDirectBroker != null) {
            return null;
        }
        if (this.jmsservice == null) {
            this.jmsservice = this.raDirectBroker.getJMSService();
        }
        return this.jmsservice;
    }

    public void brokerEvent(BrokerEvent brokerEvent) {
        _loggerL.info("MQJMSRA_EB1101: stateChanged:" + brokerEvent);
        if (brokerEvent.getType() == BrokerEvent.Type.RESTART) {
            this.stop();
            this.createTheInVMBrokerInstance();
            this.init();
            this.start();
        }
    }

    public boolean exitRequested(BrokerEvent brokerEvent, Throwable throwable) {
        System.out.println("SJSMQRA_EB:Debug-exitRequested:" + brokerEvent);
        if (this.apiDirectBroker != null && brokerEvent.getType() == BrokerEvent.Type.RESTART) {
            System.out.println("SJSMQRA_EB:Debug-exitRequested[granted bcause this is a restart]:" + brokerEvent);
            return true;
        }
        if (brokerEvent.getType() == BrokerEvent.Type.FATAL_ERROR) {
            System.out.println("SJSMQRA_EB:Debug-exitRequested[granted because this is a fatal error]:" + brokerEvent);
            Thread.dumpStack();
            return true;
        }
        System.out.println("SJSMQRA_EB:Debug-exitRequestedd[denied because this is an embedded broker]:" + brokerEvent);
        return false;
    }
}

