/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClusterMessageAckInfo {
    protected Logger logger = Globals.getLogger();
    private SysMessageID[] sysids = null;
    private ConsumerUID[] intids = null;
    private int ackType;
    private Long ackackXid = null;
    private Map optionalProps = null;
    private Long transactionID = null;
    private BrokerAddress msgHome;
    private Cluster c = null;
    private GPacket pkt = null;
    private DataInputStream dis = null;
    private static FaultInjection fi = FaultInjection.getInjection();
    private boolean twophase = false;

    private ClusterMessageAckInfo(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Long l, Map map, Long l2, BrokerAddress brokerAddress, Cluster cluster, boolean bl) {
        this.sysids = sysMessageIDArray;
        this.intids = consumerUIDArray;
        this.ackType = n;
        this.ackackXid = l;
        this.optionalProps = map;
        this.transactionID = l2;
        this.msgHome = brokerAddress;
        this.c = cluster;
        this.twophase = bl;
    }

    private ClusterMessageAckInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    private ClusterMessageAckInfo(GPacket gPacket) {
        this.pkt = gPacket;
        this.c = null;
    }

    public static ClusterMessageAckInfo newInstance(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Long l, Map map, Long l2, BrokerAddress brokerAddress, Cluster cluster, boolean bl) {
        return new ClusterMessageAckInfo(sysMessageIDArray, consumerUIDArray, n, l, map, l2, brokerAddress, cluster, bl);
    }

    public static ClusterMessageAckInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterMessageAckInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws IOException {
        if (this.twophase && this.transactionID == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B3100", "transactionID required for two-phase ack"));
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)3);
        gPacket.putProp((Object)"T", (Object)new Integer(this.ackType));
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        if (this.msgHome.getBrokerSessionUID() != null) {
            gPacket.putProp((Object)"messageBrokerSession", (Object)new Long(this.msgHome.getBrokerSessionUID().longValue()));
        }
        if (this.msgHome.getHAEnabled()) {
            gPacket.putProp((Object)"messageStoreSession", (Object)new Long(this.msgHome.getStoreSessionUID().longValue()));
        }
        if (this.optionalProps != null) {
            Object var2_22 = null;
            for (Object var2_22 : this.optionalProps.keySet()) {
                gPacket.putProp(var2_22, this.optionalProps.get(var2_22));
            }
        }
        if (this.transactionID != null) {
            gPacket.putProp((Object)"transactionID", (Object)this.transactionID);
        }
        if (this.ackackXid != null) {
            gPacket.setBit(1, true);
            gPacket.putProp((Object)"X", (Object)this.ackackXid);
        }
        if (this.ackType == 10) {
            gPacket.putProp((Object)"C", (Object)new Integer(0));
            return gPacket;
        }
        int n = this.sysids.length;
        gPacket.putProp((Object)"C", (Object)new Integer(n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < n; ++i) {
            this.sysids[i].writeID((DataOutput)dataOutputStream);
            ClusterConsumerInfo.writeConsumerUID(this.intids[i], dataOutputStream);
        }
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        return gPacket;
    }

    public int getAckType() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp((Object)"T");
    }

    public Map getOptionalProps() {
        assert (this.pkt != null);
        Set set = this.pkt.propsKeySet();
        if (set == null || set.size() == 0) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object k2 = null;
        for (Object k2 : set) {
            hashMap.put(k2, this.pkt.getProp(k2));
        }
        return hashMap;
    }

    public UID getMessageStoreSessionUID() {
        assert (this.pkt != null);
        Long l = (Long)this.pkt.getProp((Object)"messageStoreSession");
        if (l == null) {
            return null;
        }
        return new UID(l.longValue());
    }

    public UID getMessageBrokerSessionUID() {
        assert (this.pkt != null);
        Long l = (Long)this.pkt.getProp((Object)"messageBrokerSession");
        if (l == null) {
            return null;
        }
        return new UID(l.longValue());
    }

    public Long getTransactionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"transactionID");
    }

    public Integer getCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp((Object)"C");
    }

    public void initPayloadRead() {
        assert (this.pkt != null);
        byte[] byArray = this.pkt.getPayload().array();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.dis = new DataInputStream(byteArrayInputStream);
    }

    public SysMessageID readPayloadSysMessageID() throws IOException {
        assert (this.dis != null);
        SysMessageID sysMessageID = new SysMessageID();
        sysMessageID.readID((DataInput)this.dis);
        return sysMessageID;
    }

    public ConsumerUID readPayloadConsumerUID() throws Exception {
        BrokerAddress brokerAddress;
        assert (this.dis != null);
        ConsumerUID consumerUID = ClusterConsumerInfo.readConsumerUID(this.dis);
        if (this.c != null && (brokerAddress = this.c.unmarshalBrokerAddress(this.pkt)) != null) {
            consumerUID.setBrokerAddress(brokerAddress);
        }
        return consumerUID;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int n, String string, ArrayList[] arrayListArray) {
        assert (this.pkt != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)4);
        gPacket.putProp((Object)"X", (Object)((Long)this.pkt.getProp((Object)"X")));
        gPacket.putProp((Object)"T", (Object)new Integer(this.getAckType()));
        if (this.pkt.getProp((Object)"C") != null) {
            gPacket.putProp((Object)"C", this.pkt.getProp((Object)"C"));
        }
        if (this.pkt.getProp((Object)"messageBrokerSession") != null) {
            gPacket.putProp((Object)"messageBrokerSession", this.pkt.getProp((Object)"messageBrokerSession"));
        }
        if (this.pkt.getProp((Object)"messageStoreSession") != null) {
            gPacket.putProp((Object)"messageStoreSession", this.pkt.getProp((Object)"messageStoreSession"));
        }
        if (this.pkt.getProp((Object)"transactionID") != null) {
            gPacket.putProp((Object)"transactionID", this.pkt.getProp((Object)"transactionID"));
        }
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        if (string != null) {
            gPacket.putProp((Object)"reason", (Object)string);
        }
        if (arrayListArray == null) {
            if (this.pkt.getPayload() != null) {
                gPacket.setPayload(ByteBuffer.wrap(this.pkt.getPayload().array()));
            }
            return gPacket;
        }
        gPacket.putProp((Object)"notfound", (Object)new Integer(arrayListArray[0].size()));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < arrayListArray[0].size(); ++i) {
                ((SysMessageID)arrayListArray[0].get(i)).writeID((DataOutput)dataOutputStream);
                ClusterConsumerInfo.writeConsumerUID((ConsumerUID)arrayListArray[1].get(i), dataOutputStream);
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            gPacket.setPayload(ByteBuffer.wrap(byArray));
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.logStack(16, exception.getMessage(), (Throwable)exception);
        }
        return gPacket;
    }

    public static AckEntryNotFoundException getAckEntryNotFoundException(GPacket gPacket) {
        Integer n = (Integer)gPacket.getProp((Object)"notfound");
        if (n == null) {
            return null;
        }
        int n2 = n;
        Long l = (Long)gPacket.getProp((Object)"transactionID");
        String string = (String)gPacket.getProp((Object)"reason");
        AckEntryNotFoundException ackEntryNotFoundException = new AckEntryNotFoundException(string);
        byte[] byArray = gPacket.getPayload().array();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        SysMessageID sysMessageID = null;
        ConsumerUID consumerUID = null;
        try {
            for (int i = 0; i < n2; ++i) {
                sysMessageID = new SysMessageID();
                sysMessageID.readID((DataInput)dataInputStream);
                consumerUID = ClusterConsumerInfo.readConsumerUID(dataInputStream);
                ackEntryNotFoundException.addAckEntry(sysMessageID, consumerUID);
            }
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.logStack(16, exception.getMessage(), (Throwable)exception);
        }
        return ackEntryNotFoundException;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tAckType = ").append(ClusterGlobals.getAckTypeString(this.ackType));
        if (this.msgHome.getBrokerSessionUID() != null) {
            stringBuffer.append("\n\tMessageBrokerSession = ").append(this.msgHome.getBrokerSessionUID().longValue());
        }
        if (this.msgHome.getHAEnabled()) {
            stringBuffer.append("\n\tMessageStoreSession = ").append(this.msgHome.getStoreSessionUID().longValue());
        }
        if (this.transactionID != null) {
            stringBuffer.append("\n\tTransactionID = ").append(this.transactionID);
        }
        if (this.ackackXid != null) {
            stringBuffer.append("\n\tAckAck = ").append("true");
            stringBuffer.append("\n\tXID = ").append(this.ackackXid);
        }
        stringBuffer.append("\n\tMessage Home = ").append(this.msgHome);
        if (this.sysids != null) {
            stringBuffer.append("\n\tC=").append(new Integer(this.sysids.length));
            for (int i = 0; i < this.sysids.length; ++i) {
                stringBuffer.append("\n\t\tSysMessageID = ").append(this.sysids[i]);
                stringBuffer.append("\n\t\tConsumerUID = ").append(this.intids[i]);
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String toString(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) {
        assert (this.pkt != null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tAckType = ").append(ClusterGlobals.getAckTypeString(this.getAckType()));
        if (this.getMessageBrokerSessionUID() != null) {
            stringBuffer.append("\n\tMessageBrokerSession = ").append(this.getMessageBrokerSessionUID().longValue());
        }
        if (this.getMessageStoreSessionUID() != null) {
            stringBuffer.append("\n\tMessageStoreSession = ").append(this.getMessageStoreSessionUID().longValue());
        }
        if (this.getTransactionID() != null) {
            stringBuffer.append("\n\tTransactionID = ").append(this.getTransactionID());
        }
        if (this.pkt.getProp((Object)"X") != null) {
            stringBuffer.append("\n\tXID = ").append(this.pkt.getProp((Object)"X"));
        }
        if (this.getCount() != null) {
            stringBuffer.append("\n\tCount = ").append(this.getCount());
        }
        if (sysMessageIDArray != null) {
            stringBuffer.append("\n\tC=").append(sysMessageIDArray.length);
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                stringBuffer.append("\n\t\tSysMessageID = ").append(sysMessageIDArray[i]);
                stringBuffer.append("\n\t\tConsumerUID = ").append(consumerUIDArray[i]);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static Long getAckAckXid(GPacket gPacket) {
        return (Long)gPacket.getProp((Object)"X");
    }

    public static Integer getAckAckType(GPacket gPacket) {
        return (Integer)gPacket.getProp((Object)"T");
    }

    public static int getAckAckStatus(GPacket gPacket) {
        return (Integer)gPacket.getProp((Object)"S");
    }

    public static String getAckAckStatusReason(GPacket gPacket) {
        return (String)gPacket.getProp((Object)"reason");
    }

    public static String toString(GPacket gPacket) {
        int n = -1;
        if (ClusterMessageAckInfo.getAckAckType(gPacket) != null) {
            n = ClusterMessageAckInfo.getAckAckType(gPacket);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tackStatus = ").append(Status.getString((int)ClusterMessageAckInfo.getAckAckStatus(gPacket)));
        if (gPacket.getProp((Object)"reason") != null) {
            stringBuffer.append("\n\tReason = ").append(ClusterMessageAckInfo.getAckAckStatusReason(gPacket));
        }
        stringBuffer.append("\n\tAckType = ").append(ClusterGlobals.getAckTypeString(n));
        if (gPacket.getProp((Object)"messageBrokerSession") != null) {
            stringBuffer.append("\n\tMessageBrokerSession = ").append(gPacket.getProp((Object)"messageBrokerSession"));
        }
        if (gPacket.getProp((Object)"messageStoreSession") != null) {
            stringBuffer.append("\n\tMessageStoreSession = ").append(gPacket.getProp((Object)"messageStoreSession"));
        }
        if (gPacket.getProp((Object)"transactionID") != null) {
            stringBuffer.append("\n\tTransactionID = ").append(gPacket.getProp((Object)"transactionID"));
        }
        if (gPacket.getProp((Object)"notfound") != null) {
            stringBuffer.append("\n\tnotfound = ").append((Integer)gPacket.getProp((Object)"notfound"));
        }
        if (gPacket.getPayload() != null) {
            Integer n2 = (Integer)gPacket.getProp((Object)"notfound");
            ClusterMessageAckInfo clusterMessageAckInfo = new ClusterMessageAckInfo(gPacket);
            try {
                int n3;
                int n4 = n3 = clusterMessageAckInfo.getCount() == null ? 1 : clusterMessageAckInfo.getCount();
                if (n2 != null) {
                    n3 = n2;
                }
                clusterMessageAckInfo.initPayloadRead();
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append("\n\t\tSysMessageID = ").append(clusterMessageAckInfo.readPayloadSysMessageID());
                    stringBuffer.append("\n\t\tConsumerUID = ").append(clusterMessageAckInfo.readPayloadConsumerUID().longValue());
                    stringBuffer.append("\n");
                }
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(16, exception.getMessage(), (Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CHECKFAULT(HashMap hashMap, int n, Long l, String string, String string2) {
        int n2 = 0;
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        Integer n3 = new Integer(n);
        Object object = hashMap;
        synchronized (object) {
            Integer n4 = (Integer)hashMap.get(n3);
            if (n4 != null) {
                n2 = n4;
            }
            if (string2.equals("1")) {
                hashMap.put(n3, new Integer(++n2));
            }
        }
        hashMap2.put("mqAckCount", new Integer(n2));
        object = null;
        switch (n) {
            case 3: {
                object = l == null ? "" : "txncommit.";
                break;
            }
            case 9: {
                object = "txnprepare.";
                break;
            }
            case 10: {
                object = "txnrollback.";
            }
        }
        fi.checkFaultAndExit(string + (String)object + string2, hashMap2, 2, false);
    }
}

