/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.DirectBrokerProcess;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.JMSRA_BrokerProcess;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSBroker;
import java.util.Properties;

public class BrokerProcess
implements JMSBroker {
    public static final int EMBEDDED_BROKER = 1;
    public static final int JMSRA_DIRECT_BROKER = 2;
    public static final int DIRECT_BROKER = 3;
    Broker b = Broker.getBroker();
    int type = 1;
    private static BrokerProcess bp = null;

    public static BrokerProcess getBrokerProcess() throws IllegalStateException {
        if (bp != null) {
            return bp;
        }
        bp = BrokerProcess.getBrokerProcess(2);
        return bp;
    }

    public static BrokerProcess getBrokerProcess(int n) throws IllegalStateException {
        if (bp != null) {
            if (BrokerProcess.bp.type != 0 && BrokerProcess.bp.type != n) {
                throw new IllegalStateException("INVALID STATE");
            }
            return bp;
        }
        switch (n) {
            case 1: {
                System.out.println("DEBUG: Oldstyle Embedded");
                bp = new BrokerProcess();
                break;
            }
            case 2: {
                System.out.println("DEBUG: Old JMSRA_Direct");
                bp = new JMSRA_BrokerProcess();
                break;
            }
            case 3: {
                System.out.println("DEBUG new Direct mode");
                bp = new DirectBrokerProcess();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Type");
            }
        }
        return bp;
    }

    public Properties convertArgs(String[] stringArray) throws IllegalArgumentException {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-varhome")) {
                properties.setProperty("imq.varhome", stringArray[i + 1]);
                ++i;
                continue;
            }
            if (string.equals("-imqhome")) {
                properties.setProperty("imq.home", stringArray[i + 1]);
                ++i;
                continue;
            }
            if (!string.equals("-libhome")) continue;
            properties.setProperty("imq.libhome", stringArray[i + 1]);
            ++i;
        }
        Globals.pathinit(properties);
        return this.b.convertArgs(stringArray);
    }

    public Properties parseArgs(String[] stringArray) throws IllegalArgumentException {
        return this.convertArgs(stringArray);
    }

    public static String usage() {
        return BrokerProcess.getBrokerProcess().b.usage();
    }

    public boolean isRunning() {
        return true;
    }

    public int start(boolean bl, Properties properties, BrokerEventListener brokerEventListener, boolean bl2) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return BrokerProcess.getBrokerProcess().b.start(bl, properties, brokerEventListener, bl2);
    }

    public void stop(boolean bl) throws IllegalStateException {
        Broker.destroyBroker(bl);
        this.b = null;
        bp = null;
    }

    public static void main(String[] stringArray) {
        try {
            BrokerProcess brokerProcess = BrokerProcess.getBrokerProcess();
            BrokerEventListener brokerEventListener = new BrokerEventListener(){

                public boolean exitRequested(BrokerEvent brokerEvent, Throwable throwable) {
                    System.out.println("EXIT REQUESTED " + brokerEvent);
                    return false;
                }

                public void brokerEvent(BrokerEvent brokerEvent) {
                    System.out.println("GOT EVENT" + brokerEvent);
                }
            };
            String[] stringArray2 = new String[stringArray.length + 4];
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = stringArray[n];
            }
            stringArray2[n++] = "-varhome";
            stringArray2[n++] = "../../../solaris/opt/var";
            stringArray2[n++] = "-imqhome";
            stringArray2[n++] = "../../../solaris/opt/";
            Properties properties = brokerProcess.convertArgs(stringArray2);
            System.err.println("HEY START");
            int n2 = brokerProcess.start(true, properties, brokerEventListener, false);
            System.err.println("HEY STARTED");
            Thread.currentThread();
            Thread.sleep(10000L);
            System.out.println("HEY SHUTTING DOWN");
            brokerProcess.stop(true);
            System.out.println("Sleeping");
            Thread.currentThread();
            Thread.sleep(10000L);
            System.out.println("Restarting");
            n2 = brokerProcess.start(true, properties, null, false);
            System.out.println("Sleeping");
            Thread.currentThread();
            Thread.sleep(10000L);
            brokerProcess.stop(true);
            System.out.println("HEY SHUTTING DOWN");
            System.out.println("Sleeping");
            Thread.currentThread();
            Thread.sleep(60000L);
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

